/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.render.batch;

import com.clefal.nirvana_lib.client.render.batch.IFillBufferInfo;
import com.clefal.nirvana_lib.client.render.batch.TextureBufferInfo;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class VertexContainer {
    private HashMultimap<ResourceLocation, TextureBufferInfo> map = HashMultimap.create((int)10, (int)100);
    private List<IFillBufferInfo> fillBufferInfos = new ArrayList<IFillBufferInfo>();

    public VertexContainer() {
    }

    public VertexContainer(int expectedKeys, int expectedValuesPerKey) {
        this.map = HashMultimap.create((int)expectedKeys, (int)expectedValuesPerKey);
    }

    public void putBliz(ResourceLocation resourceLocation, TextureBufferInfo bufferInfo) {
        this.map.put((Object)resourceLocation, (Object)bufferInfo);
    }

    public void putFill(IFillBufferInfo fillBufferInfo) {
        this.fillBufferInfos.add(fillBufferInfo);
    }

    private void refresh() {
        this.map = HashMultimap.create((int)10, (int)100);
        this.fillBufferInfos = new ArrayList<IFillBufferInfo>();
    }

    public void draw(MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderTypeFunction) {
        RenderSystem.enableDepthTest();
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            RenderType statusRenderType = renderTypeFunction.apply(key);
            VertexConsumer buffer = bufferSource.m_6299_(statusRenderType);
            for (TextureBufferInfo bufferInfo : (Collection)entry.getValue()) {
                bufferInfo.upload(buffer);
            }
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_285907_());
        if (!this.fillBufferInfos.isEmpty()) {
            for (IFillBufferInfo fillBufferInfo : this.fillBufferInfos) {
                fillBufferInfo.upload(buffer);
            }
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_285907_());
        int color = FastColor.ARGB32.m_13660_((int)0, (int)0, (int)0, (int)0);
        vertexConsumer.m_5483_(0.0, 0.0, 0.0).m_193479_(color).m_5752_();
        vertexConsumer.m_5483_(0.0, 0.0, 0.0).m_193479_(color).m_5752_();
        vertexConsumer.m_5483_(0.0, 0.0, 0.0).m_193479_(color).m_5752_();
        vertexConsumer.m_5483_(0.0, 0.0, 0.0).m_193479_(color).m_5752_();
        RenderSystem.disableDepthTest();
        this.refresh();
    }
}

