/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.network.packets;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.config.BooleanValue;
import com.clefal.nirvana_lib.config.ConfigValue;
import com.clefal.nirvana_lib.config.IntegerValue;
import com.clefal.nirvana_lib.config.PersonalConfigData;
import com.clefal.nirvana_lib.config.StringListValue;
import com.clefal.nirvana_lib.config.SyncingPersonalConfig;
import com.clefal.nirvana_lib.network.newtoolchain.C2SModPacket;
import commonnetwork.networking.data.PacketContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class C2SSendSyncingConfigPacket
implements C2SModPacket<C2SSendSyncingConfigPacket> {
    public static ResourceLocation location = NirvanaLibConstants.id("send_syncing_config");
    private UUID player;
    private Map<String, ConfigValue<?>> map;

    public C2SSendSyncingConfigPacket(UUID player, Map<String, ConfigValue<?>> configs) {
        this.player = player;
        this.map = configs;
    }

    public C2SSendSyncingConfigPacket() {
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return location;
    }

    @Override
    public void handleServer(PacketContext<C2SSendSyncingConfigPacket> ctx) {
        C2SSendSyncingConfigPacket message = (C2SSendSyncingConfigPacket)ctx.message();
        PersonalConfigData data = SyncingPersonalConfig.INSTANCE.getData(message.player);
        for (Map.Entry<String, ConfigValue<?>> e : message.map.entrySet()) {
            data.configMap.merge(e.getKey(), e.getValue(), (old, newOne) -> newOne);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        ArrayList<Byte> tokens = new ArrayList<Byte>();
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            tokens.add(e.getValue().getToken());
        }
        buf.m_236828_(tokens, (buf1, aByte) -> buf1.writeByte((int)aByte.byteValue()));
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            buf.m_130070_(e.getKey());
            e.getValue().write(buf);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        List bytes = buf.m_236845_(FriendlyByteBuf::readByte);
        LinkedHashMap map = new LinkedHashMap();
        for (Byte token : bytes) {
            String key = buf.m_130277_();
            ConfigValue value = null;
            switch (token) {
                case 0: {
                    value = new BooleanValue(buf.readBoolean());
                    break;
                }
                case 1: {
                    value = new IntegerValue(Byte.valueOf(buf.readByte()).intValue());
                    break;
                }
                case 2: {
                    value = new StringListValue((List)buf.m_236838_(ArrayList::new, FriendlyByteBuf::m_130277_));
                }
            }
            if (value == null) {
                throw new RuntimeException("invalidated token: " + token);
            }
            map.put(key, value);
        }
        this.map = map;
    }

    @Generated
    public UUID getPlayer() {
        return this.player;
    }

    @Generated
    public Map<String, ConfigValue<?>> getMap() {
        return this.map;
    }
}

