/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq;

import dev.bwmp.modReq.ModReqCommand;
import dev.bwmp.modReq.config.ConfigManager;
import dev.bwmp.modReq.database.DatabaseManager;
import dev.bwmp.modReq.events.PlayerJoin;
import dev.bwmp.modReq.service.DiscordService;
import dev.bwmp.modReq.service.ModRequestService;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ModReq
extends JavaPlugin {
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private ModRequestService modRequestService;
    private DiscordService discordService;
    public static ModReq instance;

    public void onEnable() {
        instance = this;
        System.setProperty("dev.bwmp.modreq.libs.slf4j.simpleLogger.defaultLogLevel", "warn");
        this.configManager = new ConfigManager(this);
        this.databaseManager = new DatabaseManager(this);
        try {
            this.databaseManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize database. Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.modRequestService = new ModRequestService(this);
        this.discordService = new DiscordService(this);
        this.registerEvents();
        ModReqCommand commandHandler = new ModReqCommand(this);
        this.getCommand("modreq").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("modreq").setTabCompleter((TabCompleter)commandHandler);
        this.getLogger().info("ModReq plugin has been enabled!");
        this.getLogger().info("Database type: " + this.configManager.getString("database.type", "h2"));
        this.getLogger().info("Discord integration: " + (this.configManager.getBoolean("discord.enabled", false) ? "enabled" : "disabled"));
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.shutdown();
        }
        this.getLogger().info("ModReq plugin has been disabled!");
    }

    public void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)this);
    }

    public static ModReq getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ModRequestService getModRequestService() {
        return this.modRequestService;
    }

    public DiscordService getDiscordService() {
        return this.discordService;
    }
}

