/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq;

import dev.bwmp.modReq.ModReq;
import dev.bwmp.modReq.command.SubCommand;
import dev.bwmp.modReq.command.subcommands.ClaimCommand;
import dev.bwmp.modReq.command.subcommands.CloseCommand;
import dev.bwmp.modReq.command.subcommands.CreateCommand;
import dev.bwmp.modReq.command.subcommands.DoneCommand;
import dev.bwmp.modReq.command.subcommands.ElevateCommand;
import dev.bwmp.modReq.command.subcommands.HelpCommand;
import dev.bwmp.modReq.command.subcommands.InfoCommand;
import dev.bwmp.modReq.command.subcommands.ListCommand;
import dev.bwmp.modReq.command.subcommands.NoteCommand;
import dev.bwmp.modReq.command.subcommands.ReloadCommand;
import dev.bwmp.modReq.command.subcommands.TeleportCommand;
import dev.bwmp.modReq.command.subcommands.UnclaimCommand;
import dev.bwmp.modReq.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ModReqCommand
implements CommandExecutor,
TabCompleter {
    private final ModReq plugin;
    private final Map<String, SubCommand> subCommands;

    public ModReqCommand(ModReq plugin) {
        this.plugin = plugin;
        this.subCommands = new HashMap<String, SubCommand>();
        this.registerSubCommand(new CreateCommand(plugin));
        this.registerSubCommand(new ListCommand(plugin));
        this.registerSubCommand(new InfoCommand(plugin));
        this.registerSubCommand(new ClaimCommand(plugin));
        this.registerSubCommand(new UnclaimCommand(plugin));
        this.registerSubCommand(new DoneCommand(plugin));
        this.registerSubCommand(new CloseCommand(plugin));
        this.registerSubCommand(new ElevateCommand(plugin));
        this.registerSubCommand(new TeleportCommand(plugin));
        this.registerSubCommand(new NoteCommand(plugin));
        this.registerSubCommand(new ReloadCommand(plugin));
        this.registerSubCommand(new HelpCommand(plugin, this.subCommands));
    }

    private void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(), subCommand);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            SubCommand helpCommand = this.subCommands.get("help");
            if (helpCommand != null) {
                return helpCommand.execute(sender, new String[0]);
            }
            return true;
        }
        String subCommandName = args[0].toLowerCase();
        SubCommand subCommand = this.subCommands.get(subCommandName);
        if (subCommand != null) {
            if (!subCommand.hasPermission(sender)) {
                subCommand.sendNoPermission(sender);
                return true;
            }
            if (!subCommand.checkPlayer(sender)) {
                return true;
            }
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return subCommand.execute(sender, subArgs);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(TextUtil.error("Only players can create mod requests!"));
            return true;
        }
        if (!sender.hasPermission("modreq.use")) {
            sender.sendMessage(TextUtil.error("You don't have permission to create mod requests!"));
            return true;
        }
        CreateCommand createCommand = (CreateCommand)this.subCommands.get("create");
        if (createCommand != null) {
            return createCommand.execute(sender, args);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommandName;
        SubCommand subCommand;
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            return this.subCommands.keySet().stream().filter(name -> name.startsWith(partial)).filter(name -> this.subCommands.get(name).hasPermission(sender)).sorted().collect(Collectors.toList());
        }
        if (args.length > 1 && (subCommand = this.subCommands.get(subCommandName = args[0].toLowerCase())) != null && subCommand.hasPermission(sender)) {
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return subCommand.getTabCompletions(sender, subArgs);
        }
        return new ArrayList<String>();
    }
}

