/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.command;

import dev.bwmp.modReq.util.TextUtil;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class SubCommand {
    private final String name;
    private final String permission;
    private final String description;
    private final String usage;
    private final boolean requiresPlayer;

    public SubCommand(String name, String permission, String description, String usage, boolean requiresPlayer) {
        this.name = name;
        this.permission = permission;
        this.description = description;
        this.usage = usage;
        this.requiresPlayer = requiresPlayer;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public abstract List<String> getTabCompletions(CommandSender var1, String[] var2);

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean requiresPlayer() {
        return this.requiresPlayer;
    }

    public boolean hasPermission(CommandSender sender) {
        return this.permission == null || sender.hasPermission(this.permission);
    }

    public boolean checkPlayer(CommandSender sender) {
        if (this.requiresPlayer && !(sender instanceof Player)) {
            sender.sendMessage(TextUtil.error("This command can only be used by players!"));
            return false;
        }
        return true;
    }

    public void sendNoPermission(CommandSender sender) {
        sender.sendMessage(TextUtil.error("You don't have permission to use this command!"));
    }

    protected void sendUsage(CommandSender sender) {
        sender.sendMessage(TextUtil.error("Usage: " + this.usage));
    }
}

