/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.command.subcommands;

import dev.bwmp.modReq.ModReq;
import dev.bwmp.modReq.command.SubCommand;
import dev.bwmp.modReq.model.ModRequest;
import dev.bwmp.modReq.model.ModRequestNote;
import dev.bwmp.modReq.model.ModRequestStatus;
import dev.bwmp.modReq.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InfoCommand
extends SubCommand {
    private final ModReq plugin;

    public InfoCommand(ModReq plugin) {
        super("info", "modreq.use", "View detailed information about a mod request", "/modreq info <id>", false);
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        int requestId;
        if (args.length != 1) {
            this.sendUsage(sender);
            return true;
        }
        try {
            requestId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(TextUtil.error("Invalid request ID: " + args[0]));
            return true;
        }
        ((CompletableFuture)this.plugin.getModRequestService().getRequestWithNotes(requestId).thenAccept(request -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            boolean isOwner;
            if (request == null) {
                sender.sendMessage(TextUtil.error("Request #" + requestId + " not found."));
                return;
            }
            boolean canViewAll = sender.hasPermission("modreq.mod");
            boolean bl = isOwner = sender instanceof Player && ((Player)sender).getUniqueId().equals(request.getPlayerId());
            if (!canViewAll && !isOwner) {
                sender.sendMessage(TextUtil.error("You can only view your own requests!"));
                return;
            }
            this.displayRequestInfo(sender, (ModRequest)request);
        }))).exceptionally(throwable -> {
            sender.sendMessage(TextUtil.error("An error occurred while retrieving the request."));
            throwable.printStackTrace();
            return null;
        });
        return true;
    }

    private void displayRequestInfo(CommandSender sender, ModRequest request) {
        String statusColor = this.getStatusColor(request.getStatus());
        boolean isPlayer = sender instanceof Player;
        boolean isMod = sender.hasPermission("modreq.mod");
        boolean isAdmin = sender.hasPermission("modreq.admin");
        boolean isOwner = isPlayer && ((Player)sender).getUniqueId().equals(request.getPlayerId());
        boolean isClaimedByUser = isPlayer && request.isClaimed() && ((Player)sender).getUniqueId().equals(request.getClaimedBy());
        sender.sendMessage(TextUtil.highlight("\u2550\u2550\u2550 ModReq #" + request.getId() + " \u2550\u2550\u2550"));
        sender.sendMessage(TextUtil.info("Player: &f" + request.getPlayerName()));
        String statusText = statusColor + request.getStatus().name();
        if (request.isClaimed()) {
            statusText = statusText + " &7(claimed by &f" + request.getClaimedByName() + "&7)";
        }
        sender.sendMessage(TextUtil.info("Status: " + statusText));
        sender.sendMessage(Component.text((String)"Created: ", (TextColor)NamedTextColor.AQUA).append(TextUtil.relativeTime(request.getCreatedAt(), "&f")));
        sender.sendMessage(Component.text((String)"Updated: ", (TextColor)NamedTextColor.AQUA).append(TextUtil.relativeTime(request.getUpdatedAt(), "&f")));
        if (request.getClosedAt() != null) {
            Component closedComponent = Component.text((String)"Closed: ", (TextColor)NamedTextColor.AQUA).append(TextUtil.relativeTime(request.getClosedAt(), "&f"));
            if (request.getStatus() == ModRequestStatus.COMPLETED && request.getCompletedByName() != null) {
                closedComponent = closedComponent.append((Component)Component.text((String)" by ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)request.getCompletedByName(), (TextColor)NamedTextColor.WHITE));
            } else if (request.getStatus() == ModRequestStatus.CLOSED && request.getClosedByName() != null) {
                closedComponent = closedComponent.append((Component)Component.text((String)" by ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)request.getClosedByName(), (TextColor)NamedTextColor.WHITE));
            }
            sender.sendMessage(closedComponent);
        }
        sender.sendMessage(TextUtil.info("Description:"));
        sender.sendMessage(TextUtil.format("  &f" + request.getDescription()));
        if (request.getWorldName() != null) {
            Component locationText = ((TextComponent)Component.text((String)"Location: ", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)(request.getWorldName() + " "), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)("(" + String.format("%.0f, %.0f, %.0f", request.getX(), request.getY(), request.getZ()) + ")"), (TextColor)NamedTextColor.GRAY));
            if (isPlayer && isMod) {
                locationText = locationText.clickEvent(ClickEvent.runCommand((String)("/modreq teleport " + request.getId()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to teleport to this location", (TextColor)NamedTextColor.GREEN))).decorate(TextDecoration.UNDERLINED);
            }
            sender.sendMessage(locationText);
        }
        if (request.getNotes() != null && !request.getNotes().isEmpty()) {
            sender.sendMessage(TextUtil.info("Notes:"));
            for (ModRequestNote note : request.getNotes()) {
                Component noteComponent = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  [", (TextColor)NamedTextColor.GRAY).append(TextUtil.relativeTime(note.getCreatedAt(), "&7"))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)note.getAuthorName(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)note.getContent(), (TextColor)NamedTextColor.WHITE));
                sender.sendMessage(noteComponent);
            }
        } else {
            sender.sendMessage(TextUtil.info("Notes: &8None"));
        }
        if (isPlayer) {
            TextComponent actionBar = Component.empty();
            boolean hasActions = false;
            if (isMod) {
                if (!request.isClaimed()) {
                    actionBar = actionBar.append(((TextComponent)((TextComponent)Component.text((String)"[Claim]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.runCommand((String)("/modreq claim " + request.getId())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to claim this request", (TextColor)NamedTextColor.GREEN)))).decorate(TextDecoration.BOLD));
                    hasActions = true;
                } else if (isClaimedByUser) {
                    actionBar = actionBar.append(((TextComponent)((TextComponent)Component.text((String)"[Unclaim]", (TextColor)NamedTextColor.YELLOW).clickEvent(ClickEvent.runCommand((String)("/modreq unclaim " + request.getId())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to unclaim this request", (TextColor)NamedTextColor.YELLOW)))).decorate(TextDecoration.BOLD));
                    hasActions = true;
                } else if (isAdmin) {
                    actionBar = actionBar.append(((TextComponent)((TextComponent)Component.text((String)"[Force Claim]", (TextColor)NamedTextColor.RED).clickEvent(ClickEvent.runCommand((String)("/modreq claim " + request.getId() + " -f")))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to force claim this request", (TextColor)NamedTextColor.RED)))).decorate(TextDecoration.BOLD));
                    hasActions = true;
                }
                if (request.getStatus() != ModRequestStatus.COMPLETED && request.getStatus() != ModRequestStatus.CLOSED) {
                    if (hasActions) {
                        actionBar = actionBar.append((Component)Component.text((String)" ", (TextColor)NamedTextColor.WHITE));
                    }
                    actionBar = actionBar.append(((TextComponent)((TextComponent)Component.text((String)"[Mark Done]", (TextColor)NamedTextColor.BLUE).clickEvent(ClickEvent.runCommand((String)("/modreq done " + request.getId())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to mark this request as completed", (TextColor)NamedTextColor.BLUE)))).decorate(TextDecoration.BOLD));
                    hasActions = true;
                }
            }
            if (isOwner && request.getStatus() != ModRequestStatus.CLOSED) {
                if (hasActions) {
                    actionBar = actionBar.append((Component)Component.text((String)" ", (TextColor)NamedTextColor.WHITE));
                }
                actionBar = actionBar.append(((TextComponent)((TextComponent)Component.text((String)"[Close]", (TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.runCommand((String)("/modreq close " + request.getId())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to close this request", (TextColor)NamedTextColor.GRAY)))).decorate(TextDecoration.BOLD));
                hasActions = true;
            }
            if (hasActions) {
                sender.sendMessage((Component)Component.empty());
                sender.sendMessage(Component.text((String)"Actions: ", (TextColor)NamedTextColor.AQUA).append((Component)actionBar));
            }
        }
        sender.sendMessage(TextUtil.highlight("\u2550".repeat(20)));
    }

    private String getStatusColor(ModRequestStatus status) {
        switch (status) {
            case OPEN: {
                return "&a";
            }
            case ELEVATED: {
                return "&c";
            }
            case COMPLETED: {
                return "&2";
            }
            case CLOSED: {
                return "&8";
            }
        }
        return "&7";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        try {
            List<ModRequest> requests = this.plugin.getModRequestService().getOpenRequests().get();
            for (ModRequest request : requests) {
                completions.add(String.valueOf(request.getId()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting tab completions for claim command: " + e.getMessage());
        }
        return completions;
    }
}

