/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.command.subcommands;

import dev.bwmp.modReq.ModReq;
import dev.bwmp.modReq.command.SubCommand;
import dev.bwmp.modReq.model.ModRequest;
import dev.bwmp.modReq.model.ModRequestStatus;
import dev.bwmp.modReq.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ListCommand
extends SubCommand {
    private final ModReq plugin;

    public ListCommand(ModReq plugin) {
        super("list", "modreq.use", "List active mod requests. Use 'all' to include completed/closed requests.", "/modreq list [all|status|player] [page]", false);
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        ModRequestStatus filterStatus = null;
        String filterPlayer = null;
        boolean showAll = sender.hasPermission("modreq.mod");
        boolean showAllStatuses = false;
        int page = 1;
        for (String arg : args) {
            if (arg.equalsIgnoreCase("all")) {
                showAllStatuses = true;
                continue;
            }
            try {
                int parsedPage = Integer.parseInt(arg);
                if (parsedPage > 0) {
                    page = parsedPage;
                    continue;
                }
            }
            catch (NumberFormatException parsedPage) {
                // empty catch block
            }
            try {
                filterStatus = ModRequestStatus.valueOf(arg.toUpperCase());
            }
            catch (IllegalArgumentException parsedPage) {
                filterPlayer = arg;
            }
        }
        if (!showAll && filterPlayer == null && sender instanceof Player) {
            filterPlayer = sender.getName();
        }
        String finalFilterPlayer = filterPlayer;
        ModRequestStatus finalFilterStatus = filterStatus;
        boolean finalShowAllStatuses = showAllStatuses;
        int finalPage = page;
        CompletableFuture<List<ModRequest>> requestsFuture = finalFilterStatus != null || finalShowAllStatuses ? this.plugin.getModRequestService().getRequests(finalFilterStatus, finalFilterPlayer) : (finalFilterPlayer != null && !finalFilterPlayer.isEmpty() ? this.plugin.getModRequestService().getRequests(null, finalFilterPlayer) : this.plugin.getModRequestService().getActiveRequests(finalFilterPlayer));
        ((CompletableFuture)requestsFuture.thenAccept(requests -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            if (requests.isEmpty()) {
                if (finalFilterStatus != null || finalFilterPlayer != null) {
                    sender.sendMessage(TextUtil.info("No mod requests found matching your criteria."));
                } else {
                    sender.sendMessage(TextUtil.info("No mod requests found."));
                }
                return;
            }
            this.displayPaginatedRequests(sender, (List<ModRequest>)requests, finalPage, finalFilterStatus, finalFilterPlayer, finalShowAllStatuses);
        }))).exceptionally(throwable -> {
            sender.sendMessage(TextUtil.error("Failed to load mod requests."));
            throwable.printStackTrace();
            return null;
        });
        return true;
    }

    private void displayPaginatedRequests(CommandSender sender, List<ModRequest> allRequests, int page, ModRequestStatus filterStatus, String filterPlayer, boolean showAllStatuses) {
        if (filterPlayer != null && !filterPlayer.isEmpty()) {
            allRequests.sort((r1, r2) -> {
                boolean r2IsOpen;
                boolean r1IsOpen = r1.getStatus() == ModRequestStatus.OPEN || r1.getStatus() == ModRequestStatus.ELEVATED;
                boolean bl = r2IsOpen = r2.getStatus() == ModRequestStatus.OPEN || r2.getStatus() == ModRequestStatus.ELEVATED;
                if (r1IsOpen && !r2IsOpen) {
                    return -1;
                }
                if (!r1IsOpen && r2IsOpen) {
                    return 1;
                }
                return r2.getCreatedAt().compareTo(r1.getCreatedAt());
            });
        }
        int pageSize = this.plugin.getConfigManager().getListPageSize();
        int totalRequests = allRequests.size();
        int totalPages = (int)Math.ceil((double)totalRequests / (double)pageSize);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        int startIndex = (page - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, totalRequests);
        Object filterDescription = "";
        if (filterStatus != null) {
            filterDescription = (String)filterDescription + " [" + filterStatus.name() + "]";
        }
        if (filterPlayer != null) {
            filterDescription = (String)filterDescription + " [Player: " + filterPlayer + "]";
        }
        if (showAllStatuses) {
            filterDescription = (String)filterDescription + " [All Statuses]";
        } else if (filterPlayer != null && !filterPlayer.isEmpty()) {
            filterDescription = (String)filterDescription + " [Open First]";
        }
        sender.sendMessage(TextUtil.highlight("=== Mod Requests" + (String)filterDescription + " (Page " + page + "/" + totalPages + ") ==="));
        List<ModRequest> pageRequests = allRequests.subList(startIndex, endIndex);
        for (ModRequest request : pageRequests) {
            Component requestLine = ((TextComponent)Component.text((String)("#" + request.getId() + " "), (TextColor)NamedTextColor.WHITE).append((Component)Component.text((String)("[" + request.getStatus().name() + "] "), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)request.getPlayerName(), (TextColor)NamedTextColor.WHITE));
            if (request.isClaimed()) {
                requestLine = requestLine.append((Component)Component.text((String)" (claimed by ", (TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)request.getClaimedByName(), (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY));
            }
            requestLine = requestLine.clickEvent(ClickEvent.runCommand((String)("/modreq info " + request.getId()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to view request details", (TextColor)NamedTextColor.GREEN)));
            sender.sendMessage(requestLine);
            Component timeAndDesc = ((TextComponent)Component.text((String)"  ", (TextColor)NamedTextColor.GRAY).append(TextUtil.relativeTime(request.getCreatedAt(), "&7"))).append((Component)Component.text((String)(" - " + request.getDescription()), (TextColor)NamedTextColor.AQUA));
            sender.sendMessage(timeAndDesc);
            if (request.getWorldName() == null) continue;
            sender.sendMessage(TextUtil.info("  Location: " + request.getWorldName() + " " + String.format("%.0f,%.0f,%.0f", request.getX(), request.getY(), request.getZ())));
        }
        if (totalPages > 1) {
            TextComponent navigation = Component.empty();
            if (page > 1) {
                String prevCommand = this.buildPageCommand(page - 1, filterStatus, filterPlayer, showAllStatuses);
                navigation = navigation.append(((TextComponent)Component.text((String)"[\u2190 Previous] ", (TextColor)NamedTextColor.YELLOW).clickEvent(ClickEvent.runCommand((String)prevCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (page - 1)), (TextColor)NamedTextColor.GREEN))));
            }
            navigation = navigation.append((Component)Component.text((String)("Page " + page + "/" + totalPages + " "), (TextColor)NamedTextColor.GRAY));
            if (page < totalPages) {
                String nextCommand = this.buildPageCommand(page + 1, filterStatus, filterPlayer, showAllStatuses);
                navigation = navigation.append(((TextComponent)Component.text((String)"[Next \u2192]", (TextColor)NamedTextColor.YELLOW).clickEvent(ClickEvent.runCommand((String)nextCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (page + 1)), (TextColor)NamedTextColor.GREEN))));
            }
            sender.sendMessage((Component)navigation);
        }
        sender.sendMessage(TextUtil.info("Showing " + pageRequests.size() + " of " + totalRequests + " requests"));
    }

    private String buildPageCommand(int page, ModRequestStatus filterStatus, String filterPlayer, boolean showAllStatuses) {
        StringBuilder command = new StringBuilder("/modreq list");
        if (showAllStatuses) {
            command.append(" all");
        }
        if (filterStatus != null) {
            command.append(" ").append(filterStatus.name().toLowerCase());
        }
        if (filterPlayer != null && !filterPlayer.isEmpty()) {
            command.append(" ").append(filterPlayer);
        }
        command.append(" ").append(page);
        return command.toString();
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            if ("all".startsWith(partial)) {
                completions.add("all");
            }
            for (ModRequestStatus status : ModRequestStatus.values()) {
                if (!status.name().toLowerCase().startsWith(partial)) continue;
                completions.add(status.name().toLowerCase());
            }
            if (sender.hasPermission("modreq.mod")) {
                this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partial)).forEach(completions::add);
            }
        } else if (args.length == 2) {
            completions.add("1");
            completions.add("2");
            completions.add("3");
        }
        return completions;
    }
}

