/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.command.subcommands;

import dev.bwmp.modReq.ModReq;
import dev.bwmp.modReq.command.SubCommand;
import dev.bwmp.modReq.model.ModRequest;
import dev.bwmp.modReq.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeleportCommand
extends SubCommand {
    private final ModReq plugin;

    public TeleportCommand(ModReq plugin) {
        super("teleport", "modreq.teleport", "Teleport to a mod request location", "/modreq teleport <id>", true);
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        int requestId;
        if (args.length != 1) {
            this.sendUsage(sender);
            return true;
        }
        try {
            requestId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(TextUtil.error("Invalid request ID: " + args[0]));
            return true;
        }
        Player player = (Player)sender;
        ((CompletableFuture)this.plugin.getModRequestService().getRequest(requestId).thenAccept(request -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            if (request == null) {
                player.sendMessage(TextUtil.error("Request #" + requestId + " not found."));
                return;
            }
            Location location = request.getLocation();
            if (location == null) {
                player.sendMessage(TextUtil.error("No location data for request #" + requestId + " or world not loaded."));
                return;
            }
            location.add(0.0, 1.0, 0.0);
            player.teleport(location);
            player.sendMessage(TextUtil.success("Teleported to request #" + requestId + " by &f" + request.getPlayerName()));
            player.sendMessage(TextUtil.info("Description: &f" + request.getDescription()));
        }))).exceptionally(throwable -> {
            player.sendMessage(TextUtil.error("An error occurred while getting the request location."));
            throwable.printStackTrace();
            return null;
        });
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            try {
                List<ModRequest> requests = this.plugin.getModRequestService().getOpenRequests().get();
                Player player = (Player)sender;
                for (ModRequest request : requests) {
                    if (request.getClaimedBy() == null || !request.getClaimedBy().equals(player.getUniqueId())) continue;
                    completions.add(String.valueOf(request.getId()));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error getting tab completions for unclaim command: " + e.getMessage());
            }
        }
        return completions;
    }
}

