/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.config;

import dev.bwmp.modReq.ModReq;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ModReq plugin;
    private FileConfiguration config;
    private final MiniMessage miniMessage;
    private final LegacyComponentSerializer legacySerializer;

    public ConfigManager(ModReq plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.legacySerializer = LegacyComponentSerializer.legacyAmpersand();
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public Component getMessageComponent(String key) {
        String message = this.getString("messages." + key, "Message not found: " + key);
        if (message.contains("<") && message.contains(">")) {
            return this.miniMessage.deserialize((Object)message);
        }
        return this.legacySerializer.deserialize(message);
    }

    public String getMessage(String key) {
        Component component = this.getMessageComponent(key);
        return this.legacySerializer.serialize(component);
    }

    public Component getFormattedMessageComponent(String key, Object ... replacements) {
        String message = this.getString("messages." + key, "Message not found: " + key);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            String placeholder = "{" + String.valueOf(replacements[i]) + "}";
            String value = String.valueOf(replacements[i + 1]);
            message = message.replace(placeholder, value);
        }
        if (message.contains("<") && message.contains(">")) {
            return this.miniMessage.deserialize((Object)message);
        }
        return this.legacySerializer.deserialize(message);
    }

    public String getFormattedMessage(String key, Object ... replacements) {
        Component component = this.getFormattedMessageComponent(key, replacements);
        return this.legacySerializer.serialize(component);
    }

    public int getListPageSize() {
        return this.getInt("settings.list_page_size", 10);
    }
}

