/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.database;

import dev.bwmp.modReq.ModReq;
import dev.bwmp.modReq.database.DatabaseMigrations;
import dev.bwmp.modReq.model.ModRequest;
import dev.bwmp.modReq.model.ModRequestNote;
import dev.bwmp.modReq.model.ModRequestStatus;
import dev.bwmp.modreq.libs.hikari.HikariConfig;
import dev.bwmp.modreq.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;

public class DatabaseManager {
    private final ModReq plugin;
    private HikariDataSource dataSource;
    private final String databaseType;

    public DatabaseManager(ModReq plugin) {
        this.plugin = plugin;
        this.databaseType = plugin.getConfigManager().getString("database.type", "h2").toLowerCase();
    }

    public void initialize() {
        try {
            this.setupDataSource();
            this.createTables();
            DatabaseMigrations migrations = new DatabaseMigrations(this.plugin, this);
            migrations.checkAndMigrate();
            this.plugin.getLogger().info("Database initialized successfully using " + this.databaseType.toUpperCase());
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
            throw new RuntimeException("Database initialization failed", e);
        }
    }

    private void setupDataSource() {
        HikariConfig config = new HikariConfig();
        switch (this.databaseType) {
            case "h2": {
                String dbFile = this.plugin.getConfigManager().getString("database.file", "modreq.db");
                String jdbcUrl = "jdbc:h2:file:" + this.plugin.getDataFolder().getAbsolutePath() + "/" + dbFile + ";MODE=MySQL;AUTO_RECONNECT=TRUE";
                config.setJdbcUrl(jdbcUrl);
                config.setDriverClassName("dev.bwmp.modreq.libs.h2.Driver");
                config.setUsername("sa");
                config.setPassword("");
                break;
            }
            case "mysql": {
                String host = this.plugin.getConfigManager().getString("database.host", "localhost");
                int port = this.plugin.getConfigManager().getInt("database.port", 3306);
                String database = this.plugin.getConfigManager().getString("database.database", "modreq");
                String username = this.plugin.getConfigManager().getString("database.username", "root");
                String password = this.plugin.getConfigManager().getString("database.password", "");
                String jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&serverTimezone=UTC&autoReconnect=true", host, port, database);
                config.setJdbcUrl(jdbcUrl);
                config.setDriverClassName("dev.bwmp.modreq.libs.mysql.cj.jdbc.Driver");
                config.setUsername(username);
                config.setPassword(password);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported database type: " + this.databaseType);
            }
        }
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(600000L);
        config.setMaxLifetime(1800000L);
        config.setMaximumPoolSize(10);
        config.setMinimumIdle(2);
        config.setPoolName("ModReq-CP");
        config.setConnectionTestQuery("SELECT 1");
        this.dataSource = new HikariDataSource(config);
    }

    private void createTables() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();){
            String createRequestsTable = "CREATE TABLE IF NOT EXISTS mod_requests (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    player_id VARCHAR(36) NOT NULL,\n    player_name VARCHAR(16) NOT NULL,\n    description TEXT NOT NULL,\n    status VARCHAR(20) NOT NULL DEFAULT 'OPEN',\n    claimed_by VARCHAR(36),\n    claimed_by_name VARCHAR(16),\n    closed_by VARCHAR(36),\n    closed_by_name VARCHAR(16),\n    completed_by VARCHAR(36),\n    completed_by_name VARCHAR(16),\n    world_name VARCHAR(50),\n    x DOUBLE,\n    y DOUBLE,\n    z DOUBLE,\n    yaw FLOAT,\n    pitch FLOAT,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n    closed_at TIMESTAMP NULL,\n    INDEX idx_player_id (player_id),\n    INDEX idx_status (status),\n    INDEX idx_claimed_by (claimed_by),\n    INDEX idx_closed_by (closed_by),\n    INDEX idx_completed_by (completed_by),\n    INDEX idx_created_at (created_at),\n    INDEX idx_updated_at (updated_at)\n)\n";
            String createNotesTable = "CREATE TABLE IF NOT EXISTS mod_request_notes (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    request_id INT NOT NULL,\n    author_id VARCHAR(36) NOT NULL,\n    author_name VARCHAR(16) NOT NULL,\n    content TEXT NOT NULL,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    FOREIGN KEY (request_id) REFERENCES mod_requests(id) ON DELETE CASCADE,\n    INDEX idx_request_id (request_id),\n    INDEX idx_author_id (author_id)\n)\n";
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate(createRequestsTable);
                stmt.executeUpdate(createNotesTable);
            }
        }
    }

    public void shutdown() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("Database connection pool closed");
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public CompletableFuture<ModRequest> createRequest(ModRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "INSERT INTO mod_requests (player_id, player_name, description, status, world_name, x, y, z, yaw, pitch, created_at, updated_at)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
            try (Connection conn = this.dataSource.getConnection();){
                ModRequest modRequest;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(sql, 1);
                    try {
                        stmt.setString(1, request.getPlayerId().toString());
                        stmt.setString(2, request.getPlayerName());
                        stmt.setString(3, request.getDescription());
                        stmt.setString(4, request.getStatus().name());
                        stmt.setString(5, request.getWorldName());
                        stmt.setDouble(6, request.getX());
                        stmt.setDouble(7, request.getY());
                        stmt.setDouble(8, request.getZ());
                        stmt.setFloat(9, request.getYaw());
                        stmt.setFloat(10, request.getPitch());
                        stmt.setTimestamp(11, Timestamp.valueOf(request.getCreatedAt()));
                        stmt.setTimestamp(12, Timestamp.valueOf(request.getUpdatedAt()));
                        stmt.executeUpdate();
                        try (ResultSet keys = stmt.getGeneratedKeys();){
                            if (keys.next()) {
                                request.setId(keys.getInt(1));
                            }
                        }
                        modRequest = request;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return modRequest;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to create mod request", e);
                throw new RuntimeException("Failed to create mod request", e);
            }
        });
    }

    public CompletableFuture<Void> updateRequest(ModRequest request) {
        return CompletableFuture.runAsync(() -> {
            String sql = "UPDATE mod_requests SET\n    description = ?, status = ?, claimed_by = ?, claimed_by_name = ?,\n    closed_by = ?, closed_by_name = ?, completed_by = ?, completed_by_name = ?,\n    world_name = ?, x = ?, y = ?, z = ?, yaw = ?, pitch = ?,\n    updated_at = ?, closed_at = ?\nWHERE id = ?\n";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, request.getDescription());
                stmt.setString(2, request.getStatus().name());
                stmt.setString(3, request.getClaimedBy() != null ? request.getClaimedBy().toString() : null);
                stmt.setString(4, request.getClaimedByName());
                stmt.setString(5, request.getClosedBy() != null ? request.getClosedBy().toString() : null);
                stmt.setString(6, request.getClosedByName());
                stmt.setString(7, request.getCompletedBy() != null ? request.getCompletedBy().toString() : null);
                stmt.setString(8, request.getCompletedByName());
                stmt.setString(9, request.getWorldName());
                stmt.setDouble(10, request.getX());
                stmt.setDouble(11, request.getY());
                stmt.setDouble(12, request.getZ());
                stmt.setFloat(13, request.getYaw());
                stmt.setFloat(14, request.getPitch());
                stmt.setTimestamp(15, Timestamp.valueOf(request.getUpdatedAt()));
                stmt.setTimestamp(16, request.getClosedAt() != null ? Timestamp.valueOf(request.getClosedAt()) : null);
                stmt.setInt(17, request.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to update mod request", e);
                throw new RuntimeException("Failed to update mod request", e);
            }
        });
    }

    public CompletableFuture<ModRequest> getRequest(int id) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM mod_requests WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();){
                ModRequest modRequest;
                block25: {
                    ResultSet rs;
                    PreparedStatement stmt;
                    block22: {
                        ModRequest modRequest2;
                        block24: {
                            block23: {
                                stmt = conn.prepareStatement(sql);
                                stmt.setInt(1, id);
                                rs = stmt.executeQuery();
                                if (!rs.next()) break block22;
                                ModRequest request = this.mapResultSetToRequest(rs);
                                request.setNotes(this.getRequestNotesSync(id));
                                modRequest2 = request;
                                if (rs == null) break block23;
                                rs.close();
                            }
                            if (stmt == null) break block24;
                            stmt.close();
                        }
                        return modRequest2;
                    }
                    try {
                        block26: {
                            if (rs != null) {
                                rs.close();
                            }
                            break block26;
                            {
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        modRequest = null;
                        if (stmt == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return modRequest;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get mod request", e);
                throw new RuntimeException("Failed to get mod request", e);
            }
        });
    }

    public CompletableFuture<List<ModRequest>> getRequestsByPlayer(UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM mod_requests WHERE player_id = ? ORDER BY created_at DESC";
            try (Connection conn = this.dataSource.getConnection();){
                ArrayList<ModRequest> arrayList;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        stmt.setString(1, playerId.toString());
                        ArrayList<ModRequest> requests = new ArrayList<ModRequest>();
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                ModRequest request = this.mapResultSetToRequest(rs);
                                request.setNotes(this.getRequestNotesSync(request.getId()));
                                requests.add(request);
                            }
                        }
                        arrayList = requests;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return arrayList;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get player requests", e);
                throw new RuntimeException("Failed to get player requests", e);
            }
        });
    }

    public CompletableFuture<List<ModRequest>> getRequestsByStatus(ModRequestStatus status) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM mod_requests WHERE status = ? ORDER BY created_at ASC";
            try (Connection conn = this.dataSource.getConnection();){
                ArrayList<ModRequest> arrayList;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        stmt.setString(1, status.name());
                        ArrayList<ModRequest> requests = new ArrayList<ModRequest>();
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                ModRequest request = this.mapResultSetToRequest(rs);
                                request.setNotes(this.getRequestNotesSync(request.getId()));
                                requests.add(request);
                            }
                        }
                        arrayList = requests;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return arrayList;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get requests by status", e);
                throw new RuntimeException("Failed to get requests by status", e);
            }
        });
    }

    public CompletableFuture<List<ModRequest>> getOpenRequestsByPlayer(UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT * FROM mod_requests WHERE player_id = ? AND status IN ('OPEN', 'CLAIMED', 'ELEVATED') ORDER BY created_at DESC";
            try (Connection conn = this.dataSource.getConnection();){
                ArrayList<ModRequest> arrayList;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        stmt.setString(1, playerId.toString());
                        ArrayList<ModRequest> requests = new ArrayList<ModRequest>();
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                ModRequest request = this.mapResultSetToRequest(rs);
                                request.setNotes(this.getRequestNotesSync(request.getId()));
                                requests.add(request);
                            }
                        }
                        arrayList = requests;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return arrayList;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to get open player requests", e);
                throw new RuntimeException("Failed to get open player requests", e);
            }
        });
    }

    public CompletableFuture<Integer> countOpenRequestsByPlayer(UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT COUNT(*) FROM mod_requests WHERE player_id = ? AND status IN ('OPEN', 'CLAIMED', 'ELEVATED')";
            try (Connection conn = this.dataSource.getConnection();){
                Integer n;
                block25: {
                    ResultSet rs;
                    PreparedStatement stmt;
                    block22: {
                        Integer n2;
                        block24: {
                            block23: {
                                stmt = conn.prepareStatement(sql);
                                stmt.setString(1, playerId.toString());
                                rs = stmt.executeQuery();
                                if (!rs.next()) break block22;
                                n2 = rs.getInt(1);
                                if (rs == null) break block23;
                                rs.close();
                            }
                            if (stmt == null) break block24;
                            stmt.close();
                        }
                        return n2;
                    }
                    try {
                        block26: {
                            if (rs != null) {
                                rs.close();
                            }
                            break block26;
                            {
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        n = 0;
                        if (stmt == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return n;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to count player requests", e);
                throw new RuntimeException("Failed to count player requests", e);
            }
        });
    }

    public CompletableFuture<ModRequestNote> addNote(ModRequestNote note) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "INSERT INTO mod_request_notes (request_id, author_id, author_name, content, created_at) VALUES (?, ?, ?, ?, ?)";
            try (Connection conn = this.dataSource.getConnection();){
                ModRequestNote modRequestNote;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(sql, 1);
                    try {
                        stmt.setInt(1, note.getRequestId());
                        stmt.setString(2, note.getAuthorId().toString());
                        stmt.setString(3, note.getAuthorName());
                        stmt.setString(4, note.getContent());
                        stmt.setTimestamp(5, Timestamp.valueOf(note.getCreatedAt()));
                        stmt.executeUpdate();
                        try (ResultSet keys = stmt.getGeneratedKeys();){
                            if (keys.next()) {
                                note.setId(keys.getInt(1));
                            }
                        }
                        modRequestNote = note;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return modRequestNote;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to add note", e);
                throw new RuntimeException("Failed to add note", e);
            }
        });
    }

    private List<ModRequestNote> getRequestNotesSync(int requestId) throws SQLException {
        String sql = "SELECT * FROM mod_request_notes WHERE request_id = ? ORDER BY created_at ASC";
        try (Connection conn = this.dataSource.getConnection();){
            ArrayList<ModRequestNote> arrayList;
            block20: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, requestId);
                    ArrayList<ModRequestNote> notes = new ArrayList<ModRequestNote>();
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            notes.add(this.mapResultSetToNote(rs));
                        }
                    }
                    arrayList = notes;
                    if (stmt == null) break block20;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
    }

    private ModRequest mapResultSetToRequest(ResultSet rs) throws SQLException {
        Timestamp closedAt;
        Timestamp updatedAt;
        ModRequest request = new ModRequest();
        request.setId(rs.getInt("id"));
        request.setPlayerId(UUID.fromString(rs.getString("player_id")));
        request.setPlayerName(rs.getString("player_name"));
        request.setDescription(rs.getString("description"));
        request.setStatus(ModRequestStatus.valueOf(rs.getString("status")));
        String claimedByStr = rs.getString("claimed_by");
        if (claimedByStr != null) {
            request.setClaimedBy(UUID.fromString(claimedByStr));
        }
        request.setClaimedByName(rs.getString("claimed_by_name"));
        String closedByStr = rs.getString("closed_by");
        if (closedByStr != null) {
            request.setClosedBy(UUID.fromString(closedByStr));
        }
        request.setClosedByName(rs.getString("closed_by_name"));
        String completedByStr = rs.getString("completed_by");
        if (completedByStr != null) {
            request.setCompletedBy(UUID.fromString(completedByStr));
        }
        request.setCompletedByName(rs.getString("completed_by_name"));
        request.setWorldName(rs.getString("world_name"));
        request.setX(rs.getDouble("x"));
        request.setY(rs.getDouble("y"));
        request.setZ(rs.getDouble("z"));
        request.setYaw(rs.getFloat("yaw"));
        request.setPitch(rs.getFloat("pitch"));
        Timestamp createdAt = rs.getTimestamp("created_at");
        if (createdAt != null) {
            request.setCreatedAt(createdAt.toLocalDateTime());
        }
        if ((updatedAt = rs.getTimestamp("updated_at")) != null) {
            request.setUpdatedAt(updatedAt.toLocalDateTime());
        }
        if ((closedAt = rs.getTimestamp("closed_at")) != null) {
            request.setClosedAt(closedAt.toLocalDateTime());
        }
        return request;
    }

    private ModRequestNote mapResultSetToNote(ResultSet rs) throws SQLException {
        ModRequestNote note = new ModRequestNote();
        note.setId(rs.getInt("id"));
        note.setRequestId(rs.getInt("request_id"));
        note.setAuthorId(UUID.fromString(rs.getString("author_id")));
        note.setAuthorName(rs.getString("author_name"));
        note.setContent(rs.getString("content"));
        Timestamp createdAt = rs.getTimestamp("created_at");
        if (createdAt != null) {
            note.setCreatedAt(createdAt.toLocalDateTime());
        }
        return note;
    }
}

