/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.database;

import dev.bwmp.modReq.ModReq;
import dev.bwmp.modReq.database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class DatabaseMigrations {
    private final ModReq plugin;
    private final DatabaseManager databaseManager;
    private static final int CURRENT_SCHEMA_VERSION = 3;

    public DatabaseMigrations(ModReq plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
    }

    public void checkAndMigrate() throws SQLException {
        this.createSchemaVersionTable();
        int currentVersion = this.getCurrentSchemaVersion();
        this.plugin.getLogger().info("Current database schema version: " + currentVersion);
        if (currentVersion < 3) {
            this.plugin.getLogger().info("Migrating database from version " + currentVersion + " to 3");
            this.performMigrations(currentVersion);
            this.updateSchemaVersion(3);
            this.plugin.getLogger().info("Database migration completed successfully");
        }
    }

    private void createSchemaVersionTable() throws SQLException {
        block24: {
            String sql = "CREATE TABLE IF NOT EXISTS schema_version (\n    version INT NOT NULL,\n    applied_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n)\n";
            try (Connection conn = this.databaseManager.getConnection();
                 Statement stmt = conn.createStatement();){
                stmt.executeUpdate(sql);
                try (PreparedStatement checkStmt = conn.prepareStatement("SELECT COUNT(*) FROM schema_version");){
                    ResultSet rs = checkStmt.executeQuery();
                    if (!rs.next() || rs.getInt(1) != 0) break block24;
                    try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO schema_version (version) VALUES (0)");){
                        insertStmt.executeUpdate();
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int getCurrentSchemaVersion() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateSchemaVersion(int version) throws SQLException {
        String sql = "INSERT INTO schema_version (version) VALUES (?)";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, version);
            stmt.executeUpdate();
        }
    }

    private void performMigrations(int fromVersion) throws SQLException {
        block5: for (int version = fromVersion + 1; version <= 3; ++version) {
            this.plugin.getLogger().info("Applying migration for version " + version);
            switch (version) {
                case 1: {
                    this.migrateToVersion1();
                    continue block5;
                }
                case 2: {
                    this.migrateToVersion2();
                    continue block5;
                }
                case 3: {
                    this.migrateToVersion3();
                    continue block5;
                }
                default: {
                    this.plugin.getLogger().warning("Unknown migration version: " + version);
                }
            }
        }
    }

    private void migrateToVersion1() throws SQLException {
        this.plugin.getLogger().info("Migration to version 1: Initial schema creation completed");
    }

    private void migrateToVersion2() throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             Statement stmt = conn.createStatement();){
            int updatedRows = stmt.executeUpdate("UPDATE mod_requests SET status = 'OPEN' WHERE status = 'CLAIMED'");
            if (updatedRows > 0) {
                this.plugin.getLogger().info("Converted " + updatedRows + " CLAIMED requests to OPEN status");
            }
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_requests_updated_at ON mod_requests(updated_at)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_notes_created_at ON mod_request_notes(created_at)");
            this.plugin.getLogger().info("Migration to version 2: Converted CLAIMED status and added performance indices");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to migrate to version 2", e);
            throw e;
        }
    }

    private void migrateToVersion3() throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("ALTER TABLE mod_requests ADD COLUMN IF NOT EXISTS closed_by VARCHAR(36)");
            stmt.executeUpdate("ALTER TABLE mod_requests ADD COLUMN IF NOT EXISTS closed_by_name VARCHAR(16)");
            stmt.executeUpdate("ALTER TABLE mod_requests ADD COLUMN IF NOT EXISTS completed_by VARCHAR(36)");
            stmt.executeUpdate("ALTER TABLE mod_requests ADD COLUMN IF NOT EXISTS completed_by_name VARCHAR(16)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_requests_closed_by ON mod_requests(closed_by)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_requests_completed_by ON mod_requests(completed_by)");
            this.plugin.getLogger().info("Migration to version 3: Added tracking for who closed/completed requests");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to migrate to version 3", e);
            throw e;
        }
    }
}

