/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.model;

import dev.bwmp.modReq.model.ModRequestNote;
import dev.bwmp.modReq.model.ModRequestStatus;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class ModRequest {
    private int id;
    private UUID playerId;
    private String playerName;
    private String description;
    private ModRequestStatus status = ModRequestStatus.OPEN;
    private UUID claimedBy;
    private String claimedByName;
    private UUID closedBy;
    private String closedByName;
    private UUID completedBy;
    private String completedByName;
    private LocalDateTime createdAt = LocalDateTime.now();
    private LocalDateTime updatedAt = LocalDateTime.now();
    private LocalDateTime closedAt;
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private List<ModRequestNote> notes = new ArrayList<ModRequestNote>();

    public ModRequest() {
    }

    public ModRequest(UUID playerId, String playerName, String description, Location location) {
        this();
        this.playerId = playerId;
        this.playerName = playerName;
        this.description = description;
        if (location != null) {
            this.worldName = location.getWorld().getName();
            this.x = location.getX();
            this.y = location.getY();
            this.z = location.getZ();
            this.yaw = location.getYaw();
            this.pitch = location.getPitch();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ModRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ModRequestStatus status) {
        this.status = status;
        this.updatedAt = LocalDateTime.now();
        if (status == ModRequestStatus.CLOSED || status == ModRequestStatus.COMPLETED) {
            this.closedAt = LocalDateTime.now();
        }
    }

    public UUID getClaimedBy() {
        return this.claimedBy;
    }

    public void setClaimedBy(UUID claimedBy) {
        this.claimedBy = claimedBy;
    }

    public String getClaimedByName() {
        return this.claimedByName;
    }

    public void setClaimedByName(String claimedByName) {
        this.claimedByName = claimedByName;
    }

    public UUID getClosedBy() {
        return this.closedBy;
    }

    public void setClosedBy(UUID closedBy) {
        this.closedBy = closedBy;
    }

    public String getClosedByName() {
        return this.closedByName;
    }

    public void setClosedByName(String closedByName) {
        this.closedByName = closedByName;
    }

    public UUID getCompletedBy() {
        return this.completedBy;
    }

    public void setCompletedBy(UUID completedBy) {
        this.completedBy = completedBy;
    }

    public String getCompletedByName() {
        return this.completedByName;
    }

    public void setCompletedByName(String completedByName) {
        this.completedByName = completedByName;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public LocalDateTime getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(LocalDateTime closedAt) {
        this.closedAt = closedAt;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public List<ModRequestNote> getNotes() {
        return this.notes;
    }

    public void setNotes(List<ModRequestNote> notes) {
        this.notes = notes;
    }

    public Location getLocation() {
        if (this.worldName == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public void setLocation(Location location) {
        if (location == null) {
            this.worldName = null;
            return;
        }
        this.worldName = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
    }

    public boolean isClaimed() {
        return this.claimedBy != null;
    }

    public boolean isOpen() {
        return this.status == ModRequestStatus.OPEN || this.status == ModRequestStatus.ELEVATED;
    }

    public void claim(UUID staffId, String staffName) {
        this.claimedBy = staffId;
        this.claimedByName = staffName;
        this.updatedAt = LocalDateTime.now();
    }

    public void unclaim() {
        this.claimedBy = null;
        this.claimedByName = null;
        this.updatedAt = LocalDateTime.now();
    }

    public void elevate() {
        this.status = ModRequestStatus.ELEVATED;
        this.updatedAt = LocalDateTime.now();
    }

    public void complete() {
        this.status = ModRequestStatus.COMPLETED;
        this.updatedAt = LocalDateTime.now();
        this.closedAt = LocalDateTime.now();
    }

    public void complete(UUID completerId, String completerName) {
        this.status = ModRequestStatus.COMPLETED;
        this.completedBy = completerId;
        this.completedByName = completerName;
        this.closedAt = LocalDateTime.now();
        this.updatedAt = LocalDateTime.now();
    }

    public void close() {
        this.status = ModRequestStatus.CLOSED;
        this.updatedAt = LocalDateTime.now();
        this.closedAt = LocalDateTime.now();
    }

    public void close(UUID closerId, String closerName) {
        this.status = ModRequestStatus.CLOSED;
        this.closedBy = closerId;
        this.closedByName = closerName;
        this.closedAt = LocalDateTime.now();
        this.updatedAt = LocalDateTime.now();
    }

    public String toString() {
        return String.format("ModRequest{id=%d, player=%s, status=%s, description='%s'}", new Object[]{this.id, this.playerName, this.status, this.description});
    }
}

