/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modReq.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class TextUtil {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacyAmpersand().toBuilder()).character('&').hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public static Component format(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        if (text.contains("<") && text.contains(">")) {
            try {
                return MINI_MESSAGE.deserialize((Object)text);
            }
            catch (Exception e) {
                return LEGACY_SERIALIZER.deserialize(text);
            }
        }
        return LEGACY_SERIALIZER.deserialize(text);
    }

    public static Component legacy(String text) {
        return LEGACY_SERIALIZER.deserialize(text);
    }

    public static Component mini(String text) {
        return MINI_MESSAGE.deserialize((Object)text);
    }

    public static Component success(String message) {
        return TextUtil.format("&a" + message);
    }

    public static Component error(String message) {
        return TextUtil.format("&c" + message);
    }

    public static Component warning(String message) {
        return TextUtil.format("&e" + message);
    }

    public static Component info(String message) {
        return TextUtil.format("&b" + message);
    }

    public static Component highlight(String message) {
        return TextUtil.format("&6" + message);
    }

    public static Component prefix() {
        return TextUtil.format("&6[ModReq] &f");
    }

    public static Component prefixed(String message) {
        return TextUtil.prefix().append(TextUtil.format(message));
    }

    public static String convertSectionToAmpersand(String text) {
        return text.replace('\u00a7', '&');
    }

    public static Component relativeTime(LocalDateTime dateTime) {
        String relativeText = TextUtil.getRelativeTimeString(dateTime);
        String fullDate = dateTime.format(DateTimeFormatter.ofPattern("MMM dd, yyyy 'at' HH:mm:ss"));
        return ((TextComponent)Component.text((String)relativeText).color((TextColor)NamedTextColor.GRAY)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)fullDate).color((TextColor)NamedTextColor.WHITE)));
    }

    public static Component relativeTime(LocalDateTime dateTime, String color) {
        String relativeText = TextUtil.getRelativeTimeString(dateTime);
        String fullDate = dateTime.format(DateTimeFormatter.ofPattern("MMM dd, yyyy 'at' HH:mm:ss"));
        return TextUtil.format(color + relativeText).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)fullDate).color((TextColor)NamedTextColor.WHITE)));
    }

    private static String getRelativeTimeString(LocalDateTime dateTime) {
        LocalDateTime now = LocalDateTime.now();
        long seconds = ChronoUnit.SECONDS.between(dateTime, now);
        long minutes = ChronoUnit.MINUTES.between(dateTime, now);
        long hours = ChronoUnit.HOURS.between(dateTime, now);
        long days = ChronoUnit.DAYS.between(dateTime, now);
        if (seconds < 60L) {
            return seconds <= 1L ? "just now" : seconds + " seconds ago";
        }
        if (minutes < 60L) {
            return minutes == 1L ? "1 minute ago" : minutes + " minutes ago";
        }
        if (hours < 24L) {
            return hours == 1L ? "1 hour ago" : hours + " hours ago";
        }
        if (days < 30L) {
            return days == 1L ? "1 day ago" : days + " days ago";
        }
        if (days < 365L) {
            long months = days / 30L;
            return months == 1L ? "1 month ago" : months + " months ago";
        }
        long years = days / 365L;
        return years == 1L ? "1 year ago" : years + " years ago";
    }
}

