/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.h2.table;

import dev.bwmp.modreq.libs.h2.command.query.TableValueConstructor;
import dev.bwmp.modreq.libs.h2.engine.SessionLocal;
import dev.bwmp.modreq.libs.h2.expression.Expression;
import dev.bwmp.modreq.libs.h2.result.ResultInterface;
import dev.bwmp.modreq.libs.h2.result.SimpleResult;
import dev.bwmp.modreq.libs.h2.schema.Schema;
import dev.bwmp.modreq.libs.h2.table.Column;
import dev.bwmp.modreq.libs.h2.table.VirtualConstructedTable;
import java.util.ArrayList;

public class TableValueConstructorTable
extends VirtualConstructedTable {
    private final ArrayList<ArrayList<Expression>> rows;

    public TableValueConstructorTable(Schema schema, SessionLocal sessionLocal, Column[] columnArray, ArrayList<ArrayList<Expression>> arrayList) {
        super(schema, 0, "VALUES");
        this.setColumns(columnArray);
        this.rows = arrayList;
    }

    @Override
    public boolean canGetRowCount(SessionLocal sessionLocal) {
        return true;
    }

    @Override
    public long getRowCount(SessionLocal sessionLocal) {
        return this.rows.size();
    }

    @Override
    public long getRowCountApproximation(SessionLocal sessionLocal) {
        return this.rows.size();
    }

    @Override
    public ResultInterface getResult(SessionLocal sessionLocal) {
        SimpleResult simpleResult = new SimpleResult();
        for (Column column : this.columns) {
            simpleResult.addColumn(column.getName(), column.getType());
        }
        TableValueConstructor.getVisibleResult(sessionLocal, simpleResult, this.columns, this.rows);
        return simpleResult;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        stringBuilder.append('(');
        TableValueConstructor.getValuesSQL(stringBuilder, n, this.rows);
        return stringBuilder.append(')');
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

