/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.mysql.cj.log;

import dev.bwmp.modreq.libs.mysql.cj.exceptions.CJException;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.ExceptionFactory;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.WrongArgumentException;
import dev.bwmp.modreq.libs.mysql.cj.log.Log;
import dev.bwmp.modreq.libs.mysql.cj.util.Util;

public class LogFactory {
    public static Log getLogger(String className, String instanceName) {
        if (className == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "Logger class can not be NULL");
        }
        if (instanceName == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "Logger instance name can not be NULL");
        }
        try {
            return Util.getInstance(Log.class, className, new Class[]{String.class}, new Object[]{instanceName}, null);
        }
        catch (CJException e1) {
            if (ClassNotFoundException.class.isInstance(e1.getCause())) {
                try {
                    return Util.getInstance(Log.class, Util.getPackageName(LogFactory.class) + "." + className, new Class[]{String.class}, new Object[]{instanceName}, null);
                }
                catch (CJException e2) {
                    throw e1;
                }
            }
            throw e1;
        }
    }
}

