/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.mysql.cj.protocol;

import dev.bwmp.modreq.libs.mysql.cj.Messages;
import dev.bwmp.modreq.libs.mysql.cj.conf.PropertySet;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.ExceptionFactory;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.ExceptionInterceptor;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.UnableToConnectException;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.WrongArgumentException;
import dev.bwmp.modreq.libs.mysql.cj.protocol.ExportControlled;
import dev.bwmp.modreq.libs.mysql.cj.protocol.FullReadInputStream;
import dev.bwmp.modreq.libs.mysql.cj.protocol.NetworkResources;
import dev.bwmp.modreq.libs.mysql.cj.protocol.SocketConnection;
import dev.bwmp.modreq.libs.mysql.cj.protocol.SocketFactory;
import dev.bwmp.modreq.libs.mysql.cj.util.Util;
import dev.bwmp.modreq.libs.mysql.jdbc.SocketFactoryWrapper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;

public abstract class AbstractSocketConnection
implements SocketConnection {
    protected String host = null;
    protected int port = 3306;
    protected SocketFactory socketFactory = null;
    protected Socket mysqlSocket = null;
    protected FullReadInputStream mysqlInput = null;
    protected BufferedOutputStream mysqlOutput = null;
    protected ExceptionInterceptor exceptionInterceptor;
    protected PropertySet propertySet;

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Socket getMysqlSocket() {
        return this.mysqlSocket;
    }

    @Override
    public FullReadInputStream getMysqlInput() throws IOException {
        if (this.mysqlInput != null) {
            return this.mysqlInput;
        }
        throw new IOException(Messages.getString("SocketConnection.1"));
    }

    @Override
    public void setMysqlInput(FullReadInputStream mysqlInput) {
        this.mysqlInput = mysqlInput;
    }

    @Override
    public BufferedOutputStream getMysqlOutput() throws IOException {
        if (this.mysqlOutput != null) {
            return this.mysqlOutput;
        }
        throw new IOException(Messages.getString("SocketConnection.1"));
    }

    @Override
    public boolean isSSLEstablished() {
        return ExportControlled.enabled() && ExportControlled.isSSLEstablished(this.getMysqlSocket());
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public void forceClose() {
        try {
            this.getNetworkResources().forceClose();
        }
        finally {
            this.mysqlSocket = null;
            this.mysqlInput = null;
            this.mysqlOutput = null;
        }
    }

    @Override
    public NetworkResources getNetworkResources() {
        return new NetworkResources(this.mysqlSocket, this.mysqlInput, this.mysqlOutput);
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    protected SocketFactory createSocketFactory(String socketFactoryClassName) {
        if (socketFactoryClassName == null) {
            throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("SocketConnection.0"), this.getExceptionInterceptor());
        }
        try {
            return Util.getInstance(SocketFactory.class, socketFactoryClassName, null, null, this.getExceptionInterceptor());
        }
        catch (WrongArgumentException e1) {
            if (e1.getCause() == null) {
                try {
                    return new SocketFactoryWrapper(Util.getInstance(dev.bwmp.modreq.libs.mysql.jdbc.SocketFactory.class, socketFactoryClassName, null, null, this.getExceptionInterceptor()));
                }
                catch (Exception e2) {
                    throw e1;
                }
            }
            throw e1;
        }
    }
}

