/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.mysql.cj.protocol;

import dev.bwmp.modreq.libs.mysql.cj.exceptions.CJOperationNotSupportedException;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.ExceptionFactory;
import dev.bwmp.modreq.libs.mysql.cj.protocol.Message;
import dev.bwmp.modreq.libs.mysql.cj.protocol.MessageHeader;
import dev.bwmp.modreq.libs.mysql.cj.protocol.MessageListener;
import java.io.IOException;
import java.util.Optional;

public interface MessageReader<H extends MessageHeader, M extends Message> {
    public H readHeader() throws IOException;

    default public H probeHeader() throws IOException {
        return this.readHeader();
    }

    public M readMessage(Optional<M> var1, H var2) throws IOException;

    default public M probeMessage(Optional<M> reuse, H header) throws IOException {
        return this.readMessage(reuse, header);
    }

    default public M readMessage(Optional<M> reuse, int expectedType) throws IOException {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    default public void skipPacket() throws IOException {
        this.readMessage(Optional.empty(), this.readHeader());
    }

    default public void pushMessageListener(MessageListener<M> l) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    default public byte getMessageSequence() {
        return 0;
    }

    default public void resetMessageSequence() {
    }

    default public MessageReader<H, M> undecorateAll() {
        return this;
    }

    default public MessageReader<H, M> undecorate() {
        return this;
    }

    default public void start() {
    }

    default public void stopAfterNextMessage() {
    }
}

