/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.mysql.cj.protocol.a;

import dev.bwmp.modreq.libs.mysql.cj.conf.PropertyKey;
import dev.bwmp.modreq.libs.mysql.cj.protocol.ColumnDefinition;
import dev.bwmp.modreq.libs.mysql.cj.protocol.ProtocolEntityFactory;
import dev.bwmp.modreq.libs.mysql.cj.protocol.Resultset;
import dev.bwmp.modreq.libs.mysql.cj.protocol.ResultsetRow;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.AbstractRowFactory;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.MysqlTextValueDecoder;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.NativeConstants;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.NativePacketPayload;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.NativeProtocol;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.result.ByteArrayRow;
import dev.bwmp.modreq.libs.mysql.cj.protocol.a.result.TextBufferRow;

public class TextRowFactory
extends AbstractRowFactory
implements ProtocolEntityFactory<ResultsetRow, NativePacketPayload> {
    public TextRowFactory(NativeProtocol protocol, ColumnDefinition colDefinition, Resultset.Concurrency resultSetConcurrency, boolean canReuseRowPacketForBufferRow) {
        this.columnDefinition = colDefinition;
        this.resultSetConcurrency = resultSetConcurrency;
        this.canReuseRowPacketForBufferRow = canReuseRowPacketForBufferRow;
        this.useBufferRowSizeThreshold = protocol.getPropertySet().getMemorySizeProperty(PropertyKey.largeRowSizeThreshold);
        this.exceptionInterceptor = protocol.getExceptionInterceptor();
        this.valueDecoder = new MysqlTextValueDecoder();
    }

    @Override
    public ResultsetRow createFromMessage(NativePacketPayload rowPacket) {
        boolean useBufferRow;
        boolean bl = useBufferRow = this.canReuseRowPacketForBufferRow || this.columnDefinition.hasLargeFields() || rowPacket.getPayloadLength() >= (Integer)this.useBufferRowSizeThreshold.getValue();
        if (this.resultSetConcurrency == Resultset.Concurrency.UPDATABLE || !useBufferRow) {
            byte[][] rowBytes = new byte[this.columnDefinition.getFields().length][];
            for (int i = 0; i < this.columnDefinition.getFields().length; ++i) {
                rowBytes[i] = rowPacket.readBytes(NativeConstants.StringSelfDataType.STRING_LENENC);
            }
            return new ByteArrayRow(rowBytes, this.exceptionInterceptor);
        }
        return new TextBufferRow(rowPacket, this.columnDefinition, this.exceptionInterceptor, this.valueDecoder);
    }

    @Override
    public boolean canReuseRowPacketForBufferRow() {
        return this.canReuseRowPacketForBufferRow;
    }
}

