/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.mysql.cj.result;

import dev.bwmp.modreq.libs.mysql.cj.Messages;
import dev.bwmp.modreq.libs.mysql.cj.WarningListener;
import dev.bwmp.modreq.libs.mysql.cj.conf.PropertySet;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.DataReadException;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.ExceptionFactory;
import dev.bwmp.modreq.libs.mysql.cj.exceptions.WrongArgumentException;
import dev.bwmp.modreq.libs.mysql.cj.protocol.InternalDate;
import dev.bwmp.modreq.libs.mysql.cj.protocol.InternalTime;
import dev.bwmp.modreq.libs.mysql.cj.protocol.InternalTimestamp;
import dev.bwmp.modreq.libs.mysql.cj.result.AbstractDateTimeValueFactory;
import dev.bwmp.modreq.libs.mysql.cj.util.TimeUtil;
import java.sql.Date;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class SqlDateValueFactory
extends AbstractDateTimeValueFactory<Date> {
    private WarningListener warningListener;
    private Calendar cal;

    public SqlDateValueFactory(PropertySet pset, Calendar calendar, TimeZone tz) {
        super(pset);
        if (calendar != null) {
            this.cal = (Calendar)calendar.clone();
        } else {
            this.cal = Calendar.getInstance(tz, Locale.US);
            this.cal.set(14, 0);
            this.cal.setLenient(false);
        }
    }

    public SqlDateValueFactory(PropertySet pset, Calendar calendar, TimeZone tz, WarningListener warningListener) {
        this(pset, calendar, tz);
        this.warningListener = warningListener;
    }

    @Override
    public Date localCreateFromDate(InternalDate idate) {
        Calendar calendar = this.cal;
        synchronized (calendar) {
            try {
                if (idate.isZero()) {
                    throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
                }
                this.cal.clear();
                this.cal.set(idate.getYear(), idate.getMonth() - 1, idate.getDay());
                long ms = this.cal.getTimeInMillis();
                return new Date(ms);
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
            }
        }
    }

    @Override
    public Date localCreateFromTime(InternalTime it) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.ImplicitDatePartWarning", new Object[]{"java.sql.Date"}));
        }
        return Date.valueOf(TimeUtil.DEFAULT_DATE);
    }

    @Override
    public Date localCreateFromTimestamp(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{"java.sql.Date"}));
        }
        return (Date)this.createFromDate(its);
    }

    @Override
    public Date localCreateFromDatetime(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{"java.sql.Date"}));
        }
        return (Date)this.createFromDate(its);
    }

    @Override
    public String getTargetTypeName() {
        return Date.class.getName();
    }
}

