/*
 * Decompiled with CFR 0.152.
 */
package dev.bwmp.modreq.libs.slf4j.jul;

import dev.bwmp.modreq.libs.slf4j.Marker;
import dev.bwmp.modreq.libs.slf4j.event.LoggingEvent;
import dev.bwmp.modreq.libs.slf4j.helpers.AbstractLogger;
import dev.bwmp.modreq.libs.slf4j.helpers.FormattingTuple;
import dev.bwmp.modreq.libs.slf4j.helpers.LegacyAbstractLogger;
import dev.bwmp.modreq.libs.slf4j.helpers.MessageFormatter;
import dev.bwmp.modreq.libs.slf4j.helpers.NormalizedParameters;
import dev.bwmp.modreq.libs.slf4j.helpers.SubstituteLogger;
import dev.bwmp.modreq.libs.slf4j.spi.DefaultLoggingEventBuilder;
import dev.bwmp.modreq.libs.slf4j.spi.LocationAwareLogger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class JDK14LoggerAdapter
extends LegacyAbstractLogger
implements LocationAwareLogger {
    private static final long serialVersionUID = -8053026990503422791L;
    final transient Logger logger;
    static String SELF = JDK14LoggerAdapter.class.getName();
    static String SUPER = LegacyAbstractLogger.class.getName();
    static String SUPER_OF_SUPER = AbstractLogger.class.getName();
    static String SUBSTITUE = SubstituteLogger.class.getName();
    static String FLUENT = DefaultLoggingEventBuilder.class.getName();
    static String[] BARRIER_CLASSES = new String[]{SUPER_OF_SUPER, SUPER, SELF, SUBSTITUE, FLUENT};

    JDK14LoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    protected void handleNormalizedLoggingCall(dev.bwmp.modreq.libs.slf4j.event.Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        this.innerNormalizedLoggingCallHandler(this.getFullyQualifiedCallerName(), level, marker, msg, args, throwable);
    }

    private void innerNormalizedLoggingCallHandler(String fqcn, dev.bwmp.modreq.libs.slf4j.event.Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        Level julLevel = JDK14LoggerAdapter.slf4jLevelToJULLevel(level);
        String formattedMessage = MessageFormatter.basicArrayFormat(msg, args);
        LogRecord record = new LogRecord(julLevel, formattedMessage);
        record.setLoggerName(this.getName());
        record.setThrown(throwable);
        this.fillCallerData(fqcn, record);
        this.logger.log(record);
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return SELF;
    }

    @Override
    public void log(Marker marker, String callerFQCN, int slf4jLevelInt, String message, Object[] arguments, Throwable throwable) {
        dev.bwmp.modreq.libs.slf4j.event.Level slf4jLevel = dev.bwmp.modreq.libs.slf4j.event.Level.intToLevel(slf4jLevelInt);
        Level julLevel = JDK14LoggerAdapter.slf4jLevelIntToJULLevel(slf4jLevelInt);
        if (this.logger.isLoggable(julLevel)) {
            NormalizedParameters np = NormalizedParameters.normalize(message, arguments, throwable);
            this.innerNormalizedLoggingCallHandler(callerFQCN, slf4jLevel, marker, np.getMessage(), np.getArguments(), np.getThrowable());
        }
    }

    private final void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!this.barrierMatch(callerFQCN, className)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (this.barrierMatch(callerFQCN, className)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }

    private boolean barrierMatch(String callerFQCN, String candidateClassName) {
        if (candidateClassName.equals(callerFQCN)) {
            return true;
        }
        for (String barrierClassName : BARRIER_CLASSES) {
            if (!barrierClassName.equals(candidateClassName)) continue;
            return true;
        }
        return false;
    }

    private static Level slf4jLevelIntToJULLevel(int levelInt) {
        dev.bwmp.modreq.libs.slf4j.event.Level slf4jLevel = dev.bwmp.modreq.libs.slf4j.event.Level.intToLevel(levelInt);
        return JDK14LoggerAdapter.slf4jLevelToJULLevel(slf4jLevel);
    }

    private static Level slf4jLevelToJULLevel(dev.bwmp.modreq.libs.slf4j.event.Level slf4jLevel) {
        Level julLevel;
        switch (slf4jLevel) {
            case TRACE: {
                julLevel = Level.FINEST;
                break;
            }
            case DEBUG: {
                julLevel = Level.FINE;
                break;
            }
            case INFO: {
                julLevel = Level.INFO;
                break;
            }
            case WARN: {
                julLevel = Level.WARNING;
                break;
            }
            case ERROR: {
                julLevel = Level.SEVERE;
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)slf4jLevel) + " is not recognized.");
            }
        }
        return julLevel;
    }

    public void log(LoggingEvent event) {
        Level julLevel = JDK14LoggerAdapter.slf4jLevelToJULLevel(event.getLevel());
        if (this.logger.isLoggable(julLevel)) {
            LogRecord record = this.eventToRecord(event, julLevel);
            this.logger.log(record);
        }
    }

    private LogRecord eventToRecord(LoggingEvent event, Level julLevel) {
        Object[] arguments;
        String format = event.getMessage();
        FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments = event.getArgumentArray());
        if (ft.getThrowable() != null && event.getThrowable() != null) {
            throw new IllegalArgumentException("both last element in argument array and last argument are of type Throwable");
        }
        Throwable t = event.getThrowable();
        if (ft.getThrowable() != null) {
            t = ft.getThrowable();
            throw new IllegalStateException("fix above code");
        }
        LogRecord record = new LogRecord(julLevel, ft.getMessage());
        record.setLoggerName(event.getLoggerName());
        record.setMillis(event.getTimeStamp());
        record.setSourceClassName("NA/SubstituteLogger");
        record.setSourceMethodName("NA/SubstituteLogger");
        record.setThrown(t);
        return record;
    }
}

