/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.base.abilities;

import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.base.abilities.AbstractCooldownMove;
import flashfur.omnimobs.init.SoundInit;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.MathsUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class AbstractSwipeMove
extends AbstractCooldownMove {
    private final float aoe;

    public AbstractSwipeMove(BossEntity entity, AnimationState[] state, float range, int cooldown, float aoe, int endCooldown) {
        super(entity, state, range, 10, cooldown, false, endCooldown);
        this.aoe = aoe;
    }

    @Override
    public void start() {
        super.start();
        if (this.getEntity().m_5448_() == null) {
            return;
        }
        this.getEntity().m_9236_().m_6263_(null, this.getEntity().m_5448_().m_20185_(), this.getEntity().m_5448_().m_20186_(), this.getEntity().m_5448_().m_20189_(), (SoundEvent)SoundInit.SWING.get(), SoundSource.NEUTRAL, 5.0f, MathsUtil.randFloat(0.85f, 1.15f));
    }

    @Override
    protected void moveSpecificTick() {
        super.moveSpecificTick();
        if ((float)this.getTicks() == 5.0f / this.getSpeedMultiplier() && this.isInRange()) {
            if (this.getEntity().m_5448_() == null) {
                return;
            }
            this.onHitEntity();
            for (Entity entity1 : EntityUtil.entityList(this.aoe, this.getEntity().m_9236_(), this.getEntity().m_5448_().m_20185_(), this.getEntity().m_5448_().m_20186_(), this.getEntity().m_5448_().m_20189_())) {
                if (entity1 == this.getEntity() || !(entity1 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity1;
                this.affectEntity(livingEntity);
            }
        }
    }

    protected float getSpeedMultiplier() {
        return 1.0f;
    }

    protected void onHitEntity() {
        if (this.getEntity().m_5448_() == null) {
            return;
        }
        this.getEntity().m_9236_().m_6263_(null, this.getEntity().m_5448_().m_20185_(), this.getEntity().m_5448_().m_20186_(), this.getEntity().m_5448_().m_20189_(), (SoundEvent)SoundInit.SLASH.get(), SoundSource.NEUTRAL, 5.0f, MathsUtil.randFloat(0.85f, 1.15f));
        Level level = this.getEntity().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.getEntity().m_5448_().m_20185_(), this.getEntity().m_5448_().m_20186_() + (double)(this.getEntity().m_5448_().m_20206_() / 2.0f), this.getEntity().m_5448_().m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected abstract void affectEntity(LivingEntity var1);

    @Override
    public boolean ignoreCooldown() {
        return true;
    }
}

