/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.silverlight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.silverlight.powers.flip.SilverlightLargeJumpLightningMove;
import flashfur.omnimobs.entities.silverlight.powers.flip.SilverlightSmallJumpLightningMove;
import flashfur.omnimobs.entities.silverlight.powers.misc.SilverlightLightningAuraAbility;
import flashfur.omnimobs.entities.silverlight.powers.misc.SilverlightProjectLightningBoltMove;
import flashfur.omnimobs.entities.silverlight.powers.misc.SilverlightSwipeMove;
import flashfur.omnimobs.init.SoundInit;
import flashfur.omnimobs.util.MathsUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Silverlight
extends BossEntity {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState lightningAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState stopSittingAnimationState = new AnimationState();
    public final AnimationState omnidirectionalLightningAnimationState = new AnimationState();
    public final AnimationState omnidirectionalLightningBackflipAnimationState = new AnimationState();
    public final AnimationState shockwaveLightningBackflipAnimationState = new AnimationState();
    public final AnimationState shockwaveLightningFrontflipAnimationState = new AnimationState();
    public AnimationState jumpDodgeRightAnimationState = new AnimationState();
    public AnimationState jumpDodgeLeftAnimationState = new AnimationState();
    public AnimationState rollDodgeRightAnimationState = new AnimationState();
    public AnimationState rollDodgeLeftAnimationState = new AnimationState();
    public AnimationState backflipDodge = new AnimationState();
    public final AnimationState swipe1AnimationState = new AnimationState();
    public final AnimationState swipe2AnimationState = new AnimationState();
    public final AnimationState swipe3AnimationState = new AnimationState();
    public final AnimationState swipe4AnimationState = new AnimationState();
    public final AnimationState swipe5AnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> DATA_DODGE_ANIMATION = SynchedEntityData.m_135353_(Silverlight.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_DODGE_ANIMATION_TIMER = SynchedEntityData.m_135353_(Silverlight.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lightningSeed = 0;

    public Silverlight(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void registerAbilities() {
        super.registerAbilities();
        this.addAbility(new SilverlightSwipeMove(this, new AnimationState[]{this.swipe1AnimationState, this.swipe2AnimationState, this.swipe3AnimationState, this.swipe4AnimationState, this.swipe5AnimationState}));
        this.addAbility(new SilverlightProjectLightningBoltMove(this, new AnimationState[]{this.lightningAnimationState}));
        this.addAbility(new SilverlightSmallJumpLightningMove(this, new AnimationState[]{this.shockwaveLightningBackflipAnimationState, this.shockwaveLightningFrontflipAnimationState}));
        this.addAbility(new SilverlightLargeJumpLightningMove(this, new AnimationState[]{this.omnidirectionalLightningBackflipAnimationState, this.omnidirectionalLightningAnimationState}));
        this.addAbility(new SilverlightLightningAuraAbility(this));
    }

    public static AttributeSupplier.Builder applyAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 256.0);
    }

    public double m_21133_(@NotNull Attribute attribute) {
        if (attribute == Attributes.f_22276_) {
            return 300.0;
        }
        return super.m_21133_(attribute);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DODGE_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(DATA_DODGE_ANIMATION_TIMER, (Object)-1);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.playAnimations();
        if (!this.m_9236_().m_5776_()) {
            this.randomDodge();
        } else if (this.f_19797_ % 2 == 0) {
            ++this.lightningSeed;
        }
    }

    protected void playAnimations() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
            this.jumpDodgeRightAnimationState.m_246184_(this.m_6084_() && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 1 && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION_TIMER) >= 0, this.f_19797_);
            this.jumpDodgeLeftAnimationState.m_246184_(this.m_6084_() && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 2 && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION_TIMER) >= 0, this.f_19797_);
            this.rollDodgeRightAnimationState.m_246184_(this.m_6084_() && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 3 && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION_TIMER) >= 0, this.f_19797_);
            this.rollDodgeLeftAnimationState.m_246184_(this.m_6084_() && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 4 && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION_TIMER) >= 0, this.f_19797_);
            this.backflipDodge.m_246184_(this.m_6084_() && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 5 && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION_TIMER) >= 0, this.f_19797_);
        }
    }

    private void randomDodge() {
        if (this.m_5448_() != null && Math.random() < 0.025 && (double)this.m_20270_((Entity)this.m_5448_()) < 7.5 && this.m_20096_() && (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION_TIMER) <= -1 && !this.m_9236_().m_5776_()) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_20318_(0.0f));
            this.dodge(false);
        }
    }

    public boolean m_142535_(float v, float v1, @NotNull DamageSource source) {
        this.postMoveEvent("causeFallDamage");
        return super.m_142535_(v, v1, source);
    }

    @Override
    public double getSetDeltaMovementResistance() {
        return 0.5;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11785_;
    }

    @Nullable
    public SoundEvent m_7975_(@NotNull DamageSource source) {
        return SoundEvents.f_11791_;
    }

    @Nullable
    public SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    public float m_6121_() {
        return 2.0f;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        return false;
    }

    private void dodge(boolean doBackflip) {
        double dodgeSpeed = 0.75;
        double jumpHeight = 0.3;
        double yaw = this.m_146908_();
        this.f_19804_.m_135381_(DATA_DODGE_ANIMATION, (Object)MathsUtil.randInt(1, doBackflip ? 5 : 4));
        if ((Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 1 || (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 3) {
            yaw += 90.0;
        } else if ((Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 2 || (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 4) {
            yaw -= 90.0;
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 2 || (Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 4) {
            jumpHeight = 0.0;
            dodgeSpeed = 1.5;
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_DODGE_ANIMATION) == 5) {
            jumpHeight = 0.5;
            dodgeSpeed = 2.0;
            yaw -= 180.0;
        }
        this.f_19804_.m_135381_(DATA_DODGE_ANIMATION_TIMER, (Object)10);
        this.m_20256_(new Vec3(dodgeSpeed * Math.cos((yaw + 90.0) * (Math.PI / 180)), this.m_20184_().m_7098_() + jumpHeight, dodgeSpeed * Math.sin((yaw + 90.0) * (Math.PI / 180))));
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 1.0f, MathsUtil.randFloat(0.1f, 0.5f));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity entity;
        if (source.equals(this.m_269291_().m_269387_()) || source.equals(this.m_269291_().m_269549_()) || source.equals(this.m_269291_().m_269233_()) || source.equals(this.m_269291_().m_269548_())) {
            return false;
        }
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.m_6710_(livingEntity);
        }
        if (this.usingBlockingAbility()) {
            return super.m_6469_(source, amount);
        }
        if (source == this.m_269291_().m_268989_() || this.iFrames > 0) {
            return false;
        }
        if (!this.m_9236_().m_5776_() && Math.random() < 0.5 && this.m_20096_()) {
            this.dodge(true);
            this.iFrames = this.getIFrames();
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public String bossBarName() {
        return "\u00a7b\u00a7l" + super.bossBarName();
    }

    @Override
    public SoundEvent getMusic() {
        return (SoundEvent)SoundInit.SILVERLIGHT_THEME.get();
    }

    @Override
    protected float getResistance() {
        return 2.0f;
    }

    public void m_20254_(int secondsOnFire) {
    }

    public void m_7311_(int remainingFireTicks) {
    }

    @Override
    public void renderOnBossbar(GuiGraphics guiGraphics, int i, int i1, BossEvent bossEvent, int i2, int i3) {
        super.renderOnBossbar(guiGraphics, i, i1, bossEvent, i2, i3);
        int random = this.lightningSeed;
        PoseStack poseStack = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
        poseStack.m_85836_();
        float scale = 1.5f;
        poseStack.m_252880_((float)guiGraphics.m_280182_() / 2.0f - 64.0f * scale, (float)i1 + (float)RandomSource.m_216335_((long)random).m_216339_(-5, 5) / 2.0f, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
        float[] $$6 = new float[8];
        float[] $$7 = new float[8];
        float $$8 = 0.0f;
        float $$9 = 0.0f;
        RandomSource randomSource = RandomSource.m_216335_((long)random);
        for (int $$11 = 7; $$11 >= 0; --$$11) {
            $$6[$$11] = $$8;
            $$7[$$11] = $$9;
            $$8 += (float)(randomSource.m_188503_(11) - 5);
            $$9 += (float)(randomSource.m_188503_(11) - 5);
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110502_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        for (int $$14 = 0; $$14 < 4; ++$$14) {
            RandomSource randomSource1 = RandomSource.m_216335_((long)random);
            for (int $$16 = 0; $$16 < 3; ++$$16) {
                int $$17 = 7;
                int $$18 = 0;
                if ($$16 > 0) {
                    $$17 = 7 - $$16;
                }
                if ($$16 > 0) {
                    $$18 = $$17 - 2;
                }
                float $$19 = $$6[$$17] - $$8;
                float $$20 = $$7[$$17] - $$9;
                for (int $$21 = $$17; $$21 >= $$18; --$$21) {
                    float $$22 = $$19;
                    float $$23 = $$20;
                    if ($$16 == 0) {
                        $$19 += (float)(randomSource1.m_188503_(11) - 5);
                        $$20 += (float)(randomSource1.m_188503_(11) - 5);
                    } else {
                        $$19 += (float)(randomSource1.m_188503_(31) - 15);
                        $$20 += (float)(randomSource1.m_188503_(31) - 15);
                    }
                    float $$28 = 0.1f + (float)$$14 * 0.2f;
                    if ($$16 == 0) {
                        $$28 *= (float)$$21 * 0.1f + 1.0f;
                    }
                    float $$29 = 0.1f + (float)$$14 * 0.2f;
                    if ($$16 == 0) {
                        $$29 *= ((float)$$21 - 1.0f) * 0.1f + 1.0f;
                    }
                    float r = 0.0f;
                    float g = 0.5882353f;
                    float b = 1.0f;
                    Silverlight.quad(matrix4f, vertexConsumer, $$19, $$20, $$21, $$22, $$23, r, g, b, $$28, $$29, false, false, true, false);
                    Silverlight.quad(matrix4f, vertexConsumer, $$19, $$20, $$21, $$22, $$23, r, g, b, $$28, $$29, true, false, true, true);
                    Silverlight.quad(matrix4f, vertexConsumer, $$19, $$20, $$21, $$22, $$23, r, g, b, $$28, $$29, true, true, false, true);
                    Silverlight.quad(matrix4f, vertexConsumer, $$19, $$20, $$21, $$22, $$23, r, g, b, $$28, $$29, false, true, false, false);
                }
            }
        }
        poseStack.m_85849_();
    }

    private static void quad(Matrix4f p_253966_, VertexConsumer p_115274_, float p_115275_, float p_115276_, int p_115277_, float p_115278_, float p_115279_, float p_115280_, float p_115281_, float p_115282_, float p_115283_, float p_115284_, boolean p_115285_, boolean p_115286_, boolean p_115287_, boolean p_115288_) {
        p_115274_.m_252986_(p_253966_, p_115275_ + (p_115285_ ? p_115284_ : -p_115284_), (float)(p_115277_ * 16), p_115276_ + (p_115286_ ? p_115284_ : -p_115284_)).m_85950_(p_115280_, p_115281_, p_115282_, 0.3f).m_5752_();
        p_115274_.m_252986_(p_253966_, p_115278_ + (p_115285_ ? p_115283_ : -p_115283_), (float)((p_115277_ + 1) * 16), p_115279_ + (p_115286_ ? p_115283_ : -p_115283_)).m_85950_(p_115280_, p_115281_, p_115282_, 0.3f).m_5752_();
        p_115274_.m_252986_(p_253966_, p_115278_ + (p_115287_ ? p_115283_ : -p_115283_), (float)((p_115277_ + 1) * 16), p_115279_ + (p_115288_ ? p_115283_ : -p_115283_)).m_85950_(p_115280_, p_115281_, p_115282_, 0.3f).m_5752_();
        p_115274_.m_252986_(p_253966_, p_115275_ + (p_115287_ ? p_115284_ : -p_115284_), (float)(p_115277_ * 16), p_115276_ + (p_115288_ ? p_115284_ : -p_115284_)).m_85950_(p_115280_, p_115281_, p_115282_, 0.3f).m_5752_();
    }
}

