/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.network;

import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.base.abilities.AbstractAbility;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class S2CSyncAbilityData {
    private final int bossEntity;
    private final String field;
    private final int move;
    private final double value;

    public S2CSyncAbilityData(double value, String field, int move, int bossEntity) {
        this.value = value;
        this.field = field;
        this.move = move;
        this.bossEntity = bossEntity;
    }

    public S2CSyncAbilityData(FriendlyByteBuf buffer) {
        this(buffer.readDouble(), buffer.m_130277_(), buffer.readInt(), buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.value);
        buffer.m_130070_(this.field);
        buffer.writeInt(this.move);
        buffer.writeInt(this.bossEntity);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(this.bossEntity)) instanceof BossEntity) {
                BossEntity bossEntity = (BossEntity)entity;
                AbstractAbility abstractMove = bossEntity.getAbilities().get(this.move);
                Class<?> moveClass = abstractMove.getClass();
                Field field1 = this.getDeclaredFieldFromAllClasses(moveClass, this.field);
                if (field1 != null) {
                    try {
                        field1.setAccessible(true);
                        if (field1.getType() == Double.TYPE) {
                            field1.set(abstractMove, this.value);
                        } else if (field1.getType() == Float.TYPE) {
                            field1.set(abstractMove, Float.valueOf((float)this.value));
                        } else if (field1.getType() == Integer.TYPE) {
                            field1.set(abstractMove, (int)this.value);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                context.setPacketHandled(true);
            }
        });
    }

    private Field getDeclaredFieldFromAllClasses(Class<?> c, String field) {
        if (c == Object.class) {
            return null;
        }
        try {
            return c.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            return this.getDeclaredFieldFromAllClasses(c.getSuperclass(), field);
        }
    }
}

