/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.util;

import flashfur.omnimobs.util.ClassUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityRemovalUtil {
    public static void deleteEntity(Entity entity, Level level, boolean onRemoved) {
        try {
            if (entity.f_146795_ == null) {
                entity.f_146795_ = Entity.RemovalReason.DISCARDED;
            }
            if (entity.f_146795_.m_146965_()) {
                entity.m_8127_();
            }
            entity.m_20197_().forEach(Entity::m_8127_);
            EntityRemovalUtil.deleteFromPersistentManager(entity, level, onRemoved);
            EntityRemovalUtil.deleteFromTransientManager(entity, level, onRemoved);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteFromTransientManager(Entity entity, Level level, boolean onRemoved) {
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            TransientEntitySectionManager manager = clientLevel.f_171631_;
            EntitySection section = manager.f_157638_.m_156895_(entity.m_20183_().m_121878_());
            if (section == null) {
                return;
            }
            EntityRemovalUtil.removeEntityFromSection(entity, section.f_156827_);
            clientLevel.f_171630_.m_156907_();
            clientLevel.f_171630_.f_156903_.remove(entity.m_19879_());
            EntityRemovalUtil.clientLevelOnTrackingEnd(entity, clientLevel, onRemoved);
            manager.f_157637_.f_156808_.remove(entity.m_20148_());
            manager.f_157637_.f_156807_.remove(entity.m_19879_());
            entity.f_146801_ = EntityInLevelCallback.f_156799_;
            manager.m_157648_(entity.m_20183_().m_121878_(), section);
        }
    }

    private static void deleteFromPersistentManager(Entity entity, Level level, boolean onRemoved) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PersistentEntitySectionManager manager = serverLevel.f_143244_;
            EntitySection section = manager.f_157495_.m_156895_(SectionPos.m_175568_((BlockPos)entity.m_20183_()));
            if (section == null) {
                return;
            }
            EntityRemovalUtil.removeEntityFromSection(entity, section.f_156827_);
            serverLevel.f_143243_.m_156907_();
            serverLevel.f_143243_.f_156903_.remove(entity.m_19879_());
            EntityRemovalUtil.serverLevelOnTrackingEnd(entity, serverLevel, onRemoved);
            manager.f_157494_.f_156808_.remove(entity.m_20148_());
            manager.f_157494_.f_156807_.remove(entity.m_19879_());
            serverLevel.m_6188_().m_83420_(entity);
            manager.f_157491_.remove(entity.m_20148_());
            entity.f_146801_ = EntityInLevelCallback.f_156799_;
            manager.m_157509_(SectionPos.m_175568_((BlockPos)entity.m_20183_()), section);
        }
    }

    public static void clearBossbars(Entity entity) {
        for (Field f : ClassUtil.getAllDeclaredFields(entity.getClass())) {
            try {
                Object object;
                f.setAccessible(true);
                if (f.getModifiers() == 8 || !((object = f.get(entity)) instanceof ServerBossEvent)) continue;
                ServerBossEvent bossEvent = (ServerBossEvent)object;
                bossEvent.m_7706_();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static <T> void removeEntityFromSection(Entity entity, ClassInstanceMultiMap<T> multiMap) {
        boolean $$1 = false;
        for (Map.Entry $$2 : multiMap.f_13527_.entrySet()) {
            if (!((Class)$$2.getKey()).isInstance(entity)) continue;
            List $$3 = (List)$$2.getValue();
            $$1 |= $$3.remove(entity);
        }
    }

    public static void clientLevelOnTrackingEnd(Entity entity, ClientLevel level, boolean onRemoved) {
        entity.m_19877_();
        level.f_104566_.remove(entity);
        if (onRemoved) {
            entity.onRemovedFromWorld();
            MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveLevelEvent(entity, (Level)level));
        }
        if (entity.isMultipartEntity()) {
            for (PartEntity part : entity.getParts()) {
                level.partEntities.remove(part.m_19879_());
            }
        }
    }

    public static void serverLevelOnTrackingEnd(Entity entity, ServerLevel level, boolean onRemoved) {
        EntityRemovalUtil.chunkMapRemoveEntity(entity, level.m_7726_().f_8325_, onRemoved);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            level.f_8546_.remove(serverplayer);
            level.m_8878_();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (level.f_200893_) {
                String s = "onTrackingStart called during navigation iteration";
                Util.m_200890_((String)"onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
            }
            level.f_143246_.remove(mob);
        }
        if (entity.isMultipartEntity()) {
            for (PartEntity enderdragonpart : entity.getParts()) {
                level.f_143247_.remove(enderdragonpart.m_19879_());
            }
        }
        entity.m_213651_(DynamicGameEventListener::m_223634_);
        if (onRemoved) {
            entity.onRemovedFromWorld();
            MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveLevelEvent(entity, (Level)level));
        }
    }

    public static void chunkMapRemoveEntity(Entity entity, ChunkMap chunkMap, boolean stopSeenByPlayer) {
        ChunkMap.TrackedEntity chunkmap$trackedentity1;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            chunkMap.m_140192_(serverplayer, false);
            for (ChunkMap.TrackedEntity chunkmap$trackedentity : chunkMap.f_140150_.values()) {
                chunkmap$trackedentity.m_140485_(serverplayer);
            }
        }
        if ((chunkmap$trackedentity1 = (ChunkMap.TrackedEntity)chunkMap.f_140150_.remove(entity.m_19879_())) != null) {
            EntityRemovalUtil.broadcastRemove(chunkmap$trackedentity1, stopSeenByPlayer);
        }
        EntityRemovalUtil.clearBossbars(entity);
    }

    public static void broadcastRemove(ChunkMap.TrackedEntity entity, boolean stopSeenByPlayer) {
        for (ServerPlayerConnection serverplayerconnection : entity.f_140475_) {
            if (stopSeenByPlayer) {
                entity.f_140471_.m_8534_(serverplayerconnection.m_142253_());
                continue;
            }
            serverplayerconnection.m_142253_().f_8906_.m_9829_((Packet)new ClientboundRemoveEntitiesPacket(new int[]{entity.f_140471_.f_8510_.m_19879_()}));
        }
    }
}

