/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.coremod;

import flashfur.omnimobs.OmniMobs;
import flashfur.omnimobs.coremod.GetHealthPatcherClassVisitor;
import flashfur.omnimobs.coremod.OmniMobsClassVisitor;
import flashfur.omnimobs.coremod.PreventMixinsClassVisitor;
import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfur;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurRenderer;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.UnsafeUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.server.MinecraftServer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.spongepowered.asm.transformers.MixinClassWriter;
import sun.misc.Unsafe;

public class CoreModMain {
    public static final HashMap<String, Boolean> SUCCESSFUL_OPERATIONS = new HashMap();

    public static void loadAgentAndTransformClasses() {
        try {
            CoreModMain.loadAgent();
            try {
                CoreModMain.transformClasses();
            }
            catch (Throwable e) {
                e.printStackTrace();
                OmniMobs.logErr("Failed to transform some classes. Attempting to proceed anyway.");
            }
        }
        catch (Exception e) {
            OmniMobs.logErr(e.toString());
            OmniMobs.logErr("Failed to load agent. Attempting to proceed without the agent.");
        }
    }

    public static void loadAgent() throws Exception {
        Field f;
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, p);
        OmniMobs.log("Allowing self agent attach...");
        try {
            f = Class.forName("sun.tools.attach.HotSpotVirtualMachine").getDeclaredField("ALLOW_ATTACH_SELF");
        }
        catch (ClassNotFoundException e) {
            OmniMobs.logErr("Class not found: sun.tools.attach.HotSpotVirtualMachine. You may be using an unsupported JVM.");
            throw e;
        }
        Unsafe unsafe = UnsafeUtil.getUnsafe();
        unsafe.putBoolean(unsafe.staticFieldBase(f), unsafe.staticFieldOffset(f), true);
        OmniMobs.log("Self agent attach allowed.");
        SUCCESSFUL_OPERATIONS.put("allow", true);
        OmniMobs.log("Creating temporary file to attach agent to running JVM...");
        File file = File.createTempFile("omnimobs_agent", ".jar");
        file.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(file);
             InputStream fis = OmniMobs.class.getResourceAsStream("/omnimobs_agent.jar");){
            fis.transferTo(fos);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy the agent into a temporary file.");
        }
        SUCCESSFUL_OPERATIONS.put("file", true);
        OmniMobs.log("Attaching agent to running JVM...");
        Class<?> vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        Object vm = vmClass.getMethod("attach", String.class).invoke(null, pid);
        vmClass.getMethod("loadAgent", String.class).invoke(vm, file.getAbsolutePath());
        vmClass.getMethod("detach", new Class[0]).invoke(vm, new Object[0]);
        OmniMobs.log("Attached agent to running JVM.");
        SUCCESSFUL_OPERATIONS.put("agent_attach", true);
        if (OmniMobs.instrumentation != null) {
            OmniMobs.log("Instrumentation enabled.");
        } else {
            OmniMobs.logErr("Instrumentation wasn't set by agent.");
        }
    }

    public static void agentCall(String args, Instrumentation inst) {
        OmniMobs.instrumentation = inst;
        OmniMobs.log("Agent agentmain called.");
        SUCCESSFUL_OPERATIONS.put("agentmain", true);
    }

    public static void transformClasses() throws UnmodifiableClassException {
        OmniMobs.log("Transforming classes...");
        CoreModMain.transformTickingAndRenderingClasses();
        CoreModMain.transformOwnGetHealthMethods();
        CoreModMain.transformAndRemoveMixins();
        OmniMobs.log("Transformed classes.");
    }

    public static void transformTickingAndRenderingClasses() throws UnmodifiableClassException {
        ClassFileTransformer classFileTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (className.equals("net/minecraft/client/renderer/LevelRenderer")) {
                    OmniMobs.log("Transforming LevelRenderer...");
                    ClassReader levelRendererReader = new ClassReader(classfileBuffer);
                    MixinClassWriter levelRendererWriter = new MixinClassWriter(levelRendererReader, 2);
                    OmniMobsClassVisitor levelRendererVisitor = new OmniMobsClassVisitor((ClassVisitor)levelRendererWriter);
                    levelRendererReader.accept((ClassVisitor)levelRendererVisitor, 8);
                    return levelRendererWriter.toByteArray();
                }
                if (className.equals("net/minecraft/server/MinecraftServer")) {
                    OmniMobs.log("Transforming MinecraftServer...");
                    ClassReader minecraftServerReader = new ClassReader(classfileBuffer);
                    MixinClassWriter minecraftServerWriter = new MixinClassWriter(minecraftServerReader, 2);
                    OmniMobsClassVisitor minecraftServerVisitor = new OmniMobsClassVisitor((ClassVisitor)minecraftServerWriter);
                    minecraftServerReader.accept((ClassVisitor)minecraftServerVisitor, 8);
                    return minecraftServerWriter.toByteArray();
                }
                return null;
            }
        };
        OmniMobs.instrumentation.addTransformer(classFileTransformer, true);
        OmniMobs.instrumentation.retransformClasses(LevelRenderer.class, MinecraftServer.class);
        OmniMobs.log("Transformed LevelRenderer.");
        OmniMobs.log("Transformed MinecraftServer.");
        SUCCESSFUL_OPERATIONS.put("metapotent_flashfur", true);
    }

    public static void transformOwnGetHealthMethods() throws UnmodifiableClassException {
        ClassFileTransformer classFileTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (className.equals("flashfur/omnimobs/entities/base/BossEntity")) {
                    OmniMobs.log("Transforming BossEntity...");
                    ClassReader reader = new ClassReader(classfileBuffer);
                    MixinClassWriter writer = new MixinClassWriter(reader, 2);
                    GetHealthPatcherClassVisitor visitor = new GetHealthPatcherClassVisitor((ClassVisitor)writer, BossEntity.class);
                    reader.accept((ClassVisitor)visitor, 8);
                    return writer.toByteArray();
                }
                return null;
            }
        };
        OmniMobs.instrumentation.addTransformer(classFileTransformer, true);
        OmniMobs.instrumentation.retransformClasses(BossEntity.class);
    }

    public static void transformAndRemoveMixins() throws UnmodifiableClassException {
        OmniMobs.log("Transforming and removing Mixins...");
        final ArrayList<Class<EntityUtil>> classesToPatch = new ArrayList<Class<EntityUtil>>();
        classesToPatch.add(MetapotentFlashfur.class);
        classesToPatch.add(MetapotentFlashfurRenderer.class);
        classesToPatch.add(EntityUtil.class);
        ClassFileTransformer classFileTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (!classesToPatch.contains(classBeingRedefined)) {
                    return null;
                }
                ClassReader reader = new ClassReader(classfileBuffer);
                MixinClassWriter writer = new MixinClassWriter(reader, 2);
                PreventMixinsClassVisitor visitor = new PreventMixinsClassVisitor((ClassVisitor)writer);
                reader.accept((ClassVisitor)visitor, 8);
                return writer.toByteArray();
            }
        };
        OmniMobs.instrumentation.addTransformer(classFileTransformer, true);
        OmniMobs.instrumentation.retransformClasses(classesToPatch.toArray(new Class[0]));
        OmniMobs.log("Patched methods.");
    }

    public static void debugWriteToFile(byte[] classfileBuffer, Class<?> c) {
        OmniMobs.log("Writing to file " + c.getSimpleName() + ".class...");
        try (FileOutputStream fos = new FileOutputStream(c.getSimpleName() + ".class");){
            fos.write(classfileBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

