/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.base;

import flashfur.omnimobs.entities.anticheat.AccessChecker;
import flashfur.omnimobs.entities.anticheat.HealthManager;
import flashfur.omnimobs.entities.anticheat.StackChecker;
import flashfur.omnimobs.entities.base.BossMusic;
import flashfur.omnimobs.entities.base.abilities.AbstractAbility;
import flashfur.omnimobs.entities.base.abilities.AbstractMove;
import flashfur.omnimobs.entities.interfaces.IMusicEntity;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncBossMove;
import flashfur.omnimobs.network.S2CSyncDamageFlash;
import flashfur.omnimobs.util.EntityUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BossEntity
extends PathfinderMob
implements IMusicEntity {
    private static final String HEALTH_TAG = "omnimobs_boss_health";
    private LivingEntity target = null;
    private final BossMusic music = new BossMusic(this);
    protected int iFrames = 0;
    protected int healTimer = 0;
    protected final ServerBossEvent bossEvent;
    public static final EntityDataAccessor<Boolean> DATA_REMOVED = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Rotations> DATA_ROTATION_LOCK = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Boolean> DATA_NO_MOVE = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_MOVE_COOLDOWN = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final List<AbstractAbility> abilities = new ArrayList<AbstractAbility>();
    public AbstractAbility currentMove;

    public BossEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.bossEvent = new ServerBossEvent((Component)Component.m_237113_((String)this.bossBarFull()), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        HealthManager.addEntity(this);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.registerAbilities();
    }

    public static boolean checkDespawnImmunity(Entity entity) {
        BossEntity bossEntity;
        return entity instanceof BossEntity && (Boolean)(bossEntity = (BossEntity)entity).m_20088_().m_135370_(DATA_REMOVED) == false && StackChecker.notCalledFromOmniMobsOrMinecraft(2, 10);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMOVED, (Object)false);
        this.f_19804_.m_135372_(DATA_ROTATION_LOCK, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(DATA_NO_MOVE, (Object)false);
        this.f_19804_.m_135372_(DATA_MOVE_COOLDOWN, (Object)0);
    }

    protected boolean usingBlockingAbility() {
        AbstractAbility abstractAbility = this.currentMove;
        if (abstractAbility instanceof AbstractMove) {
            AbstractMove abstractMove = (AbstractMove)abstractAbility;
            return abstractMove.isBlocking();
        }
        return false;
    }

    public void registerAbilities() {
    }

    public void updateMoves() {
        if (!this.m_9236_().m_5776_()) {
            if ((Integer)this.f_19804_.m_135370_(DATA_MOVE_COOLDOWN) > 0) {
                this.f_19804_.m_135381_(DATA_MOVE_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DATA_MOVE_COOLDOWN) - 1));
            }
            this.decideMove();
        }
        for (AbstractAbility move : this.getAbilities()) {
            move.tick();
        }
    }

    public void decideMove() {
        if (this.currentMove == null && this.m_5448_() != null) {
            ArrayList<AbstractMove> moveList = new ArrayList<AbstractMove>();
            for (AbstractAbility ability : this.getAbilities()) {
                if (!(ability instanceof AbstractMove)) continue;
                AbstractMove move = (AbstractMove)ability;
                moveList.add(move);
            }
            List<AbstractMove> sortedMoves = moveList.stream().sorted(Comparator.comparingInt(AbstractMove::getPriority)).toList();
            for (AbstractMove sortedMove : sortedMoves) {
                if (!sortedMove.canUse()) continue;
                this.setCurrentMove(sortedMove);
                sortedMove.start();
                break;
            }
        }
    }

    public void addAbility(AbstractAbility ability) {
        if (ability instanceof AbstractMove) {
            AbstractMove move = (AbstractMove)ability;
            move.setPriority(this.getAbilities().size());
        }
        ability.setId(this.getAbilities().size());
        this.getAbilities().add(ability);
    }

    public void postMoveEvent(String event) {
        for (AbstractAbility move : this.getAbilities()) {
            if (!move.isActive()) continue;
            move.handleEvent(event);
        }
    }

    public float getDamageCap() {
        return this.m_21233_() / 20.0f;
    }

    protected int getIFrames() {
        return 10;
    }

    protected float getResistance() {
        return 1.0f;
    }

    protected float getWeakDamageLimit() {
        return 0.0f;
    }

    protected int getHealTime() {
        return 20;
    }

    protected float getHealAmount() {
        return this.m_21233_() / 200.0f;
    }

    @Override
    public SoundEvent getMusic() {
        return SoundEvents.f_271165_;
    }

    @Override
    public boolean canPlayMusic() {
        boolean b = false;
        for (Entity entity : Minecraft.m_91087_().f_91073_.m_104735_()) {
            if (!entity.equals((Object)this) || !(this.m_20270_((Entity)Minecraft.m_91087_().f_91074_) < (float)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 16))) continue;
            b = true;
        }
        return b;
    }

    public List<AbstractAbility> getAbilities() {
        if (this.abilities == null) {
            return new ArrayList<AbstractAbility>();
        }
        return this.abilities;
    }

    public void correctRotation() {
        this.m_146926_(((Rotations)this.f_19804_.m_135370_(DATA_ROTATION_LOCK)).m_123156_());
        this.m_5616_(((Rotations)this.f_19804_.m_135370_(DATA_ROTATION_LOCK)).m_123157_());
        this.m_146922_(((Rotations)this.f_19804_.m_135370_(DATA_ROTATION_LOCK)).m_123157_());
    }

    public AbstractAbility getCurrentMove() {
        return this.currentMove;
    }

    public void setCurrentMove(AbstractMove currentMove) {
        this.currentMove = currentMove;
        PacketHandler.sendToClient(new S2CSyncBossMove(currentMove.getId(), this.m_19879_()));
    }

    public String bossBarName() {
        return this.m_7755_().getString();
    }

    public String bossBarHealthDisplay() {
        if ((double)this.m_21233_() >= 1.0E9) {
            return "\u00a7r\u00a7c" + String.format("%.2e", Float.valueOf(HealthManager._a(this))) + "/" + String.format("%.2e", Float.valueOf(this.m_21233_()));
        }
        return "\u00a7r\u00a7c" + Math.round(HealthManager._a(this)) + "/" + Math.round(this.m_21233_());
    }

    protected String bossBarFull() {
        return "Omni-Mobs:" + this.m_19879_();
    }

    public String bossBarTexture() {
        return "white_bossbar";
    }

    protected float bossBarProgress() {
        return HealthManager._a(this) / this.m_21233_();
    }

    public void renderOnBossbar(GuiGraphics guiGraphics, int i, int i1, BossEvent bossEvent, int i2, int i3) {
    }

    public void m_8119_() {
        this.negateHealthDeltaSyncedData();
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            BossMusic.playMusic(this.music, this);
        }
        if (!(this.m_5448_() == null || this.m_5448_().m_6084_() && EntityUtil.getAllEntities(this.m_9236_()).contains(this.m_5448_()))) {
            this.m_6710_(null);
        }
        try {
            this.updateMoves();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.iFrames > 0) {
                --this.iFrames;
            }
            if (this.healTimer > 0) {
                --this.healTimer;
            }
            if (this.healTimer == 0) {
                this.m_5634_(this.getHealAmount());
                this.healTimer = this.getHealTime();
            }
        }
        this.bossEvent.m_6456_((Component)Component.m_237113_((String)this.bossBarFull()));
        this.bossEvent.m_142711_(this.bossBarProgress());
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        amount /= this.getResistance();
        if (this.iFrames > 0) {
            return false;
        }
        if (amount < this.getWeakDamageLimit()) {
            return false;
        }
        if (amount <= 0.0f) {
            return false;
        }
        float finalAmount = amount = Math.min(amount, this.getDamageCap());
        AccessChecker.performPrivilegedAction(() -> HealthManager.setHealth(this, HealthManager._a(this) - finalAmount));
        this.iFrames = this.getIFrames();
        if (this.m_6084_()) {
            this.m_6677_(source);
        } else if (!this.f_20890_) {
            if (this.m_5592_() != null) {
                this.m_5496_(this.m_5592_(), this.m_6121_(), this.m_6100_());
            }
            this.m_6667_(source);
        }
        this.f_20916_ = this.f_20917_ = this.getIFrames();
        this.f_267362_.m_267771_(1.5f);
        PacketHandler.sendToClient(new S2CSyncDamageFlash(this.f_20917_, this.m_19879_()));
        if (source.m_7640_() != null) {
            Entity directEntity = source.m_7640_();
            double difference = directEntity.m_20185_() - this.m_20185_();
            double v = directEntity.m_20189_() - this.m_20189_();
            while (difference * difference + v * v < 1.0E-4) {
                difference = (Math.random() - Math.random()) * 0.01;
                v = (Math.random() - Math.random()) * 0.01;
            }
            this.m_147240_(0.4f, difference, v);
        }
        return true;
    }

    public void m_21153_(float value) {
        float amount;
        if (value > HealthManager._a(this)) {
            AccessChecker.performPrivilegedAction(() -> HealthManager.setHealth(this, value));
        }
        if ((amount = HealthManager._a(this) - value) > 0.0f) {
            this.m_6469_(this.m_269291_().m_269264_(), amount);
        }
    }

    public float m_21223_() {
        return HealthManager._a(this);
    }

    public float m_21233_() {
        return (float)this.m_21133_(Attributes.f_22276_);
    }

    private void negateHealthDeltaSyncedData() {
        this.f_19804_.f_135345_.forEach((integer, dataItem) -> {
            EntityDataAccessor entityDataAccessor = dataItem.m_135396_();
            try {
                EntityDataAccessor accessor = entityDataAccessor;
                if (((Float)this.f_19804_.m_135370_(accessor)).floatValue() == this.m_21223_() - HealthManager._a(this) || ((Float)this.f_19804_.m_135370_(accessor)).floatValue() != 0.0f) {
                    EntityUtil.forceSetEntityData(this.f_19804_, accessor, Float.valueOf(0.0f));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
    }

    public void m_6457_(@NotNull ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(@NotNull ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_6153_() {
        if (HealthManager.getHealthHashMap().getOrDefault(this, Float.valueOf(this.m_21233_())).floatValue() > 0.0f) {
            return;
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
        }
        if (this.f_20919_ >= 20 && !this.m_213877_()) {
            EntityUtil.forceRemove((Entity)this, Entity.RemovalReason.KILLED);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason removalReason) {
    }

    public void m_142467_(@NotNull Entity.RemovalReason removalReason) {
    }

    public boolean m_213877_() {
        return false;
    }

    @Nullable
    public Entity.RemovalReason m_146911_() {
        return null;
    }

    public void m_142036_() {
        EntityUtil.forceRemoveNoPacket((Entity)this, Entity.RemovalReason.DISCARDED, true);
    }

    public void m_146917_(int value) {
    }

    public void m_20301_(int i) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_20301_(i);
        }
    }

    public void m_6021_(double x, double y, double z) {
    }

    protected void m_6089_() {
        EntityUtil.forceRemove((Entity)this, Entity.RemovalReason.CHANGED_DIMENSION);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_147240_(p_147241_, p_147242_, p_147243_);
        }
    }

    public void m_6710_(LivingEntity target) {
        if (target != this && !StackChecker.notCalledFromAllowedPackage()) {
            this.target = target;
        }
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.target;
    }

    public void m_7618_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityAnchorArgument.Anchor anchor, @NotNull Vec3 vec3) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_7618_(anchor, vec3);
        }
    }

    public void m_21391_(@NotNull Entity entity, float v, float v1) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_21391_(entity, v, v1);
        }
    }

    public void m_20242_(boolean noGravity) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_20242_(noGravity);
        }
    }

    public void m_21557_(boolean noAi) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_21557_(noAi);
        }
    }

    protected void m_19915_(float v, float v1) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_19915_(v, v1);
        }
    }

    public void m_147244_(boolean discardFriction) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_147244_(discardFriction);
        }
    }

    public void m_183634_() {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_183634_();
        }
    }

    public void m_21561_(boolean p_21562_) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_21561_(p_21562_);
        }
    }

    public void m_289603_(boolean b, @NotNull Vec3 vec3) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_289603_(b, vec3);
        }
    }

    public void m_6862_(boolean jumping) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_6862_(jumping);
        }
    }

    public void m_6858_(boolean sprinting) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_6858_(sprinting);
        }
    }

    public boolean m_20067_() {
        return false;
    }

    public boolean m_21255_() {
        return false;
    }

    public boolean m_146890_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public boolean m_147207_(@NotNull MobEffectInstance mobEffectInstance, @Nullable Entity entity) {
        return false;
    }

    public void m_147215_(@NotNull MobEffectInstance mobEffectInstance, @Nullable Entity entity) {
    }

    public void m_7911_(float absorptionAmount) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_7911_(absorptionAmount);
        }
    }

    public void m_21310_(int noActionTime) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_21310_(noActionTime);
        }
    }

    public void m_20334_(double x, double y, double z) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            if (((Boolean)this.m_20088_().m_135370_(DATA_NO_MOVE)).booleanValue()) {
                super.m_20334_(0.0, y, 0.0);
                return;
            }
            super.m_20334_(x, y, z);
        }
    }

    public void m_20256_(@NotNull Vec3 movement) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            if (((Boolean)this.m_20088_().m_135370_(DATA_NO_MOVE)).booleanValue()) {
                super.m_20256_(movement.m_82542_(0.0, 1.0, 0.0));
                return;
            }
            super.m_20256_(movement);
            return;
        }
        super.m_20256_(movement.m_82490_(this.getSetDeltaMovementResistance()));
    }

    public void m_19884_(double v, double v1) {
        if (((Boolean)this.m_20088_().m_135370_(DATA_NO_MOVE)).booleanValue()) {
            return;
        }
        super.m_19884_(v, v1);
    }

    public void m_6034_(double x, double y, double z) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_6034_(x, y, z);
        }
    }

    public void m_20343_(double x, double y, double z) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_20343_(x, y, z);
        }
    }

    public void m_6842_(boolean invisible) {
        if (!StackChecker.notCalledFromOmniMobsOrMinecraft()) {
            super.m_6842_(invisible);
        }
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        compoundTag.m_128350_(HEALTH_TAG, HealthManager._a(this));
        super.m_7380_(compoundTag);
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        AccessChecker.performPrivilegedAction(() -> HealthManager.updateHealth(this, compoundTag.m_128457_(HEALTH_TAG)));
        super.m_7378_(compoundTag);
    }

    public boolean m_6779_(@NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_7500_() && !player.m_5833_();
        }
        return !(entity.m_21223_() <= 0.0f) && !entity.m_213877_();
    }

    public double getSetDeltaMovementResistance() {
        return 1.0;
    }

    public boolean m_21224_() {
        return HealthManager._c(this);
    }

    public boolean m_6084_() {
        return HealthManager._b(this);
    }

    public float calculatePercentDamage(LivingEntity entity, float flatDamage, float percentDamage) {
        float maxHealth = entity.m_21233_();
        if (!EntityUtil.REAL_MAX_HEALTH.containsKey(entity) && entity.m_21223_() > maxHealth) {
            AccessChecker.performPrivilegedAction(() -> EntityUtil.REAL_MAX_HEALTH.put((Entity)entity, Float.valueOf(entity.m_21223_())));
        }
        if (EntityUtil.REAL_MAX_HEALTH.containsKey(entity)) {
            maxHealth = EntityUtil.REAL_MAX_HEALTH.getOrDefault(entity, Float.valueOf(maxHealth)).floatValue();
        }
        return flatDamage + maxHealth * (percentDamage / 100.0f);
    }
}

