/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.base.abilities;

import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.base.abilities.AbstractAbility;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncAbilityData;
import flashfur.omnimobs.network.S2CSyncBossMove;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.MathsUtil;
import java.util.Random;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;

public abstract class AbstractMove
extends AbstractAbility {
    private final AnimationState[] animation;
    private final int time;
    private final float range;
    private final boolean blocking;
    private final int endCooldown;
    private int ticks = 0;
    private int selectedAnimation;
    private int priority = 0;

    public AbstractMove(BossEntity entity, AnimationState[] state, int time, float range, boolean blocking, int endCooldown) {
        super(entity);
        this.animation = state;
        this.time = time;
        this.range = range;
        this.blocking = blocking;
        this.endCooldown = endCooldown;
    }

    public void start() {
        this.setTicks(this.getTime());
        this.setSelectedAnimation(this.chooseAnimation());
    }

    protected int chooseAnimation() {
        return new Random().nextInt(this.getAnimations().length);
    }

    @Override
    public void tick() {
        if (this.getEntity().m_9236_().m_5776_()) {
            this.playAnimation();
        } else {
            if (this.getTicks() > 0) {
                this.setTicks(this.getTicks() - 1);
                if (this.getTicks() <= 0) {
                    this.end();
                }
            }
            if (this.isActive()) {
                if (this.getEntity().getCurrentMove() != this) {
                    this.end();
                    return;
                }
                this.moveSpecificTick();
            } else {
                this.inactiveTick();
            }
        }
    }

    public void end() {
        this.getEntity().currentMove = null;
        PacketHandler.sendToClient(new S2CSyncBossMove(-1, this.getEntity().m_19879_()));
        this.getEntity().m_20088_().m_135381_(BossEntity.DATA_MOVE_COOLDOWN, (Object)((int)((float)this.endCooldown / MathsUtil.randFloat(1.0f, 2.0f))));
    }

    protected void moveSpecificTick() {
    }

    protected void inactiveTick() {
    }

    @Override
    public boolean isActive() {
        return this.getTicks() > 0;
    }

    public boolean canUse() {
        if ((Integer)this.getEntity().m_20088_().m_135370_(BossEntity.DATA_MOVE_COOLDOWN) > 0 && !this.ignoreCooldown()) {
            return false;
        }
        if (this.getSpecialPriority() < 0 && Math.random() < 1.0 / (double)Math.abs(this.getSpecialPriority())) {
            return false;
        }
        return !this.isActive() && this.isInRange();
    }

    protected void incrementValue(EntityDataAccessor<Integer> value, int amount) {
        this.getEntity().m_20088_().m_135381_(value, (Object)((Integer)this.getEntity().m_20088_().m_135370_(value) + amount));
    }

    public boolean isInRange() {
        if (this.getEntity().m_5448_() == null) {
            return false;
        }
        return EntityUtil.distanceToEntityWithHitboxes((Entity)this.getEntity(), (Entity)this.getEntity().m_5448_()) <= (double)this.getRange();
    }

    protected boolean canPlayAnimation() {
        return this.isActive();
    }

    protected void playAnimation() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_246184_(this.canPlayAnimation() && this.getAnimation() == animationState, this.getEntity().f_19797_);
        }
    }

    public int getPriority() {
        return this.canUse() ? this.priority - this.getSpecialPriority() : Integer.MAX_VALUE;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected int getSpecialPriority() {
        return 0;
    }

    public AnimationState[] getAnimations() {
        return this.animation;
    }

    public AnimationState getAnimation() {
        return this.getAnimations()[this.getSelectedAnimation()];
    }

    public int getSelectedAnimation() {
        return this.selectedAnimation;
    }

    public void setSelectedAnimation(int selectedAnimation) {
        this.selectedAnimation = selectedAnimation;
        PacketHandler.sendToClient(new S2CSyncAbilityData(selectedAnimation, "selectedAnimation", this.getId(), this.getEntity().m_19879_()));
    }

    public int getTime() {
        return this.time;
    }

    public float getRange() {
        return this.range;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
        PacketHandler.sendToClient(new S2CSyncAbilityData(ticks, "ticks", this.getId(), this.getEntity().m_19879_()));
    }

    public boolean isBlocking() {
        return this.blocking && this.isActive();
    }

    public boolean ignoreCooldown() {
        return false;
    }
}

