/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.iron_golem;

import flashfur.omnimobs.entities.anticheat.HealthManager;
import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.init.SoundInit;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.ForceDamageSource;
import flashfur.omnimobs.util.MathsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IronGolem
extends BossEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState punchAnimationState = new AnimationState();
    public AnimationState punch2AnimationState = new AnimationState();
    public AnimationState bangAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();
    public AnimationState musclesAnimationState = new AnimationState();
    public AnimationState stompAnimationState = new AnimationState();
    public AnimationState armWaveAnimationState = new AnimationState();
    public AnimationState armWave2AnimationState = new AnimationState();
    protected static final EntityDataAccessor<Integer> DATA_PUNCHING_ANIMATION = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_PUNCHING_ANIMATION_TIMER = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_PUNCHING_TIMER = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_BANGING_TIMER = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_FLEXING_MUSCLES_TIMER = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_STOMP_TIMER = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_SMASH_TIMER = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public IronGolem(EntityType<? extends BossEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder applyAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.85).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22277_, 256.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PUNCHING_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(DATA_PUNCHING_ANIMATION_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_PUNCHING_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_BANGING_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_FLEXING_MUSCLES_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_STOMP_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_SMASH_TIMER, (Object)0);
    }

    public double m_21133_(@NotNull Attribute attribute) {
        if (attribute == Attributes.f_22276_) {
            return 200.0;
        }
        return super.m_21133_(attribute);
    }

    @Override
    public SoundEvent getMusic() {
        return (SoundEvent)SoundInit.IRON_GOLEM_THEME.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_252836_();
        this.m_21195_(MobEffects.f_19620_);
        this.playAnimations();
        if (!this.m_9236_().m_5776_()) {
            this.updateTimers();
            this.updatePunching();
            this.updateBanging();
            this.updateFlexingMuscles();
            this.updateStomping();
            this.updateGolemSmash();
        }
    }

    private void playAnimations() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(HealthManager._b(this) && !this.f_267362_.m_267780_() && this.playIdle(), this.f_19797_);
            this.punchAnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) > 0 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 0, this.f_19797_);
            this.punch2AnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) > 0 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 1, this.f_19797_);
            this.bangAnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) > 0, this.f_19797_);
            this.stompAnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) > 0, this.f_19797_);
            this.smashAnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) > 0, this.f_19797_);
            this.armWaveAnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) > 0 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 2, this.f_19797_);
            this.armWave2AnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) > 0 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 3, this.f_19797_);
            this.musclesAnimationState.m_246184_((Integer)this.f_19804_.m_135370_(DATA_FLEXING_MUSCLES_TIMER) > 0, this.f_19797_);
        }
    }

    @Override
    protected boolean usingBlockingAbility() {
        return (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_TIMER) > 0 || (Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) > 0 || (Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) > 0;
    }

    private void updateTimers() {
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION_TIMER, (Object)((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_PUNCHING_TIMER, (Object)((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_TIMER) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_BANGING_TIMER, (Object)((Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_FLEXING_MUSCLES_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_FLEXING_MUSCLES_TIMER, (Object)((Integer)this.f_19804_.m_135370_(DATA_FLEXING_MUSCLES_TIMER) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_STOMP_TIMER, (Object)((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_SMASH_TIMER, (Object)((Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) - 1));
        }
        if (this.usingBlockingAbility()) {
            this.f_19804_.m_135381_(DATA_BANGING_TIMER, (Object)0);
        }
        if (this.usingBlockingAbility() || this.m_5448_() != null) {
            this.f_19804_.m_135381_(DATA_FLEXING_MUSCLES_TIMER, (Object)0);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) > 0 || (Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) > 0) {
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION_TIMER, (Object)0);
        }
    }

    private void updatePunching() {
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 4.0f && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_TIMER) == 0) {
            this.f_19804_.m_135381_(DATA_PUNCHING_TIMER, (Object)MathsUtil.randInt(64, 80));
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION, (Object)MathsUtil.randInt(0, 3));
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION_TIMER, (Object)64);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) == 42 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) <= 1) {
            this.doPunch();
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) == 29 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 1) {
            this.doPunch();
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) == 54 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) >= 2) {
            this.doArmSlam(true);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) == 34 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 3) {
            this.doArmSlam(false);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 0 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) < 14) {
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION_TIMER, (Object)0);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 2 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) < 34) {
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION_TIMER, (Object)0);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION) == 3 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) < 14) {
            this.f_19804_.m_135381_(DATA_PUNCHING_ANIMATION_TIMER, (Object)0);
        }
    }

    private void doPunch() {
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 4.0f) {
            for (Entity entities : EntityUtil.entityList(1.0f, this.m_9236_(), this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_())) {
                if (entities == this || !(entities instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entities;
                EntityUtil.forceHurt((LivingEntity)this, livingEntity, new ForceDamageSource(this.calculatePercentDamage(livingEntity, 20.0f, 5.0f), 5.0f));
            }
            EntityUtil.cameraShake(2.0f, this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), this.m_9236_());
            this.m_9236_().m_5594_(null, this.m_5448_().m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 0.5f);
            this.m_9236_().m_5594_(null, this.m_5448_().m_20183_(), SoundEvents.f_12057_, SoundSource.HOSTILE, 5.0f, 1.0f);
        }
    }

    private void doArmSlam(boolean right) {
        boolean hitEntity = false;
        if (this.m_5448_() != null) {
            Vec3 pos = this.m_20182_();
            double yaw = this.m_146908_() - 90.0f;
            if (right) {
                yaw = this.m_146908_() + 90.0f;
            }
            Vec3 addPos = new Vec3(2.5 * Math.cos((yaw + 90.0) * (Math.PI / 180)), 1.5, 2.5 * Math.sin((yaw + 90.0) * (Math.PI / 180)));
            pos.m_82549_(addPos);
            for (Entity entities : EntityUtil.entityList(3.0f, this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_)) {
                if (entities == this || !(entities instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entities;
                EntityUtil.forceHurt((LivingEntity)this, livingEntity, new ForceDamageSource(this.calculatePercentDamage(livingEntity, 20.0f, 5.0f), 5.0f));
                hitEntity = true;
            }
            this.m_9236_().m_5594_(null, this.m_5448_().m_20183_(), SoundEvents.f_12057_, SoundSource.HOSTILE, 5.0f, 1.0f);
            if (hitEntity) {
                EntityUtil.cameraShake(2.0f, this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), this.m_9236_());
                this.m_9236_().m_5594_(null, this.m_5448_().m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 0.5f);
            }
        }
    }

    private void updateBanging() {
        if ((Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) <= 0 && Math.random() < 0.01 && !this.usingBlockingAbility() && (Integer)this.f_19804_.m_135370_(DATA_FLEXING_MUSCLES_TIMER) <= 0 && this.playExtraAnimations()) {
            this.f_19804_.m_135381_(DATA_BANGING_TIMER, (Object)50);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) == 28) {
            EntityUtil.cameraShake(2.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
            this.m_9236_().m_5594_(null, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 0.5f);
        }
    }

    private void updateFlexingMuscles() {
        if ((Integer)this.f_19804_.m_135370_(DATA_FLEXING_MUSCLES_TIMER) <= 0 && Math.random() < 0.01 && !this.usingBlockingAbility() && this.m_5448_() == null && this.playExtraAnimations() && (Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) <= 0) {
            this.f_19804_.m_135381_(DATA_FLEXING_MUSCLES_TIMER, (Object)170);
        }
    }

    private void updateStomping() {
        if ((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) <= 0 && Math.random() < 0.002 && this.m_5448_() != null) {
            this.f_19804_.m_135381_(DATA_STOMP_TIMER, (Object)50);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) == 28) {
            for (Entity entity : EntityUtil.entityList(20.0f, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_())) {
                if (entity == this || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                EntityUtil.forceHurt((LivingEntity)this, livingEntity, new ForceDamageSource(this.calculatePercentDamage(livingEntity, 30.0f, 6.6666665f) - this.m_20270_((Entity)livingEntity) * 3.0f, 7.5f));
            }
            EntityUtil.cameraShake(2.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
            EntityUtil.explosionVfx(5.0f, 10, this.m_20182_(), null, this.m_9236_());
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 0.5f);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) > 0) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
    }

    private void updateGolemSmash() {
        if ((Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) <= 0 && Math.random() < 0.001 && this.m_5448_() != null) {
            this.f_19804_.m_135381_(DATA_SMASH_TIMER, (Object)80);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) == 56) {
            EntityUtil.explosionVfx(15.0f, 50, this.m_20182_(), null, this.m_9236_());
            for (Entity entities : EntityUtil.entityList(50.0f, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_())) {
                if (entities == this || !(entities instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entities;
                EntityUtil.forceHurt((LivingEntity)this, livingEntity, new ForceDamageSource(this.calculatePercentDamage(livingEntity, 50.0f, 10.0f) - this.m_20270_((Entity)livingEntity), 10.0f));
            }
            EntityUtil.cameraShake(2.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 0.5f);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) > 0) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
    }

    private boolean playIdle() {
        return (Integer)this.f_19804_.m_135370_(DATA_BANGING_TIMER) <= 0 && (Integer)this.f_19804_.m_135370_(DATA_FLEXING_MUSCLES_TIMER) <= 0 && (Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) <= 0 && (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) <= 0;
    }

    private boolean playExtraAnimations() {
        return (Integer)this.f_19804_.m_135370_(DATA_PUNCHING_ANIMATION_TIMER) <= 0 && (Integer)this.f_19804_.m_135370_(DATA_STOMP_TIMER) <= 0 && (Integer)this.f_19804_.m_135370_(DATA_SMASH_TIMER) <= 0;
    }

    @Override
    public String bossBarName() {
        return "\u00a7r\u00a74\u00a7l" + Component.m_237115_((String)"entity.omnimobs.iron_golem").getString() + "\u00a7r";
    }

    @Override
    public String bossBarTexture() {
        return "grey_bossbar";
    }

    protected void m_7355_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.m_5496_(SoundEvents.f_12010_, 5.0f, 1.0f);
        EntityUtil.cameraShake(0.5f, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_9236_());
    }

    @Nullable
    public SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12008_;
    }

    @Nullable
    public SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    @Override
    protected float getResistance() {
        return 5.0f;
    }

    @Override
    protected float getWeakDamageLimit() {
        return this.m_21233_() / 200.0f;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        return false;
    }

    public float m_6121_() {
        return 5.0f;
    }

    public void m_20254_(int secondsOnFire) {
    }

    public void m_7311_(int remainingFireTicks) {
    }

    @Override
    protected int getHealTime() {
        return 40;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity entity;
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.m_6710_(livingEntity);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public double getSetDeltaMovementResistance() {
        return 0.2;
    }
}

