/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.iron_golem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flashfur.omnimobs.entities.iron_golem.IronGolem;
import flashfur.omnimobs.entities.iron_golem.IronGolemAnimation;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class IronGolemModel
extends HierarchicalModel<IronGolem> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("omnimobs", "iron_golem"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart main;
    private final ModelPart body;

    public IronGolemModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.main = this.root.m_171324_("main");
        this.body = this.main.m_171324_("body");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-9.0f, -17.5f, -5.75f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 70).m_171488_(-4.5f, -5.5f, -2.75f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-15.5f, (float)-0.25f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.5f, (float)-1.75f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-5.5f));
        PartDefinition arm0 = body.m_171599_("arm0", CubeListBuilder.m_171558_().m_171514_(60, 21).m_171488_(-2.0f, -2.5f, -3.0f, 4.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-11.0f, (float)-15.5f, (float)0.25f));
        PartDefinition arm2 = arm0.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(60, 36).m_171488_(-2.0f, 0.0f, -3.0f, 4.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.5f, (float)0.0f));
        PartDefinition arm1 = body.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(60, 58).m_171488_(-2.0f, -2.5f, -3.0f, 4.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)11.0f, (float)-15.5f, (float)0.25f));
        PartDefinition arm3 = arm1.m_171599_("arm3", CubeListBuilder.m_171558_().m_171514_(60, 73).m_171488_(-2.0f, 0.0f, -3.0f, 4.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.5f, (float)0.0f));
        PartDefinition leg0 = main.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leg2 = leg0.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(37, 8).m_171488_(-3.0f, 0.0f, -2.5f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)5.0f, (float)-0.5f));
        PartDefinition leg1 = main.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171480_().m_171488_(-3.5f, -3.0f, -3.0f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leg3 = leg1.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(60, 8).m_171480_().m_171488_(-3.0f, 0.0f, -2.5f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.5f, (float)5.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(IronGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.m_233381_(entity.idleAnimationState, IronGolemAnimation.idle, ageInTicks);
        this.m_233381_(entity.punchAnimationState, IronGolemAnimation.punch, ageInTicks);
        this.m_233381_(entity.punch2AnimationState, IronGolemAnimation.punch2, ageInTicks);
        this.m_233381_(entity.bangAnimationState, IronGolemAnimation.bang, ageInTicks);
        this.m_233381_(entity.smashAnimationState, IronGolemAnimation.slam, ageInTicks);
        this.m_233381_(entity.musclesAnimationState, IronGolemAnimation.muscles, ageInTicks);
        this.m_233381_(entity.stompAnimationState, IronGolemAnimation.stomp, ageInTicks);
        this.m_233381_(entity.armWaveAnimationState, IronGolemAnimation.armWave, ageInTicks);
        this.m_233381_(entity.armWave2AnimationState, IronGolemAnimation.armWave2, ageInTicks);
        this.m_267799_(IronGolemAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 2.5f);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

