/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.metapotent_flashfur;

import flashfur.omnimobs.entities.anticheat.AccessChecker;
import flashfur.omnimobs.entities.anticheat.HealthManager;
import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.base.BossMusic;
import flashfur.omnimobs.entities.interfaces.IMusicEntity;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurEntity;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurLevel;
import flashfur.omnimobs.entities.metapotent_flashfur.StarVFX;
import flashfur.omnimobs.entities.metapotent_flashfur.powers.MetaBeam;
import flashfur.omnimobs.entities.metapotent_flashfur.powers.MetaLightning;
import flashfur.omnimobs.entities.metapotent_flashfur.powers.ScreenFlash;
import flashfur.omnimobs.init.EntityInit;
import flashfur.omnimobs.init.SoundInit;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncSetPos;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.ForceDamageSource;
import flashfur.omnimobs.util.MathsUtil;
import flashfur.omnimobs.util.ModCompatUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.joml.Vector3f;

public class MetapotentFlashfur
implements IMusicEntity {
    public static int rgb = Color.HSBtoRGB(0.6f, 0.5f, 0.5f);
    public static float[] lightBlue = new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    public static int rgb2 = Color.HSBtoRGB(0.7f, 1.0f, 1.0f);
    public static float[] purple = new float[]{(float)(rgb2 >> 16 & 0xFF) / 255.0f, (float)(rgb2 >> 8 & 0xFF) / 255.0f, (float)(rgb2 & 0xFF) / 255.0f};
    public List<StarVFX> stars = new ArrayList<StarVFX>();
    public Vec3 pos;
    public Vec3 posO;
    private float rotX;
    private float rotXO;
    private float rotY;
    private float rotYO;
    private Level level;
    private LivingEntity target = null;
    private Vec3 deltaMovement = Vec3.f_82478_;
    public UUID id;
    private AABB boundingBox;
    public int tickCount = 0;
    public WalkAnimationState walkAnimation = new WalkAnimationState();
    private boolean removed = false;
    private MetapotentFlashfurEntity metapotentFlashfurProxy;
    public PlayerTeam team = null;
    private final double eyeHeight = 8.0;
    private final double width = 10.0;
    private final double height = 12.0;
    private final BossMusic music = new BossMusic(this);
    public final ServerBossEvent bossEvent;
    private int livingSoundTimer = 0;
    private Vec3 pathfindingToPos;
    private int pathfindingTimer = 0;
    private boolean noGravity = false;
    public int beamTimer = 0;
    public int eraseTimer = 0;
    public int swipeTimer = 0;
    public int swipeAnimationTimer = 0;
    public int swipeAnimation = 0;
    public int sittingAnimation = 0;
    public int stopSittingAnimation = 0;
    public int throwInAirTimer = 0;
    public int totalityBoomTimer = 0;
    private int targetDeathTime = 0;
    private LivingEntity oldTarget = null;
    MetaBeam metaBeam;
    List<Entity> entitiesToAttack = new ArrayList<Entity>();
    public AnimationState idleAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState stopSittingAnimationState = new AnimationState();
    public final AnimationState swipe1AnimationState = new AnimationState();
    public final AnimationState swipe2AnimationState = new AnimationState();
    public final AnimationState swipe3AnimationState = new AnimationState();
    public final AnimationState swipe4AnimationState = new AnimationState();
    public final AnimationState swipe5AnimationState = new AnimationState();
    public AnimationState eraseAnimationState = new AnimationState();
    public AnimationState beamAnimationState = new AnimationState();
    public AnimationState throwInAirAnimationState = new AnimationState();
    public AnimationState totalityBoomAnimationState = new AnimationState();

    public MetapotentFlashfur(Vec3 pos, float rotX, float rotY, Level level) {
        this.pos = pos;
        this.posO = pos;
        this.rotX = rotX;
        this.rotXO = rotX;
        this.rotY = rotY;
        this.rotYO = rotY;
        this.level = level;
        this.id = UUID.randomUUID();
        MetapotentFlashfurEntity metapotentFlashfurProxy = new MetapotentFlashfurEntity((EntityType<? extends PathfinderMob>)((EntityType)EntityInit.METAPOTENT_FLASHFUR_ENTITY.get()), this.level());
        metapotentFlashfurProxy.metapotentFlashfur = this;
        metapotentFlashfurProxy.m_20219_(this.pos());
        EntityUtil.forceAddEntity((Entity)metapotentFlashfurProxy, this.level());
        this.metapotentFlashfurProxy = metapotentFlashfurProxy;
        this.makeBoundingBox();
        this.bossEvent = new ServerBossEvent((Component)Component.m_237113_((String)"Omni-Mobs:Metapotent Flashfur"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.pathfindingToPos = this.pos();
        this.playLivingSound();
        EntityUtil.cameraShake(2.5f, this.getX(), this.getY(), this.getZ(), this.level());
        ScreenFlash.setScreenFlash(20);
        this.level.m_5594_(null, this.blockPosition(), SoundEvents.f_12563_, SoundSource.NEUTRAL, 1.0E9f, 0.75f);
        this.level.m_5594_(null, this.blockPosition(), SoundEvents.f_11860_, SoundSource.NEUTRAL, 1.0E9f, 0.75f);
    }

    private void makeBoundingBox() {
        this.boundingBox = new AABB(this.pos.f_82479_ - 5.0, this.pos.f_82480_, this.pos.f_82481_ - 5.0, this.pos.f_82479_ + 5.0, this.pos.f_82480_ + 12.0, this.pos.f_82481_ + 5.0);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        if (target != this.metapotentFlashfurProxy) {
            this.target = target;
        }
    }

    public Vec3 pos() {
        return this.pos;
    }

    public Vec3 getPos() {
        return new Vec3(Mth.m_14139_((double)MetapotentFlashfurLevel.getPartialTick(), (double)this.posO.f_82479_, (double)this.pos.f_82479_), Mth.m_14139_((double)MetapotentFlashfurLevel.getPartialTick(), (double)this.posO.f_82480_, (double)this.pos.f_82480_), Mth.m_14139_((double)MetapotentFlashfurLevel.getPartialTick(), (double)this.posO.f_82481_, (double)this.pos.f_82481_));
    }

    public double getX() {
        return this.pos().f_82479_;
    }

    public double getY() {
        return this.pos().f_82480_;
    }

    public double getZ() {
        return this.pos().f_82481_;
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
        this.posO = pos;
        this.makeBoundingBox();
    }

    public void setPos(double x, double y, double z) {
        this.setPos(new Vec3(x, y, z));
    }

    public double distanceTo(LivingEntity entity) {
        return this.pos().m_82554_(entity.m_20182_());
    }

    public Level level() {
        return this.level;
    }

    public boolean isNoGravity() {
        return this.noGravity;
    }

    public void setNoGravity(boolean noGravity) {
        this.noGravity = noGravity;
    }

    public void tick() {
        this.makeBoundingBox();
        this.calculateEntityAnimation(false);
        this.rotXO = this.rotX;
        this.rotYO = this.rotY;
        if (!this.level().m_5776_()) {
            this.move();
            if (this.oldTarget != null && this.oldTarget.m_21224_()) {
                ++this.targetDeathTime;
            }
            this.targeting();
            float speed = 2.5f;
            if (this.getTarget() != null && this.getTarget().m_6084_()) {
                if (this.target != this.oldTarget) {
                    this.targetDeathTime = 0;
                }
                this.oldTarget = this.getTarget();
                if (!this.usingAbility()) {
                    this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getTarget().m_20182_());
                    if (this.distanceTo(this.getTarget()) > 50.0) {
                        this.setDeltaMovement(this.getLookAngle().f_82479_ * (double)speed, this.getDeltaMovement().f_82480_, this.getLookAngle().f_82481_ * (double)speed);
                    }
                }
                this.pathfindingTimer = 0;
            } else {
                this.rotX = 0.0f;
                if (!EntityUtil.getAllEntities(this.level()).contains(this.oldTarget)) {
                    this.oldTarget = null;
                }
                if (this.targetDeathTime < 100) {
                    if (this.getTarget() != null) {
                        this.target = null;
                    }
                } else {
                    this.target = this.oldTarget;
                }
                if (this.pathfindingTimer > 0) {
                    --this.pathfindingTimer;
                    if (this.sittingAnimation <= 0 && !this.usingAbility()) {
                        this.lookAt(EntityAnchorArgument.Anchor.EYES, this.pathfindingToPos);
                        this.setDeltaMovement(this.getLookAngle().f_82479_ * (double)speed, this.getDeltaMovement().f_82480_, this.getLookAngle().f_82481_ * (double)speed);
                    } else {
                        this.pathfindingTimer = 0;
                    }
                    if (this.pos().m_82554_(this.pathfindingToPos) < 10.0) {
                        this.pathfindingTimer = 0;
                    }
                } else if (Math.random() < 0.005) {
                    this.pathfindingToPos = new Vec3(this.getX() + MathsUtil.randDouble(-100.0, 100.0), this.getY(), this.getZ() + MathsUtil.randDouble(-100.0, 100.0));
                    this.pathfindingTimer = MathsUtil.randInt(10, 50);
                }
            }
            if (this.metapotentFlashfurProxy == null || !this.metapotentFlashfurProxy.m_6084_()) {
                MetapotentFlashfurEntity metapotentFlashfurProxy = new MetapotentFlashfurEntity((EntityType<? extends PathfinderMob>)((EntityType)EntityInit.METAPOTENT_FLASHFUR_ENTITY.get()), this.level());
                metapotentFlashfurProxy.metapotentFlashfur = this;
                metapotentFlashfurProxy.m_20219_(this.pos());
                EntityUtil.forceAddEntity((Entity)metapotentFlashfurProxy, this.level());
                this.metapotentFlashfurProxy = metapotentFlashfurProxy;
            }
            ++this.tickCount;
        }
        if (Math.random() < 0.01 && this.livingSoundTimer <= 0) {
            this.playLivingSound();
            this.livingSoundTimer = 50;
        }
        if (this.livingSoundTimer > 0) {
            --this.livingSoundTimer;
        }
        this.customTick();
        BossMusic.playMusic(this.music, this);
    }

    public void customTick() {
        this.updateSitting();
        this.updateTimers();
        this.performErase();
        this.updateErase();
        this.performBeam();
        this.updateBeam();
        this.performTotalityBoom();
        this.updateTotalityBoom();
        this.performThrowInAir();
        this.updateThrowInAir();
        this.updateSwipe();
        this.teleportToTarget();
        ModCompatUtil.destroyDragionn(this.level(), this.getX(), this.getY(), this.getZ());
        this.playAnimations();
        this.spawnRandomLightning(0.2, 100.0);
        this.tickStars();
    }

    private void tickStars() {
        int i;
        float radius = 50.0f;
        for (i = 0; i < 1000; ++i) {
            double x = MathsUtil.randDouble(-radius, radius);
            double y = MathsUtil.randDouble(-radius, radius);
            double z = MathsUtil.randDouble(-radius, radius);
            double distance = Vec3.f_82478_.m_82554_(new Vec3(x, y, z));
            if (Math.random() < Math.pow(distance, 2.0) / Math.pow(radius, 2.0) || distance > (double)radius) continue;
            StarVFX star = new StarVFX(this, this.pos().m_82520_(x, y, z), MathsUtil.randFloat(0.01f, 0.025f), MathsUtil.randInt(6, 16));
            this.stars.add(star);
        }
        try {
            for (i = 0; i < this.stars.size(); ++i) {
                StarVFX star = this.stars.get(i);
                star.tick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSitting() {
        if (this.getTarget() == null) {
            if (Math.random() < 0.0025 && this.sittingAnimation <= 0) {
                this.sittingAnimation = 300;
            }
        } else if (this.sittingAnimation > 0) {
            this.sittingAnimation = 0;
            this.stopSittingAnimation = 6;
        }
    }

    private boolean usingAbility() {
        return this.eraseTimer > 0 || this.beamTimer > 0 || this.totalityBoomTimer > 0 || this.throwInAirTimer > 0;
    }

    private void updateTimers() {
        if (this.swipeAnimationTimer > -1) {
            this.swipeAnimationTimer = !this.usingAbility() ? --this.swipeAnimationTimer : -1;
        }
        if (this.swipeTimer > 0) {
            --this.swipeTimer;
        }
        if (this.beamTimer > 0) {
            --this.beamTimer;
        }
        if (this.eraseTimer > 0) {
            --this.eraseTimer;
        }
        if (this.sittingAnimation > 0) {
            --this.sittingAnimation;
        }
        if (this.stopSittingAnimation > 0) {
            --this.stopSittingAnimation;
        }
        if (this.totalityBoomTimer > 0) {
            --this.totalityBoomTimer;
        }
        if (this.throwInAirTimer > 0) {
            --this.throwInAirTimer;
        }
    }

    private void updateSwipe() {
        if (this.swipeTimer == 0 && this.getTarget() != null && this.distanceTo(this.getTarget()) <= 60.0 && !this.usingAbility()) {
            this.swipeAnimation = MathsUtil.randInt(1, 5);
            this.swipeAnimationTimer = 5;
            this.swipeTimer = MathsUtil.randInt(5, 7);
            this.level().m_6263_(null, this.getTarget().m_20185_(), this.getTarget().m_20186_(), this.getTarget().m_20189_(), (SoundEvent)SoundInit.SWING.get(), SoundSource.NEUTRAL, 50.0f, MathsUtil.randFloat(0.85f, 1.15f));
        }
        if (this.swipeAnimationTimer == 4 && this.getTarget() != null && this.distanceTo(this.getTarget()) <= 60.0) {
            this.level().m_6263_(null, this.getTarget().m_20185_(), this.getTarget().m_20186_(), this.getTarget().m_20189_(), (SoundEvent)SoundInit.SLASH.get(), SoundSource.NEUTRAL, 50.0f, MathsUtil.randFloat(0.85f, 1.15f));
            this.level().m_6263_(null, this.getTarget().m_20185_(), this.getTarget().m_20186_(), this.getTarget().m_20189_(), (SoundEvent)SoundInit.POWERFUL_HIT.get(), SoundSource.NEUTRAL, 50.0f, MathsUtil.randFloat(0.85f, 1.15f));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.getTarget().m_20185_(), this.getTarget().m_20186_() + (double)(this.getTarget().m_20206_() / 2.0f), this.getTarget().m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                EntityUtil.metaExplosionVfx(15.0f, 10, this.getTarget().m_20182_(), true, this.level());
                EntityUtil.cameraShake(1.5f, this.getX(), this.getY(), this.getZ(), this.level());
            }
            for (Entity entity : EntityUtil.entityList(20.0f, this.level(), this.getTarget().m_20185_(), this.getTarget().m_20186_(), this.getTarget().m_20189_())) {
                if (entity == this.metapotentFlashfurProxy || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.isAlliedTo(entity) && this.getTarget() != livingEntity) continue;
                this.instantKill(livingEntity, 25.0f);
            }
        }
    }

    private void performThrowInAir() {
        if (this.throwInAirTimer <= 0 && !this.usingAbility() && this.getTarget() != null && Math.random() < 0.025) {
            this.throwInAirTimer = 40;
        }
    }

    private void updateThrowInAir() {
        LivingEntity livingEntity;
        if (this.throwInAirTimer == 35) {
            EntityUtil.cameraShake(2.0f, this.getX(), this.getY(), this.getZ(), this.level());
            this.entitiesToAttack.clear();
            for (Entity entity : EntityUtil.getAllEntities(this.level())) {
                Player player;
                if (entity == this.metapotentFlashfurProxy || !(entity instanceof LivingEntity)) continue;
                livingEntity = (LivingEntity)entity;
                if (this.isAlliedTo(entity) && this.getTarget() != livingEntity || entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_()) && player != this.getTarget()) continue;
                EntityUtil.forceSetDeltaMovement(entity, entity.m_20184_().m_82520_(0.0, 5.0, 0.0).m_82542_(0.0, 1.0, 0.0));
                this.entitiesToAttack.add((Entity)livingEntity);
            }
        }
        if (this.throwInAirTimer == 20) {
            for (Entity entity : this.entitiesToAttack) {
                if (!(entity instanceof LivingEntity)) continue;
                livingEntity = (LivingEntity)entity;
                for (Entity indirect : EntityUtil.entityList(100.0f, this.level(), this.getX(), this.getY(), this.getZ())) {
                    LivingEntity living;
                    if (indirect == this.metapotentFlashfurProxy || !(indirect instanceof LivingEntity) || this.isAlliedTo((Entity)(living = (LivingEntity)indirect)) && this.getTarget() != living) continue;
                    this.instantKill(living, 0.0f);
                }
                Vec3 colour = Math.random() < 0.5 ? new Vec3((double)purple[0], (double)purple[1], (double)purple[2]) : new Vec3((double)lightBlue[0], (double)lightBlue[1], (double)lightBlue[2]);
                EntityUtil.explosionVfx(MathsUtil.randFloat(10.0f, 100.0f), 10, livingEntity.m_20182_(), colour.m_82490_(255.0), this.level(), false);
                this.level().m_5594_(null, livingEntity.m_20183_(), (SoundEvent)SoundInit.ERASURE_BOOM.get(), SoundSource.NEUTRAL, 10000.0f, MathsUtil.randFloat(0.8f, 1.2f));
                this.level().m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 10000.0f, MathsUtil.randFloat(0.4f, 0.6f));
            }
            if (!this.entitiesToAttack.isEmpty()) {
                EntityUtil.cameraShake(5.0f, this.getX(), this.getY(), this.getZ(), this.level());
                this.level().m_5594_(null, this.blockPosition(), (SoundEvent)SoundInit.FLASHFUR_EXPLOSION.get(), SoundSource.NEUTRAL, 10000.0f, 0.5f);
                ScreenFlash.setScreenFlash(10);
            }
        }
    }

    private void performErase() {
        if (this.eraseTimer <= 0 && !this.usingAbility() && this.getTarget() != null && Math.random() < 0.05) {
            this.eraseTimer = 15;
        }
    }

    private void performTotalityBoom() {
        if (this.totalityBoomTimer <= 0 && !this.usingAbility() && this.getTarget() != null && Math.random() < 0.0025) {
            this.totalityBoomTimer = 37;
        }
    }

    private void updateTotalityBoom() {
        if (this.totalityBoomTimer > 0) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().f_82480_, 0.0);
        }
        if (this.totalityBoomTimer == 7) {
            for (Entity entity : EntityUtil.getAllEntities(this.level())) {
                if (entity == this.metapotentFlashfurProxy || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.isAlliedTo(entity) && this.getTarget() != livingEntity) continue;
                this.instantKill(livingEntity, 100.0f);
            }
            for (int i = 0; i < 3; ++i) {
                this.level().m_5594_(null, this.blockPosition(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0E7f, 0.2f);
                this.level().m_5594_(null, this.blockPosition(), (SoundEvent)SoundInit.FLASHFUR_EXPLOSION.get(), SoundSource.NEUTRAL, 1.0E7f, 0.5f);
            }
            EntityUtil.cameraShake(10.0f, this.getX(), this.getY(), this.getZ(), this.level());
            ScreenFlash.setScreenFlash(100);
            ScreenFlash.screenFlashTimerMax = 80;
        }
    }

    private void updateErase() {
        if (this.eraseTimer > 0) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().f_82480_, 0.0);
        }
        if (this.eraseTimer == 10) {
            if (this.getTarget() != null && this.level() instanceof ServerLevel) {
                EntityUtil.getAllEntities(this.level).forEach(entity -> {
                    Player player;
                    if (!(entity == this.metapotentFlashfurProxy || this.isAlliedTo((Entity)entity) && this.getTarget() != entity || entity instanceof Player)) {
                        this.eraseEntity((Entity)entity);
                    }
                    if (entity instanceof Player && (!(player = (Player)entity).m_7500_() && !player.m_5833_() || this.getTarget() == player)) {
                        EntityUtil.forceSetHealth((LivingEntity)player, Float.NEGATIVE_INFINITY);
                    }
                });
            }
            for (int i = 0; i < 3; ++i) {
                this.level().m_5594_(null, this.blockPosition(), (SoundEvent)SoundInit.ERASURE_BOOM.get(), SoundSource.NEUTRAL, 1.0E8f, 1.0f);
            }
            ScreenFlash.setScreenFlash(4);
            ScreenFlash.screenFlashTimerMax = 2;
        }
    }

    private void performBeam() {
        if (this.beamTimer <= 0 && !this.usingAbility() && this.getTarget() != null && Math.random() < 0.01 && this.distanceTo(this.getTarget()) <= 1000.0) {
            this.beamTimer = 110;
        }
    }

    private void updateBeam() {
        if (this.beamTimer <= 110 && this.beamTimer > 90) {
            this.setDeltaMovement(0.0, 4.0, 0.0);
        }
        if (this.beamTimer == 90) {
            this.metaBeam = new MetaBeam((EntityType)EntityInit.META_BEAM.get(), this.level());
            this.metaBeam.m_6027_(this.getX(), this.getY() + 5.0, this.getZ());
            if (this.getTarget() != null) {
                this.metaBeam.m_20088_().m_135381_(MetaBeam.DATA_END_POS, (Object)new Vector3f((float)this.getTarget().m_20185_(), (float)this.getTarget().m_20186_(), (float)this.getTarget().m_20189_()));
            }
            EntityUtil.forceAddEntity(this.metaBeam, this.level());
        }
        if (this.beamTimer <= 90 && this.beamTimer > 10) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.metaBeam.m_20088_().m_135381_(MetaBeam.DATA_END_POS_OLD, (Object)((Vector3f)this.metaBeam.m_20088_().m_135370_(MetaBeam.DATA_END_POS)));
            if (this.metaBeam != null && this.getTarget() != null) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getTarget().m_20182_());
                this.metaBeam.m_20088_().m_135381_(MetaBeam.DATA_END_POS, (Object)new Vector3f((float)this.getTarget().m_20185_(), (float)this.getTarget().m_20186_(), (float)this.getTarget().m_20189_()));
                for (Vec3 pos : MathsUtil.findPositionsInLine(this.metaBeam.m_20185_(), this.metaBeam.m_20186_(), this.metaBeam.m_20189_(), ((Vector3f)this.metaBeam.m_20088_().m_135370_(MetaBeam.DATA_END_POS)).x, ((Vector3f)this.metaBeam.m_20088_().m_135370_(MetaBeam.DATA_END_POS)).y, ((Vector3f)this.metaBeam.m_20088_().m_135370_(MetaBeam.DATA_END_POS)).z, 1.0)) {
                    for (Entity entity : EntityUtil.entityList(10.0f, this.level(), pos.f_82479_, pos.f_82480_, pos.f_82481_)) {
                        if (entity == this.metapotentFlashfurProxy || !(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (this.isAlliedTo(entity) && this.getTarget() != livingEntity) continue;
                        this.instantKill(livingEntity, 0.0f);
                        if (entity.m_6084_()) continue;
                        this.eraseEntity(entity);
                    }
                }
            }
            this.setNoGravity(true);
        } else if (this.beamTimer > 0) {
            this.setNoGravity(false);
        }
    }

    private void teleportToTarget() {
        if (this.getTarget() != null && this.distanceTo(this.getTarget()) > 60.0 && Math.random() < 0.5 && !this.usingAbility() && (this.distanceTo(this.getTarget()) < (double)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 16) || this.distanceTo(this.getTarget()) < 9.99E8 && this.distanceTo(this.getTarget()) > 5000.0)) {
            this.level().m_6263_(null, this.getX(), this.getY(), this.getZ(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 100.0f, MathsUtil.randFloat(0.85f, 1.15f));
            this.setPos(this.getTarget().m_20185_() - this.getLookAngle().f_82479_ / 5.0, this.getTarget().m_20186_(), this.getTarget().m_20189_() - this.getLookAngle().f_82481_ * 5.0);
        }
    }

    private void spawnRandomLightning(double probability, double radius) {
        int i = 0;
        while ((double)i < probability) {
            if (Math.random() < probability) {
                MetaLightning metaLightning = new MetaLightning((EntityType<? extends LightningBolt>)((EntityType)EntityInit.META_LIGHTNING_BOLT.get()), this.level());
                double x = this.getX() + MathsUtil.randDouble(-radius, radius);
                double z = this.getZ() + MathsUtil.randDouble(-radius, radius);
                metaLightning.m_6027_(x, this.level().m_6924_(Heightmap.Types.WORLD_SURFACE, (int)x, (int)z), z);
                metaLightning.owner = this.metapotentFlashfurProxy;
                EntityUtil.forceAddEntity((Entity)metaLightning, this.level());
            }
            ++i;
        }
    }

    protected void playAnimations() {
        this.idleAnimationState.m_246184_(true, this.tickCount);
        this.swipe1AnimationState.m_246184_(this.swipeAnimation == 1 && this.swipeAnimationTimer >= 0, this.tickCount);
        this.swipe2AnimationState.m_246184_(this.swipeAnimation == 2 && this.swipeAnimationTimer >= 0, this.tickCount);
        this.swipe3AnimationState.m_246184_(this.swipeAnimation == 3 && this.swipeAnimationTimer >= 0, this.tickCount);
        this.swipe4AnimationState.m_246184_(this.swipeAnimation == 4 && this.swipeAnimationTimer >= 0, this.tickCount);
        this.swipe5AnimationState.m_246184_(this.swipeAnimation == 5 && this.swipeAnimationTimer >= 0, this.tickCount);
        this.sitAnimationState.m_246184_(this.sittingAnimation > 0, this.tickCount);
        this.stopSittingAnimationState.m_246184_(this.stopSittingAnimation > 0, this.tickCount);
        this.eraseAnimationState.m_246184_(this.eraseTimer > 0, this.tickCount);
        this.beamAnimationState.m_246184_(this.beamTimer > 0, this.tickCount);
        this.totalityBoomAnimationState.m_246184_(this.totalityBoomTimer > 0, this.tickCount);
        this.throwInAirAnimationState.m_246184_(this.throwInAirTimer > 0, this.tickCount);
    }

    public void eraseEntity(Entity entity) {
        if (entity instanceof Player) {
            return;
        }
        EntityUtil.forceRemove(entity, Entity.RemovalReason.KILLED);
        EntityUtil.forceSetPos(entity, new Vec3(1.0E9, 0.0, 0.0));
        PacketHandler.sendToClient(new S2CSyncSetPos(entity.m_19879_(), 1.0E9, 0.0, 0.0));
    }

    public void instantKill(LivingEntity entity, float knockback) {
        ModCompatUtil.destroyDragionnsStuffMobs((Entity)entity);
        EntityUtil.forceHurt((LivingEntity)this.metapotentFlashfurProxy, entity, new ForceDamageSource(Float.POSITIVE_INFINITY, 100.0f, true, 100.0f, knockback, true));
        if (entity instanceof BossEntity) {
            BossEntity bossEntity = (BossEntity)entity;
            AccessChecker.performPrivilegedAction(() -> HealthManager.setHealth(bossEntity, Float.NEGATIVE_INFINITY));
        }
        if (entity.m_6084_() && !(entity instanceof Player)) {
            this.eraseEntity((Entity)entity);
        }
    }

    public void lookAt(EntityAnchorArgument.Anchor anchorArgument, Vec3 pos) {
        Vec3 vec3 = this.pos();
        double d0 = pos.f_82479_ - vec3.f_82479_;
        double d1 = pos.f_82480_ - vec3.f_82480_ - (anchorArgument == EntityAnchorArgument.Anchor.EYES ? 8.0 : 0.0);
        double d2 = pos.f_82481_ - vec3.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.rotX = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        this.rotY = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
        if (this.sittingAnimation > 0) {
            this.deltaMovement = new Vec3(0.0, deltaMovement.f_82480_, 0.0);
            return;
        }
        this.deltaMovement = deltaMovement;
    }

    public void setDeltaMovement(double x, double y, double z) {
        this.setDeltaMovement(new Vec3(x, y, z));
    }

    public Vec3 getDeltaMovement() {
        return this.deltaMovement;
    }

    public BlockPos blockPosition() {
        return new BlockPos((int)this.pos().f_82479_, (int)this.pos().f_82480_, (int)this.pos().f_82481_);
    }

    public boolean isAlliedTo(Entity entity) {
        if (this.getTeam() == null) {
            return false;
        }
        return this.getTeam().m_83536_(entity.m_5647_());
    }

    public Team getTeam() {
        return this.team;
    }

    public boolean onGround() {
        return !this.level().m_46859_(new BlockPos((int)Math.round(this.getPos().f_82479_), (int)Math.round(this.getPos().f_82480_ - 0.01), (int)Math.round(this.getPos().f_82481_)));
    }

    public float getRotY() {
        return this.rotY;
    }

    public float getRotX() {
        return this.rotX;
    }

    public float getRotY(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.rotYO, (float)this.rotY);
    }

    public float getRotX(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.rotXO, (float)this.rotX);
    }

    public Vec3 getLookAngle() {
        float f = this.getRotX() * ((float)Math.PI / 180);
        float f1 = -this.getRotY() * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public void calculateEntityAnimation(boolean p_268129_) {
        float f = (float)Mth.m_184648_((double)(this.pos.f_82479_ - this.posO.f_82479_), (double)(p_268129_ ? this.pos.f_82480_ - this.posO.f_82480_ : 0.0), (double)(this.pos.f_82481_ - this.posO.f_82481_));
        this.updateWalkAnimation(f);
    }

    protected void updateWalkAnimation(float p_268283_) {
        float f = Math.min(p_268283_ * 4.0f, 1.0f);
        this.walkAnimation.m_267566_(f, 0.4f);
    }

    public void targeting() {
        if (this.getTarget() != null && !this.getTarget().m_9236_().m_46749_(this.getTarget().m_20183_())) {
            this.setTarget(null);
        }
        double distance = Double.POSITIVE_INFINITY;
        if (this.getTarget() == null || this.getTarget().m_21224_()) {
            for (Entity entity : EntityUtil.getAllEntities(this.level())) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !this.targetConditions(livingEntity = (LivingEntity)entity) || !(this.distanceTo(livingEntity) < distance)) continue;
                this.setTarget(livingEntity);
                distance = this.distanceTo(livingEntity);
            }
        }
    }

    public boolean targetConditions(LivingEntity entity) {
        Player player;
        if (entity == this.metapotentFlashfurProxy) {
            return false;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (!EntityUtil.getAllEntities(this.level()).contains(entity)) {
            return false;
        }
        if (this.getTeam() != null) {
            return !this.isAlliedTo((Entity)entity);
        }
        return true;
    }

    private void move() {
        this.posO = this.pos;
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.deltaMovement.m_82549_(new Vec3(0.0, -0.1, 0.0)));
        }
        Vec3 deltaMovementXZ = new Vec3(this.getDeltaMovement().f_82479_, 0.0, this.getDeltaMovement().f_82481_);
        Vec3 deltaMovementY = new Vec3(0.0, this.getDeltaMovement().f_82480_, 0.0);
        Vec3 newPosXZ = this.pos.m_82549_(deltaMovementXZ);
        AABB newBoundingBoxXZ = this.boundingBox.m_82383_(newPosXZ.m_82546_(this.pos));
        boolean canMoveXZ = true;
        for (BlockPos pos : BlockPos.m_121921_((AABB)newBoundingBoxXZ).map(BlockPos::m_7949_).toList()) {
            VoxelShape voxelShape = this.level().m_8055_(pos).m_60742_((BlockGetter)this.level(), pos, CollisionContext.m_82749_());
            if (voxelShape.m_83281_() || !voxelShape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_83215_().m_82381_(newBoundingBoxXZ)) continue;
            canMoveXZ = false;
            break;
        }
        Vec3 newPosY = this.pos.m_82549_(deltaMovementY);
        AABB newBoundingBoxY = this.boundingBox.m_82383_(newPosY.m_82546_(this.pos));
        boolean canMoveY = true;
        for (BlockPos pos : BlockPos.m_121921_((AABB)newBoundingBoxY).map(BlockPos::m_7949_).toList()) {
            VoxelShape voxelShape = this.level().m_8055_(pos).m_60742_((BlockGetter)this.level(), pos, CollisionContext.m_82749_());
            if (voxelShape.m_83281_() || !voxelShape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_83215_().m_82381_(newBoundingBoxY)) continue;
            canMoveY = false;
            break;
        }
        if (canMoveXZ) {
            this.pos = newPosXZ;
        }
        if (canMoveY) {
            this.pos = this.pos.m_82549_(deltaMovementY);
        }
        this.setDeltaMovement(this.getDeltaMovement().m_82490_(0.95 - (double)(this.level().m_8055_(new BlockPos((int)Math.round(this.getPos().f_82479_), (int)Math.round(this.getPos().f_82480_ - 1.0), (int)Math.round(this.getPos().f_82481_))).m_60795_() ? 0.0f : this.level().m_8055_(new BlockPos((int)Math.round(this.getPos().f_82479_), (int)Math.round(this.getPos().f_82480_ - 1.0), (int)Math.round(this.getPos().f_82481_))).m_60734_().m_49958_())));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().m_82542_(1.0, 0.0, 1.0));
        }
    }

    public boolean exists() {
        return MetapotentFlashfurLevel.metapotentFlashfurList.contains(this);
    }

    public void playLivingSound() {
        this.level.m_5594_(null, this.blockPosition(), SoundEvents.f_11785_, SoundSource.NEUTRAL, 1.0E9f, MathsUtil.randFloat(0.9f, 1.1f));
    }

    public MetapotentFlashfurEntity getMetapotentFlashfurProxy() {
        return this.metapotentFlashfurProxy;
    }

    @Override
    public SoundEvent getMusic() {
        return (SoundEvent)SoundInit.METAPOTENT_FLASHFUR_THEME.get();
    }

    @Override
    public boolean canPlayMusic() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        return MetapotentFlashfurLevel.metapotentFlashfurList.contains(this) && this.distanceTo((LivingEntity)Minecraft.m_91087_().f_91074_) < (double)Minecraft.m_91087_().f_91063_.m_172790_();
    }
}

