/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.metapotent_flashfur;

import com.mojang.blaze3d.vertex.PoseStack;
import flashfur.omnimobs.CommonConfig;
import flashfur.omnimobs.OmniMobs;
import flashfur.omnimobs.coremod.CoreModMain;
import flashfur.omnimobs.entities.anticheat.AccessChecker;
import flashfur.omnimobs.entities.anticheat.ProtectedArrayList;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfur;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurEntity;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurEventBus;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurRenderer;
import flashfur.omnimobs.entities.metapotent_flashfur.powers.MetaBeamRender;
import flashfur.omnimobs.init.EntityInit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.BusBuilderImpl;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="omnimobs")
public class MetapotentFlashfurLevel {
    private static final String FILE_EXTENSION = "omnimob";
    public static final ProtectedArrayList<MetapotentFlashfur> metapotentFlashfurList = new ProtectedArrayList();
    public static float lastTime = 0.0f;
    public static boolean isLoaded = false;

    @SubscribeEvent
    public void renderMetapotentFlashfurs(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES && !CoreModMain.SUCCESSFUL_OPERATIONS.containsKey("metapotent_flashfur")) {
            MetapotentFlashfurLevel.renderMetapotentFlashfursNoEvent(event.getPoseStack(), event.getCamera());
        }
    }

    public static void renderAfterEntities(PoseStack poseStack, Camera camera) {
        MetapotentFlashfurLevel.renderMetapotentFlashfursNoEvent(poseStack, camera);
        MetaBeamRender.render(poseStack, camera, Minecraft.m_91087_().getPartialTick());
    }

    public static void tickServer() {
        MetapotentFlashfurLevel.tickMetapotentFlashfursNoEvent();
    }

    public static void renderMetapotentFlashfursNoEvent(PoseStack poseStack, Camera camera) {
        float partialTick = MetapotentFlashfurLevel.getPartialTick();
        partialTick /= 50.0f;
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        for (int i = 0; i < metapotentFlashfurList.size(); ++i) {
            if (metapotentFlashfurList.get(i) == null) continue;
            poseStack.m_85836_();
            MetapotentFlashfur customEntity = (MetapotentFlashfur)metapotentFlashfurList.get(i);
            MetapotentFlashfurRenderer metapotentFlashfurRenderer = new MetapotentFlashfurRenderer(new EntityRendererProvider.Context(Minecraft.m_91087_().m_91290_(), Minecraft.m_91087_().m_91291_(), Minecraft.m_91087_().m_91289_(), Minecraft.m_91087_().m_91290_().m_234586_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().f_91062_));
            MetapotentFlashfurEntity metapotentFlashfurEntity = new MetapotentFlashfurEntity((EntityType<? extends PathfinderMob>)((EntityType)EntityInit.METAPOTENT_FLASHFUR_ENTITY.get()), (Level)Minecraft.m_91087_().f_91073_);
            poseStack.m_85837_(customEntity.getPos().f_82479_ - camera.m_90583_().f_82479_, customEntity.getPos().f_82480_ - camera.m_90583_().f_82480_, customEntity.getPos().f_82481_ - camera.m_90583_().f_82481_);
            metapotentFlashfurEntity.metapotentFlashfur = customEntity;
            metapotentFlashfurEntity.m_7678_(customEntity.getPos().f_82479_, customEntity.getPos().f_82480_, customEntity.getPos().f_82481_, customEntity.getRotY(partialTick), customEntity.getRotX(partialTick));
            metapotentFlashfurEntity.f_19797_ = customEntity.tickCount;
            metapotentFlashfurEntity.isEntity = false;
            metapotentFlashfurEntity.f_267362_ = customEntity.walkAnimation;
            metapotentFlashfurRenderer.render(metapotentFlashfurEntity, 0.0f, partialTick, poseStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0);
            poseStack.m_85849_();
        }
        Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
    }

    public static float getPartialTick() {
        if (Minecraft.m_91087_().m_91104_()) {
            return Minecraft.m_91087_().getPartialTick();
        }
        return ((float)Util.m_137550_() - lastTime) / 50.0f;
    }

    @SubscribeEvent
    public void tickMetapotentFlashfurs(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !Minecraft.m_91087_().m_91104_() && !CoreModMain.SUCCESSFUL_OPERATIONS.containsKey("metapotent_flashfur")) {
            MetapotentFlashfurLevel.tickMetapotentFlashfursNoEvent();
        }
    }

    public static void tickMetapotentFlashfursNoEvent() {
        try {
            if (!isLoaded && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().m_91092_() != null && Minecraft.m_91087_().m_91092_().m_129921_() >= 1) {
                isLoaded = true;
                MetapotentFlashfurLevel.loadMetapotentFlashfurs((MinecraftServer)Minecraft.m_91087_().m_91092_());
            }
        }
        catch (Exception e) {
            OmniMobs.logErr("Error loading Metapotent Flashfurs.");
            e.printStackTrace();
        }
        try {
            for (MetapotentFlashfur metapotentFlashfur : metapotentFlashfurList) {
                if (metapotentFlashfur == null) continue;
                try {
                    metapotentFlashfur.tick();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            lastTime = Util.m_137550_();
            MetapotentFlashfurLevel.updateEventBus();
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    public static void add(MetapotentFlashfur metapotentFlashfur) {
        if (!AccessChecker.checkAccess()) {
            return;
        }
        if (metapotentFlashfurList.isEmpty()) {
            if (CommonConfig.coremod) {
                if (!CoreModMain.SUCCESSFUL_OPERATIONS.containsKey("agentmain") && Minecraft.m_91087_().f_91074_ != null) {
                    OmniMobs.logErrGame("Agent wasn't attached to the game.");
                }
            } else {
                OmniMobs.logGame("Coremod was disabled in the config.");
            }
            if (!CoreModMain.SUCCESSFUL_OPERATIONS.containsKey("metapotent_flashfur")) {
                OmniMobs.logGame("Metapotent Flashfur is using events as a fallback. He isn't at his full power!");
            }
        }
        metapotentFlashfurList.add(metapotentFlashfur);
        metapotentFlashfur.bossEvent.m_8321_(true);
        for (Player player : metapotentFlashfur.level().m_6907_()) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            metapotentFlashfur.bossEvent.m_6543_(serverPlayer);
        }
    }

    public static void remove(MetapotentFlashfur metapotentFlashfur) {
        if (!AccessChecker.checkAccess()) {
            return;
        }
        if (metapotentFlashfur != null && metapotentFlashfur.bossEvent != null) {
            metapotentFlashfur.bossEvent.m_8321_(false);
            for (Player player : metapotentFlashfur.level().m_6907_()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                metapotentFlashfur.bossEvent.m_6539_(serverPlayer);
            }
        }
        metapotentFlashfurList.remove(metapotentFlashfur);
    }

    public static void clear() {
        if (!AccessChecker.checkAccess()) {
            return;
        }
        for (MetapotentFlashfur metapotentFlashfur : metapotentFlashfurList) {
            metapotentFlashfur.bossEvent.m_8321_(false);
            for (Player player : metapotentFlashfur.level().m_6907_()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                metapotentFlashfur.bossEvent.m_6539_(serverPlayer);
            }
        }
        metapotentFlashfurList.clear();
    }

    @SubscribeEvent
    public void unloadLevel(LevelEvent.Unload event) {
        try {
            if (event.getLevel().m_7654_() != null && event.getLevel() == event.getLevel().m_7654_().m_129783_()) {
                MetapotentFlashfurLevel.saveMetapotentFlashfurs(event);
                AccessChecker.performPrivilegedAction(MetapotentFlashfurLevel::clear);
                MetapotentFlashfurLevel.updateEventBus();
                isLoaded = false;
            }
        }
        catch (Exception e) {
            OmniMobs.logErr("Failed to save Metapotent Flashfurs.");
            e.printStackTrace();
        }
    }

    public static void updateEventBus() {
        if (!metapotentFlashfurList.isEmpty()) {
            if (MinecraftForge.EVENT_BUS.getClass() != MetapotentFlashfurEventBus.class) {
                MinecraftForge.EVENT_BUS = new MetapotentFlashfurEventBus(new BusBuilderImpl(), MinecraftForge.EVENT_BUS);
            }
        } else {
            IEventBus iEventBus = MinecraftForge.EVENT_BUS;
            if (iEventBus instanceof MetapotentFlashfurEventBus) {
                MetapotentFlashfurEventBus metapotentFlashfurEventBus = (MetapotentFlashfurEventBus)iEventBus;
                metapotentFlashfurEventBus.restoreEventBus(new EventBus(new BusBuilderImpl()));
            }
        }
    }

    public static void saveMetapotentFlashfurs(LevelEvent.Unload event) {
        if (event.getLevel().m_7654_() == null || event.getLevel() != event.getLevel().m_7654_().m_129783_()) {
            return;
        }
        OmniMobs.log("Saving Metapotent Flashfurs.");
        if (!metapotentFlashfurList.isEmpty()) {
            for (MetapotentFlashfur metapotentFlashfur : metapotentFlashfurList) {
                StringBuilder metapotentFlashfurFile = new StringBuilder();
                for (Field field : MetapotentFlashfur.class.getDeclaredFields()) {
                    if (field.getModifiers() == 16) continue;
                    field.setAccessible(true);
                    if (field.getType().isPrimitive()) {
                        try {
                            metapotentFlashfurFile.append(field.getName()).append("=").append(field.get(metapotentFlashfur).toString()).append(";");
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (field.getType() != Vec3.class) continue;
                    try {
                        Vec3 pos = (Vec3)field.get(metapotentFlashfur);
                        metapotentFlashfurFile.append(field.getName()).append("=").append(pos.f_82479_).append(",").append(pos.f_82480_).append(",").append(pos.f_82481_).append(";");
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    MetapotentFlashfurLevel.writeFile(event.getLevel().m_7654_(), metapotentFlashfurFile.toString(), "metapotent_flashfur_" + metapotentFlashfurList.indexOf(metapotentFlashfur) + ".omnimob");
                }
                catch (IOException iOException) {}
            }
        }
        OmniMobs.log("Metapotent Flashfurs saved.");
    }

    public static void loadMetapotentFlashfurs(MinecraftServer server) {
        if (server == null) {
            return;
        }
        OmniMobs.log("Loading Metapotent Flashfurs...");
        try {
            Path worldPath = server.m_129843_(LevelResource.f_78182_);
            Path directory = worldPath.resolve("metapotent_flashfurs");
            if (!Files.exists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            for (File f : Objects.requireNonNull(directory.toFile().listFiles())) {
                if (!f.getName().endsWith(".omnimob")) continue;
                try {
                    if (Minecraft.m_91087_().m_91092_() == null) continue;
                    MetapotentFlashfurLevel.makeNewFlashfur(server, f.getName());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (Minecraft.m_91087_().m_91092_() != null) {
                MetapotentFlashfurLevel.clearDirectory((MinecraftServer)Minecraft.m_91087_().m_91092_(), FILE_EXTENSION);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void makeNewFlashfur(MinecraftServer server, String file) throws IOException {
        MetapotentFlashfur metapotentFlashfur = new MetapotentFlashfur(Vec3.f_82478_, 0.0f, 0.0f, (Level)Minecraft.m_91087_().m_91092_().m_129783_());
        for (String s : MetapotentFlashfurLevel.readFile(server, file).split(";")) {
            try {
                String[] split = s.split("=");
                Field declaredField = MetapotentFlashfur.class.getDeclaredField(split[0]);
                declaredField.setAccessible(true);
                if (Modifier.isStatic(declaredField.getModifiers()) || Modifier.isFinal(declaredField.getModifiers()) || declaredField.getName().equals("level")) continue;
                if (declaredField.getType() == Double.TYPE) {
                    declaredField.set(metapotentFlashfur, Double.parseDouble(split[1]));
                    continue;
                }
                if (declaredField.getType() == Integer.TYPE) {
                    declaredField.set(metapotentFlashfur, Integer.parseInt(split[1]));
                    continue;
                }
                if (declaredField.getType() == Boolean.TYPE) {
                    declaredField.set(metapotentFlashfur, Boolean.parseBoolean(split[1]));
                    continue;
                }
                if (declaredField.getType() == Float.TYPE) {
                    declaredField.set(metapotentFlashfur, Float.valueOf(Float.parseFloat(split[1])));
                    continue;
                }
                if (declaredField.getType() != Vec3.class) continue;
                String[] values = split[1].split(",");
                Vec3 vec3 = new Vec3(Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2]));
                declaredField.set(metapotentFlashfur, vec3);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        AccessChecker.performPrivilegedAction(() -> MetapotentFlashfurLevel.add(metapotentFlashfur));
    }

    public static String readFile(MinecraftServer server, String name) throws IOException {
        Path worldPath = server.m_129843_(LevelResource.f_78182_);
        Path directory = worldPath.resolve("metapotent_flashfurs");
        Path file = directory.resolve(name);
        Files.createDirectories(directory, new FileAttribute[0]);
        return Files.readString(file);
    }

    public static void writeFile(MinecraftServer server, String content, String name) throws IOException {
        Path worldPath = server.m_129843_(LevelResource.f_78182_);
        Path directory = worldPath.resolve("metapotent_flashfurs");
        Path file = directory.resolve(name);
        Files.createDirectories(directory, new FileAttribute[0]);
        Files.writeString(file, (CharSequence)content, new OpenOption[0]);
    }

    public static void clearDirectory(MinecraftServer server, String fileExtension) {
        Path worldPath = server.m_129843_(LevelResource.f_78182_);
        Path directory = worldPath.resolve("metapotent_flashfurs");
        if (Files.isDirectory(directory, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
                stream.sorted((path1, path2) -> -path1.compareTo((Path)path2)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith("." + fileExtension)).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to delete: " + String.valueOf(path) + ". Reason: " + e.getMessage());
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

