/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.silverlight.powers.flip;

import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.silverlight.powers.misc.AbstractSilverlightLightningMove;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public abstract class SilverlightJumpLightningMove
extends AbstractSilverlightLightningMove {
    private final float jumpStrength;
    private final float jumpHeight;

    public SilverlightJumpLightningMove(BossEntity entity, AnimationState[] state, int range, int cooldown, float jumpStrength, float jumpHeight, int endCooldown) {
        super(entity, state, range, Integer.MAX_VALUE, cooldown, endCooldown);
        this.jumpStrength = jumpStrength;
        this.jumpHeight = jumpHeight;
    }

    @Override
    public void start() {
        super.start();
        if (this.getEntity().m_5448_() == null) {
            return;
        }
        this.getEntity().m_7618_(EntityAnchorArgument.Anchor.EYES, this.getEntity().m_5448_().m_20182_());
        this.getEntity().m_20088_().m_135381_(BossEntity.DATA_ROTATION_LOCK, (Object)new Rotations(this.getEntity().m_146909_(), this.getEntity().m_6080_(), 0.0f));
        this.flip(this.jumpStrength, this.jumpHeight);
    }

    protected void flip(float jumpStrength, float jumpHeight) {
        float yaw = this.getEntity().m_146908_() + 180.0f;
        this.getEntity().m_20256_(new Vec3((double)jumpStrength * Math.cos((double)(yaw + 90.0f) * (Math.PI / 180)), this.getEntity().m_20184_().m_7098_() + (double)jumpHeight, (double)jumpStrength * Math.sin((double)(yaw + 90.0f) * (Math.PI / 180))));
    }

    @Override
    public void handleEvent(String event) {
        super.handleEvent(event);
        if (!this.isActive()) {
            return;
        }
        if (event.equals("causeFallDamage")) {
            this.shockwave();
            this.setTicks(0);
            this.end();
        }
    }

    public abstract void shockwave();

    protected boolean isClose() {
        if (this.getEntity().m_5448_() == null) {
            return false;
        }
        return this.getEntity().m_20270_((Entity)this.getEntity().m_5448_()) < 15.0f;
    }

    @Override
    protected int chooseAnimation() {
        if (!this.isClose()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void moveSpecificTick() {
        super.moveSpecificTick();
        this.getEntity().correctRotation();
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.getEntity().m_20096_();
    }
}

