/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.screen;

import flashfur.omnimobs.items.EntityRemover;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncEntityRemoverSetting;
import flashfur.omnimobs.screen.EntityRemoverCheckbox;
import flashfur.omnimobs.screen.EntityRemoverSetting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EntityRemoverConfigScreen
extends Screen {
    private final Player player;
    private final ItemStack itemStack;
    private final List<EntityRemoverSetting> settings;
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int topPos;

    public EntityRemoverConfigScreen(Player player, ItemStack itemStack) {
        super((Component)Component.m_237115_((String)"item.omnimobs.entity_remover").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.BOLD));
        this.player = player;
        this.itemStack = itemStack;
        this.imageWidth = 256;
        this.imageHeight = 200;
        this.settings = new ArrayList<EntityRemoverSetting>(EntityRemover.SETTINGS);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        CompoundTag compoundTag = this.itemStack.m_41784_();
        int counter = 0;
        for (EntityRemoverSetting setting : this.settings) {
            setting.setCheckbox((EntityRemoverCheckbox)this.m_142416_((GuiEventListener)new EntityRemoverCheckbox(this.leftPos + 10, this.topPos + 15 + 30 * counter, 20, 20, (Component)setting.getDisplay(), (Component)setting.getDescription(), compoundTag.m_128471_(setting.getNbt()))));
            ++counter;
        }
    }

    public void m_7379_() {
        super.m_7379_();
        for (EntityRemoverSetting setting : this.settings) {
            PacketHandler.sendToServer(new S2CSyncEntityRemoverSetting(setting.getNbt(), setting.getCheckbox().isChecked(), this.player.m_19879_()));
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280163_(new ResourceLocation("omnimobs", "textures/gui/entity_remover_background.png"), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

