/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;

public class MathsUtil {
    public static double randDouble(double lower, double upper) {
        return Math.random() * (upper - lower) + lower;
    }

    public static float randFloat(float lower, float upper) {
        return (float)Math.random() * (upper - lower) + lower;
    }

    public static int randInt(int lower, int upper) {
        return (int)Math.round(Math.random() * (double)(upper - lower) + (double)lower);
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
    }

    public static List<Vec3> findPositionsInLine(double x1, double y1, double z1, double x2, double y2, double z2, double betweenDistance) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        int steps = (int)Math.ceil(MathsUtil.distance(x1, y1, z1, x2, y2, z2) / betweenDistance);
        for (int i = 0; i <= steps && steps <= 10000; ++i) {
            double t = (double)i / (double)steps;
            double x = x1 + (x2 - x1) * t;
            double y = y1 + (y2 - y1) * t;
            double z = z1 + (z2 - z1) * t;
            positions.add(new Vec3(x, y, z));
        }
        return positions;
    }

    public static boolean isNumberInPercentLow(double number, double originalNumber, double maxNumber, double percentage) {
        double low = originalNumber - maxNumber * (percentage /= 100.0);
        return number >= low;
    }

    public static boolean approxEquals(double a, double b) {
        return Math.abs(a - b) < 0.01;
    }
}

