/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs;

import flashfur.omnimobs.OmniMobs;
import flashfur.omnimobs.entities.anticheat.AccessChecker;
import flashfur.omnimobs.entities.anticheat.HealthManager;
import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.init.EntityInit;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.ForceDamageSource;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class Tests {
    private final Level level;
    private final Player player;
    private BossEntity bossEntity;
    private LivingEntity targetEntity;

    public Tests(LevelAccessor level, Player player) {
        this.level = (Level)level;
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests() throws IllegalAccessException {
        HashMap<String, MethodHandle> methods = new HashMap<String, MethodHandle>();
        ArrayList<Method> beforeMethods = new ArrayList<Method>();
        ArrayList afterMethods = new ArrayList();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Method method : Tests.class.getDeclaredMethods()) {
            if (method.isAnnotationPresent(OmniMobsTest.class)) {
                methods.put(method.getName(), lookup.unreflect(method));
                continue;
            }
            if (method.isAnnotationPresent(OmniMobsBeforeTest.class)) {
                beforeMethods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(OmniMobsAfterTest.class)) continue;
            afterMethods.add(method);
        }
        boolean b = false;
        for (Map.Entry entry : methods.entrySet()) {
            try {
                for (Method method : beforeMethods) {
                    method.invoke((Object)this, new Object[0]);
                }
                try {
                    ((MethodHandle)entry.getValue()).invoke(this);
                    OmniMobs.logGame((String)entry.getKey() + ": Test passed", this.player, ChatFormatting.GREEN);
                }
                catch (AssertionError e) {
                    OmniMobs.logErrGame((String)entry.getKey() + ": Test failed: " + ((Throwable)((Object)e)).getMessage(), this.player);
                    b = true;
                }
                finally {
                    for (Method method : afterMethods) {
                        method.invoke((Object)this, new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                OmniMobs.logErrGame((String)entry.getKey() + ": Test failed: " + e.getMessage(), this.player);
                b = true;
            }
        }
        if (b) {
            OmniMobs.logErrGame("One or more tests failed", this.player);
        }
    }

    private void assertEquals(double a, double b, double delta) {
        if (Math.abs(a - b) > delta) {
            throw new AssertionError((Object)("Expected " + a + ", got " + b));
        }
    }

    private void assertEquals(Object a, Object b) {
        if (a == null && b == null) {
            return;
        }
        if (a != null && b != null && a.equals(b)) {
            return;
        }
        throw new AssertionError((Object)("Expected " + String.valueOf(a) + ", got " + String.valueOf(b)));
    }

    private BossEntity createBossEntity() {
        return new BossEntity((EntityType)EntityInit.FLASHFUR.get(), this.level){

            public double m_21133_(@NotNull Attribute attribute) {
                if (attribute == Attributes.f_22276_) {
                    return 2000.0;
                }
                return super.m_21133_(attribute);
            }

            @Override
            public float getDamageCap() {
                return 20.0f;
            }

            @Override
            protected float getResistance() {
                return 2.0f;
            }
        };
    }

    private LivingEntity createTargetEntity() {
        return new PathfinderMob(EntityType.f_20510_, this.level){

            public double m_21133_(@NotNull Attribute attribute) {
                if (attribute == Attributes.f_22276_) {
                    return 1000.0;
                }
                return super.m_21133_(attribute);
            }
        };
    }

    @OmniMobsBeforeTest
    public void setupEntities() {
        this.bossEntity = this.createBossEntity();
        this.targetEntity = this.createTargetEntity();
    }

    @OmniMobsAfterTest
    public void clearEntities() {
        this.bossEntity = null;
        this.targetEntity = null;
    }

    @OmniMobsTest
    public void testBossEntityPercentCalculation() {
        float damage = this.bossEntity.calculatePercentDamage(this.targetEntity, 10.0f, 20.0f);
        this.assertEquals(210.0, damage, 1.0E-4f);
        damage = this.bossEntity.calculatePercentDamage(this.targetEntity, 5.0f, 20.0f);
        this.assertEquals(205.0, damage, 1.0E-4f);
        damage = this.bossEntity.calculatePercentDamage(this.targetEntity, 10.0f, 10.0f);
        this.assertEquals(110.0, damage, 1.0E-4f);
        damage = this.bossEntity.calculatePercentDamage(this.targetEntity, 12.0f, 1.0f);
        this.assertEquals(22.0, damage, 1.0E-4f);
        damage = this.bossEntity.calculatePercentDamage(this.targetEntity, 0.0f, 200.0f);
        this.assertEquals(2000.0, damage, 1.0E-4f);
    }

    @OmniMobsTest
    public void testForceHurt() {
        float health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(10.0f));
        this.assertEquals(health - 10.0f, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(20.0f));
        this.assertEquals(health - 20.0f, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(30.0f));
        this.assertEquals(health - 30.0f, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(40.0f));
        this.assertEquals(health - 40.0f, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(-50.0f));
        this.assertEquals(health, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(50.0f, 10.0f, true, 0.0f, 0.0f, false));
        this.assertEquals(health - 50.0f, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(50.0f, 100.0f, true, 0.0f, 0.0f, false));
        this.assertEquals(health - 50.0f, this.targetEntity.m_21223_(), 1.0E-4f);
        health = this.targetEntity.m_21223_();
        EntityUtil.forceHurt((LivingEntity)this.bossEntity, this.targetEntity, new ForceDamageSource(50.0f, 0.0f, true, 0.0f, 0.0f, false));
        this.assertEquals(health - 50.0f, this.targetEntity.m_21223_(), 1.0E-4f);
    }

    @OmniMobsTest
    public void testForceSetHealth() {
        EntityUtil.forceSetHealth(this.targetEntity, 10.0f);
        this.assertEquals(10.0, this.targetEntity.m_21223_(), 1.0E-4f);
        EntityUtil.forceSetHealth(this.targetEntity, 100000.0f);
        this.assertEquals(100000.0, this.targetEntity.m_21223_(), 1.0E-4f);
        EntityUtil.forceSetHealth(this.targetEntity, 30.0f);
        this.assertEquals(30.0, this.targetEntity.m_21223_(), 1.0E-4f);
        EntityUtil.forceSetHealth(this.targetEntity, -20.0f);
        this.assertEquals(-20.0, this.targetEntity.m_21223_(), 1.0E-4f);
        EntityUtil.forceSetHealth(this.targetEntity, 50.0f);
        this.assertEquals(50.0, this.targetEntity.m_21223_(), 1.0E-4f);
    }

    @OmniMobsTest
    public void testBossDamage() {
        float health = this.bossEntity.m_21223_();
        this.bossEntity.m_6469_(this.bossEntity.m_269291_().m_269264_(), 10.0f);
        this.assertEquals(health - 5.0f, this.bossEntity.m_21223_(), 1.0E-4f);
        this.bossEntity = this.createBossEntity();
        health = this.bossEntity.m_21223_();
        this.bossEntity.m_6469_(this.bossEntity.m_269291_().m_269264_(), 1000000.0f);
        this.assertEquals(health - 20.0f, this.bossEntity.m_21223_(), 1.0E-4f);
        this.bossEntity = this.createBossEntity();
        health = this.bossEntity.m_21223_();
        this.bossEntity.m_21153_(0.0f);
        this.assertEquals(health - 20.0f, this.bossEntity.m_21223_(), 1.0E-4f);
    }

    @OmniMobsTest
    public void testHealthManager() {
        float health = this.bossEntity.m_21223_();
        HealthManager.updateHealth(this.bossEntity, 10.0f);
        this.assertEquals(health, this.bossEntity.m_21223_(), 1.0E-4f);
        AccessChecker.performPrivilegedAction(() -> HealthManager.updateHealth(this.bossEntity, 10.0f));
        this.assertEquals(10.0, this.bossEntity.m_21223_(), 1.0E-4f);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface OmniMobsTest {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface OmniMobsBeforeTest {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface OmniMobsAfterTest {
    }
}

