/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.alarm;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flashfur.omnimobs.entities.alarm.Alarm;
import flashfur.omnimobs.entities.alarm.AlarmAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class AlarmModel<T extends Alarm>
extends HierarchicalModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("omnimobs", "alarm"), "main");
    final ModelPart Root;
    final ModelPart All;
    final ModelPart Body;
    final ModelPart RightArm;
    final ModelPart RightLowerArm;
    private final ModelPart Trail;
    private final ModelPart LeftArm;
    private final ModelPart LeftLowerArm;
    private final ModelPart Head;
    private final ModelPart RightLeg;
    private final ModelPart RightLowerLeg;
    private final ModelPart LeftLeg;
    private final ModelPart LeftLowerLeg;

    public AlarmModel(ModelPart root) {
        this.Root = root.m_171324_("Root");
        this.All = this.Root.m_171324_("All");
        this.Body = this.All.m_171324_("Body");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.RightLowerArm = this.RightArm.m_171324_("RightLowerArm");
        this.Trail = this.RightLowerArm.m_171324_("Trail");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.LeftLowerArm = this.LeftArm.m_171324_("LeftLowerArm");
        this.Head = this.Body.m_171324_("Head");
        this.RightLeg = this.All.m_171324_("RightLeg");
        this.RightLowerLeg = this.RightLeg.m_171324_("RightLowerLeg");
        this.LeftLeg = this.All.m_171324_("LeftLeg");
        this.LeftLowerLeg = this.LeftLeg.m_171324_("LeftLowerLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Root = partdefinition.m_171599_("Root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition All = Root.m_171599_("All", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body = All.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 32).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition RightLowerArm = RightArm.m_171599_("RightLowerArm", CubeListBuilder.m_171558_().m_171514_(40, 22).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-0.5f, (float)4.0f, (float)0.0f));
        PartDefinition Trail = RightLowerArm.m_171599_("Trail", CubeListBuilder.m_171558_().m_171514_(52, -6).m_171488_(-0.5f, -1.0f, -4.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)5.3f, (float)-5.2f));
        PartDefinition Trail_r1 = Trail.m_171599_("Trail_r1", CubeListBuilder.m_171558_().m_171514_(52, -6).m_171488_(0.0f, -0.5f, -2.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-0.5f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition LeftLowerArm = LeftArm.m_171599_("LeftLowerArm", CubeListBuilder.m_171558_().m_171514_(32, 54).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 54).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.5f, (float)4.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition RightLeg = All.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-1.9f, (float)-12.0f, (float)0.0f));
        PartDefinition RightLowerLeg = RightLeg.m_171599_("RightLowerLeg", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition LeftLeg = All.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)1.9f, (float)-12.0f, (float)0.0f));
        PartDefinition LeftLowerLeg = LeftLeg.m_171599_("LeftLowerLeg", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(16, 54).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Alarm entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, AlarmAnimation.idle, ageInTicks);
        this.m_233381_(entity.swordAnimationState1, AlarmAnimation.swordAttack1, ageInTicks);
        this.m_233381_(entity.swordAnimationState2, AlarmAnimation.swordAttack2, ageInTicks);
        this.m_233381_(entity.swordAnimationState3, AlarmAnimation.swordAttack3, ageInTicks);
        this.m_233381_(entity.swordAnimationState4, AlarmAnimation.swordAttack4, ageInTicks);
        this.m_233381_(entity.swordAnimationState5, AlarmAnimation.swordAttack5, ageInTicks);
        this.m_233381_(entity.parryAnimationState1, AlarmAnimation.swordParry1, ageInTicks);
        this.m_233381_(entity.parryAnimationState2, AlarmAnimation.swordParry2, ageInTicks);
        this.m_233381_(entity.parryAnimationState3, AlarmAnimation.swordParry3, ageInTicks);
        this.m_233381_(entity.dodge1, AlarmAnimation.dodgeLeft, ageInTicks);
        this.m_233381_(entity.dodge2, AlarmAnimation.dodgeRight, ageInTicks);
        this.m_233381_(entity.flip1, AlarmAnimation.backFlip, ageInTicks);
        this.m_233381_(entity.bowAnimationState, AlarmAnimation.bow, ageInTicks);
        this.m_267799_(AlarmAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.0f);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.Root;
    }

    public void m_6002_(@NotNull HumanoidArm humanoidArm, @NotNull PoseStack poseStack) {
        this.Root.m_104299_(poseStack);
        this.All.m_104299_(poseStack);
        this.Body.m_104299_(poseStack);
        if (humanoidArm == HumanoidArm.RIGHT) {
            this.RightArm.m_104299_(poseStack);
            this.RightLowerArm.m_104299_(poseStack);
            poseStack.m_85837_(0.05, -0.3, 0.01);
        } else {
            this.LeftArm.m_104299_(poseStack);
            this.LeftLowerArm.m_104299_(poseStack);
            poseStack.m_85837_(-0.05, -0.3, 0.01);
        }
    }
}

