/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.anticheat;

import flashfur.omnimobs.util.ClassUtil;
import java.lang.reflect.Method;

public final class StackChecker {
    private static final String[] ALLOWED_PACKAGES = new String[]{"flashfur.omnimobs.", "net.minecraft.", "net.minecraftforge.", "io.github.flemmli97.mobbattle."};

    public static boolean calledFromOtherPackage(String[] packages, int start, int end) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        try {
            for (int i = start; i < (end == -1 ? elements.length : end); ++i) {
                StackTraceElement element = elements[i];
                if (element.getClassName().startsWith("java.lang.reflect.")) {
                    return true;
                }
                boolean found = false;
                for (String p : packages) {
                    if (!element.getClassName().startsWith(p)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return true;
                }
                Class<?> c = Class.forName(element.getClassName());
                String method = element.getMethodName();
                boolean contains = false;
                for (Method m : ClassUtil.getAllDeclaredMethods(c)) {
                    if (contains) continue;
                    contains = m.getName().equals(method);
                }
                if (contains) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean calledFromOtherPackage(String ... packages) {
        return StackChecker.calledFromOtherPackage(packages, 2, -1);
    }

    public static boolean notCalledFromOmniMobs() {
        return StackChecker.calledFromOtherPackage(new String[]{"flashfur.omnimobs."}, 2, 4);
    }

    public static boolean notCalledFromOmniMobsOrMinecraft(int start, int end) {
        return StackChecker.calledFromOtherPackage(new String[]{"flashfur.omnimobs.", "net.minecraft.", "net.minecraftforge."}, start, end);
    }

    public static boolean notCalledFromOmniMobsOrMinecraft() {
        return StackChecker.calledFromOtherPackage(new String[]{"flashfur.omnimobs.", "net.minecraft."}, 2, 5);
    }

    public static boolean notCalledFromMinecraft() {
        return StackChecker.calledFromOtherPackage(new String[]{"flashfur.omnimobs.", "net.minecraft.", "net.minecraftforge."}, 2, 8);
    }

    public static boolean notCalledFromAllowedPackage(int start, int end) {
        return StackChecker.calledFromOtherPackage(ALLOWED_PACKAGES, start, end);
    }

    public static boolean notCalledFromAllowedPackage() {
        return StackChecker.notCalledFromAllowedPackage(2, 4);
    }
}

