/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flashfur.omnimobs.GlobalTextures;
import flashfur.omnimobs.entities.base.ExplosionRender;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ExplosionRenderRenderer
extends EntityRenderer<ExplosionRender> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private static final ResourceLocation GLOW = new ResourceLocation("omnimobs", "textures/vfx/glow.png");

    public ExplosionRenderRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(@NotNull ExplosionRender explosionRender, float yaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light) {
        if (((Boolean)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_IS_BILLBOARD)).booleanValue()) {
            this.renderBillboard(explosionRender, partialTick, poseStack, multiBufferSource);
        } else {
            this.renderRays(explosionRender, partialTick, poseStack, multiBufferSource);
        }
    }

    public void renderBillboard(@NotNull ExplosionRender explosionRender, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource) {
        int time2 = (Integer)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_TIME);
        float size2 = ((Float)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_SIZE)).floatValue();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        poseStack.m_252781_(this.f_114476_.m_253208_());
        float size = 0.95f * ((float)explosionRender.f_19797_ + partialTick);
        if (0.95f * ((float)explosionRender.f_19797_ + partialTick) > 1.0f) {
            size = 1.0f;
        }
        poseStack.m_85841_(size2 * size, size2 * size, size2 * size);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(explosionRender)));
        float alpha = 1.0f - ((float)explosionRender.f_19797_ + partialTick) * (1.0f / (float)time2);
        if (((float)explosionRender.f_19797_ + partialTick) * (255.0f / (float)time2) >= 255.0f) {
            alpha = 0.0f;
        }
        int light = 15;
        Vec3 colour = new Vec3((double)((Vector3f)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_COLOUR)).x, (double)((Vector3f)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_COLOUR)).y, (double)((Vector3f)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_COLOUR)).z);
        float r = (float)colour.f_82479_ / 255.0f * alpha;
        float g = (float)colour.f_82480_ / 255.0f * alpha;
        float b = (float)colour.f_82481_ / 255.0f * alpha;
        if (colour.equals((Object)new Vec3(-1.0, -1.0, -1.0))) {
            r = alpha;
            g = alpha - alpha / 5.0f;
            b = alpha - alpha / 2.0f;
        }
        for (int i = 0; i < 5; ++i) {
            vertexConsumer.m_252986_(matrix4f, -1.0f, -1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, -1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, 1.0f, -1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    public void renderRays(@NotNull ExplosionRender explosionRender, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource) {
        int time2 = (Integer)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_TIME);
        float size2 = ((Float)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_SIZE)).floatValue();
        float size = 0.95f * ((float)explosionRender.f_19797_ + partialTick);
        if (0.95f * ((float)explosionRender.f_19797_ + partialTick) > 1.0f) {
            size = 1.0f;
        }
        float alpha = 1.0f - ((float)explosionRender.f_19797_ + partialTick) * (1.0f / (float)time2);
        if (((float)explosionRender.f_19797_ + partialTick) * (255.0f / (float)time2) >= 255.0f) {
            alpha = 0.0f;
        }
        Vec3 colour = new Vec3((double)((Vector3f)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_COLOUR)).x, (double)((Vector3f)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_COLOUR)).y, (double)((Vector3f)explosionRender.m_20088_().m_135370_(ExplosionRender.DATA_COLOUR)).z);
        float r = (float)colour.f_82479_ / 255.0f * alpha;
        float g = (float)colour.f_82480_ / 255.0f * alpha;
        float b = (float)colour.f_82481_ / 255.0f * alpha;
        if (colour.equals((Object)new Vec3(-1.0, -1.0, -1.0))) {
            r = alpha;
            g = alpha - alpha / 5.0f;
            b = alpha - alpha / 2.0f;
        }
        float v = 1.0f;
        RandomSource randomSource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)GlobalTextures.SOLID_WHITE));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.5, 0.0);
        for (int i = 0; i < 250; ++i) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f + v * 90.0f));
            float v2 = randomSource.m_188501_() * 1.0f + 5.0f + 1.0f;
            float v3 = randomSource.m_188501_() * 1.0f + 1.0f + 1.0f;
            float size1 = size / 10.0f * size2;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            int i1 = 50;
            ExplosionRenderRenderer.vertex01(vertexConsumer, matrix4f, matrix3f, r, g, b, i1);
            ExplosionRenderRenderer.vertex2(vertexConsumer, matrix4f, matrix3f, v2 *= size1, v3 *= size1);
            ExplosionRenderRenderer.vertex3(vertexConsumer, matrix4f, matrix3f, v2, v3);
            ExplosionRenderRenderer.vertex01(vertexConsumer, matrix4f, matrix3f, r, g, b, i1);
            ExplosionRenderRenderer.vertex3(vertexConsumer, matrix4f, matrix3f, v2, v3);
            ExplosionRenderRenderer.vertex4(vertexConsumer, matrix4f, matrix3f, v2, v3);
            ExplosionRenderRenderer.vertex01(vertexConsumer, matrix4f, matrix3f, r, g, b, i1);
            ExplosionRenderRenderer.vertex4(vertexConsumer, matrix4f, matrix3f, v2, v3);
            ExplosionRenderRenderer.vertex2(vertexConsumer, matrix4f, matrix3f, v2, v3);
        }
        poseStack.m_85849_();
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float r, float g, float b, float alpha) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex2(VertexConsumer p_253956_, Matrix4f p_254053_, Matrix3f matrix3f, float p_253704_, float p_253701_) {
        p_253956_.m_252986_(p_254053_, -HALF_SQRT_3 * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex3(VertexConsumer p_253850_, Matrix4f p_254379_, Matrix3f matrix3f, float p_253729_, float p_254030_) {
        p_253850_.m_252986_(p_254379_, HALF_SQRT_3 * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex4(VertexConsumer p_254184_, Matrix4f p_254082_, Matrix3f matrix3f, float p_253649_, float p_253694_) {
        p_254184_.m_252986_(p_254082_, 0.0f, p_253649_, 1.0f * p_253694_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ExplosionRender explosionRender) {
        return GLOW;
    }
}

