/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.base.abilities;

import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.base.abilities.AbstractMove;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncAbilityData;
import flashfur.omnimobs.util.MathsUtil;
import net.minecraft.world.entity.AnimationState;

public abstract class AbstractCooldownMove
extends AbstractMove {
    protected int cooldown = 0;
    protected final int maxCooldown;

    public AbstractCooldownMove(BossEntity entity, AnimationState[] state, float range, int time, int cooldown, boolean blocking, int endCooldown) {
        super(entity, state, time, range, blocking, endCooldown);
        this.maxCooldown = cooldown;
        this.setCooldown(this.createCooldown());
    }

    @Override
    public void start() {
        super.start();
        this.setCooldown(this.createCooldown());
    }

    protected int createCooldown() {
        return (int)((float)this.maxCooldown / MathsUtil.randFloat(1.0f, 2.0f));
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.checkCooldown();
    }

    protected boolean checkCooldown() {
        return this.getCooldown() <= 0;
    }

    @Override
    protected void inactiveTick() {
        super.inactiveTick();
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        PacketHandler.sendToClient(new S2CSyncAbilityData(cooldown, "cooldown", this.getId(), this.getEntity().m_19879_()));
    }

    public int getMaxCooldown() {
        return this.maxCooldown;
    }
}

