/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.entities.metapotent_flashfur;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flashfur.omnimobs.GlobalTextures;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfur;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurEntity;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurLevel;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurModel;
import flashfur.omnimobs.entities.metapotent_flashfur.StarVFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MetapotentFlashfurRenderer
extends MobRenderer<MetapotentFlashfurEntity, MetapotentFlashfurModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("omnimobs", "textures/entities/flashfur.png");
    private static final ResourceLocation TEXTURE2 = new ResourceLocation("omnimobs", "textures/entities/meta_aura.png");
    private static final ResourceLocation STAR_TEXTURE = new ResourceLocation("omnimobs", "textures/vfx/glow.png");
    public static final float scale = 10.0f;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public MetapotentFlashfurRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new MetapotentFlashfurModel(ctx.m_174023_(MetapotentFlashfurModel.LAYER_LOCATION)), 5.0f);
        this.m_115326_((RenderLayer)new RenderLayer<MetapotentFlashfurEntity, MetapotentFlashfurModel>((RenderLayerParent)this){

            public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, @NotNull MetapotentFlashfurEntity flashfur, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float yaw, float pitch) {
                if (flashfur.isEntity) {
                    return;
                }
                float ticks = (float)flashfur.metapotentFlashfur.tickCount + MetapotentFlashfurLevel.getPartialTick();
                float alpha = 2.0f;
                VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)TEXTURE2, (float)(ticks / 50.0f), (float)(ticks / 50.0f)));
                if (!flashfur.m_20145_()) {
                    ((MetapotentFlashfurModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, light, LivingEntityRenderer.m_115338_((LivingEntity)flashfur, (float)0.0f), MetapotentFlashfur.lightBlue[0] / alpha, MetapotentFlashfur.lightBlue[1] / alpha, MetapotentFlashfur.lightBlue[2] / alpha, 1.0f);
                }
                vertexConsumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)TEXTURE2, (float)(ticks / 50.0f), (float)(ticks / -50.0f)));
                if (!flashfur.m_20145_()) {
                    ((MetapotentFlashfurModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, light, LivingEntityRenderer.m_115338_((LivingEntity)flashfur, (float)0.0f), MetapotentFlashfur.purple[0] / alpha, MetapotentFlashfur.purple[1] / alpha, MetapotentFlashfur.purple[2] / alpha, 1.0f);
                }
            }
        });
    }

    protected void scale(@NotNull MetapotentFlashfurEntity flashfur, PoseStack stack, float v) {
        stack.m_85841_(10.0f, 10.0f, 10.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull MetapotentFlashfurEntity flashfur) {
        return TEXTURE;
    }

    public void render(@NotNull MetapotentFlashfurEntity flashfur, float v, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i) {
        if (flashfur.isEntity) {
            return;
        }
        partialTicks = MetapotentFlashfurLevel.getPartialTick();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(flashfur.metapotentFlashfur.getRotY(partialTicks)));
        this.renderLiving(flashfur, v, partialTicks, poseStack, multiBufferSource, i);
        poseStack.m_85849_();
        MetapotentFlashfurRenderer.lightRays(poseStack, flashfur.metapotentFlashfur.tickCount, partialTicks, 0.0f, 7.5f, 0.0f, 10.0f, multiBufferSource);
        this.renderStars(poseStack, partialTicks, multiBufferSource, flashfur);
    }

    protected void setupRotations(MetapotentFlashfurEntity p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_) {
        if (this.m_5936_((LivingEntity)p_115317_)) {
            p_115320_ += (float)(Math.cos((double)p_115317_.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!p_115317_.m_217003_(Pose.SLEEPING)) {
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_115320_));
        }
        if (p_115317_.m_21209_()) {
            p_115318_.m_252781_(Axis.f_252529_.m_252977_(-90.0f - p_115317_.m_146909_()));
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(((float)p_115317_.f_19797_ + p_115321_) * -75.0f));
        } else if (p_115317_.m_217003_(Pose.SLEEPING)) {
            Direction direction = p_115317_.m_21259_();
            float f1 = p_115320_;
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(f1));
            p_115318_.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)p_115317_)));
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (MetapotentFlashfurRenderer.m_194453_((LivingEntity)p_115317_)) {
            p_115318_.m_252880_(0.0f, p_115317_.m_20206_() + 0.1f, 0.0f);
            p_115318_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    private void renderStars(PoseStack poseStack, float partialTick, MultiBufferSource multiBufferSource, MetapotentFlashfurEntity flashfur) {
        try {
            for (int i = 0; i < flashfur.metapotentFlashfur.stars.size(); ++i) {
                StarVFX star = flashfur.metapotentFlashfur.stars.get(i);
                if (star == null) continue;
                this.renderStar(poseStack, partialTick, multiBufferSource, star, flashfur);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void renderStar(PoseStack poseStack, float partialTick, MultiBufferSource multiBufferSource, StarVFX star, MetapotentFlashfurEntity flashfur) {
        poseStack.m_85836_();
        poseStack.m_85837_(-flashfur.metapotentFlashfur.getPos().f_82479_, -flashfur.metapotentFlashfur.getPos().f_82480_, -flashfur.metapotentFlashfur.getPos().f_82481_);
        poseStack.m_85837_(star.position.f_82479_, star.position.f_82480_, star.position.f_82481_);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_85841_(star.size * 10.0f, star.size * 10.0f, star.size * 10.0f);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)STAR_TEXTURE));
        float r = Mth.m_14179_((float)partialTick, (float)star.oldColour[0], (float)star.colour[0]);
        float g = Mth.m_14179_((float)partialTick, (float)star.oldColour[1], (float)star.colour[1]);
        float b = Mth.m_14179_((float)partialTick, (float)star.oldColour[2], (float)star.colour[2]);
        float alpha = Mth.m_14179_((float)partialTick, (float)star.oldColour[3], (float)star.colour[3]);
        int light = 15;
        vertexConsumer.m_252986_(matrix4f, -1.0f, -1.0f, 0.0f).m_85950_(r *= alpha, g *= alpha, b *= alpha, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 1.0f, -1.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void renderLiving(MetapotentFlashfurEntity metapotentFlashfur, float v, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int i1) {
        float f8;
        Direction direction;
        poseStack.m_85836_();
        ((MetapotentFlashfurModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)metapotentFlashfur, partialTick);
        float f = Mth.m_14189_((float)partialTick, (float)metapotentFlashfur.f_20884_, (float)metapotentFlashfur.f_20883_);
        float f1 = Mth.m_14189_((float)partialTick, (float)metapotentFlashfur.f_20886_, (float)metapotentFlashfur.f_20885_);
        float f2 = f1 - f;
        float f6 = Mth.m_14179_((float)partialTick, (float)metapotentFlashfur.f_19860_, (float)metapotentFlashfur.m_146909_());
        if (MetapotentFlashfurRenderer.m_194453_((LivingEntity)metapotentFlashfur)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        if (metapotentFlashfur.m_217003_(Pose.SLEEPING) && (direction = metapotentFlashfur.m_21259_()) != null) {
            f8 = metapotentFlashfur.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-direction.m_122429_()) * f8, 0.0f, (float)(-direction.m_122431_()) * f8);
        }
        float f7 = this.m_6930_((LivingEntity)metapotentFlashfur, partialTick);
        this.setupRotations(metapotentFlashfur, poseStack, f7, f, partialTick);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(metapotentFlashfur, poseStack, partialTick);
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        f8 = metapotentFlashfur.f_267362_.m_267711_(partialTick);
        float f5 = metapotentFlashfur.f_267362_.m_267590_(partialTick);
        if (f8 > 1.0f) {
            f8 = 1.0f;
        }
        ((MetapotentFlashfurModel)this.f_115290_).m_6839_((Entity)metapotentFlashfur, f5, f8, partialTick);
        ((MetapotentFlashfurModel)this.f_115290_).setupAnim(metapotentFlashfur, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)metapotentFlashfur);
        boolean flag1 = !flag && !metapotentFlashfur.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)metapotentFlashfur);
        RenderType rendertype = this.m_7225_((LivingEntity)metapotentFlashfur, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = multiBufferSource.m_6299_(rendertype);
            int i = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)this.m_6931_((LivingEntity)metapotentFlashfur, partialTick)), (int)OverlayTexture.m_118096_((boolean)false));
            ((MetapotentFlashfurModel)this.f_115290_).m_7695_(poseStack, vertexconsumer, i1, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!metapotentFlashfur.m_5833_()) {
            for (RenderLayer renderlayer : this.f_115291_) {
                renderlayer.m_6494_(poseStack, multiBufferSource, i1, (Entity)metapotentFlashfur, f5, f8, partialTick, f7, f2, f6);
            }
        }
        poseStack.m_85849_();
    }

    public static void lightRays(PoseStack poseStack, float tickCount, float partialTicks, float x, float y, float z, float scale, MultiBufferSource multiBufferSource) {
        float v = (tickCount + partialTicks) / 5000.0f;
        float v1 = Math.min(v > 0.8f ? (v - 0.8f) / 0.2f : 0.0f, 1.0f);
        RandomSource randomSource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)GlobalTextures.SOLID_WHITE));
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        for (int i = 0; i < 1000; ++i) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f + v * 90.0f));
            float v2 = randomSource.m_188501_() * 10.5f * scale;
            float v3 = randomSource.m_188501_() * 1.0f * scale;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            int i1 = 50;
            float alpha = 10.0f;
            MetapotentFlashfurRenderer.vertex01(vertexConsumer, matrix4f, matrix3f, MetapotentFlashfur.purple[0] / alpha, MetapotentFlashfur.purple[1] / alpha, MetapotentFlashfur.purple[2] / alpha, i1);
            MetapotentFlashfurRenderer.vertex2(vertexConsumer, matrix4f, matrix3f, v2, v3);
            MetapotentFlashfurRenderer.vertex3(vertexConsumer, matrix4f, matrix3f, v2, v3);
            MetapotentFlashfurRenderer.vertex01(vertexConsumer, matrix4f, matrix3f, MetapotentFlashfur.purple[0] / alpha, MetapotentFlashfur.purple[1] / alpha, MetapotentFlashfur.purple[2] / alpha, i1);
            MetapotentFlashfurRenderer.vertex3(vertexConsumer, matrix4f, matrix3f, v2, v3);
            MetapotentFlashfurRenderer.vertex4(vertexConsumer, matrix4f, matrix3f, v2, v3);
            MetapotentFlashfurRenderer.vertex01(vertexConsumer, matrix4f, matrix3f, MetapotentFlashfur.lightBlue[0] / alpha, MetapotentFlashfur.lightBlue[1] / alpha, MetapotentFlashfur.lightBlue[2] / alpha, i1);
            MetapotentFlashfurRenderer.vertex4(vertexConsumer, matrix4f, matrix3f, v2, v3);
            MetapotentFlashfurRenderer.vertex2(vertexConsumer, matrix4f, matrix3f, v2, v3);
        }
        poseStack.m_85849_();
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float r, float g, float b, float alpha) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex2(VertexConsumer p_253956_, Matrix4f p_254053_, Matrix3f matrix3f, float p_253704_, float p_253701_) {
        p_253956_.m_252986_(p_254053_, -HALF_SQRT_3 * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex3(VertexConsumer p_253850_, Matrix4f p_254379_, Matrix3f matrix3f, float p_253729_, float p_254030_) {
        p_253850_.m_252986_(p_254379_, HALF_SQRT_3 * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex4(VertexConsumer p_254184_, Matrix4f p_254082_, Matrix3f matrix3f, float p_253649_, float p_253694_) {
        p_254184_.m_252986_(p_254082_, 0.0f, p_253649_, 1.0f * p_253694_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

