/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.items;

import flashfur.omnimobs.entities.anticheat.AccessChecker;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurEntity;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurLevel;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncOpenEntityRemoverScreen;
import flashfur.omnimobs.network.S2CSyncSetPos;
import flashfur.omnimobs.screen.EntityRemoverSetting;
import flashfur.omnimobs.util.EntityUtil;
import flashfur.omnimobs.util.ModCompatUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRemover
extends SwordItem {
    public static final ArrayList<EntityRemoverSetting> SETTINGS = new ArrayList();

    public EntityRemover(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, damage, speed, properties);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        CompoundTag tag = stack.m_41784_();
        EntityRemover.checkSettings(tag);
        if (entity instanceof MetapotentFlashfurEntity) {
            MetapotentFlashfurEntity metapotentFlashfur = (MetapotentFlashfurEntity)entity;
            AccessChecker.performPrivilegedAction(() -> MetapotentFlashfurLevel.remove(metapotentFlashfur.metapotentFlashfur));
        }
        this.removeEntity(entity, player.m_9236_(), tag);
        return false;
    }

    public float m_43299_() {
        return 100.0f;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        CompoundTag tag = stack.m_41784_();
        EntityRemover.checkSettings(tag);
        if (Screen.m_96638_()) {
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    PacketHandler.sendToPlayer(new S2CSyncOpenEntityRemoverScreen(player.m_19879_()), serverPlayer);
                }
            }
            return super.m_7203_(level, player, interactionHand);
        }
        AccessChecker.performPrivilegedAction(MetapotentFlashfurLevel::clear);
        ModCompatUtil.destroyDragionn(level, player.m_20185_(), player.m_20186_(), player.m_20189_());
        for (Entity entity : EntityUtil.getAllEntities(level)) {
            if (entity instanceof Player) continue;
            this.removeEntity(entity, level, tag);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    private void removeEntity(Entity entity, Level level, CompoundTag tag) {
        LivingEntity livingEntity;
        ModCompatUtil.destroyDragionnsStuffMobs(entity);
        if (tag.m_128471_("omnimobs_runLeaveLevelCalls")) {
            EntityUtil.forceRemove(entity, Entity.RemovalReason.DISCARDED);
        } else {
            EntityUtil.forceRemoveNoLeaveLevelCalls(entity, Entity.RemovalReason.DISCARDED);
        }
        if (tag.m_128471_("omnimobs_teleportEntity") && (entity.m_6084_() || EntityUtil.getAllEntities(level).contains(entity))) {
            EntityUtil.forceSetPos(entity, new Vec3(1.0E9, 0.0, 0.0));
            if (!level.m_5776_()) {
                PacketHandler.sendToClient(new S2CSyncSetPos(entity.m_19879_(), 1.0E9, 0.0, 0.0));
            }
        }
        if (tag.m_128471_("omnimobs_runDie") && entity instanceof LivingEntity && !ForgeRegistries.ENTITY_TYPES.getKey((Object)(livingEntity = (LivingEntity)entity).m_6095_()).toString().equals("vllr_mystery:vllr")) {
            livingEntity.m_6667_(livingEntity.m_269291_().m_287172_());
        }
    }

    public void m_6883_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean b) {
        super.m_6883_(itemStack, level, entity, i, b);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag compoundTag = itemStack.m_41784_();
            EntityRemover.checkSettings(compoundTag);
            if (compoundTag.m_128471_("omnimobs_playerInvulnerability")) {
                player.m_21153_(player.m_21233_());
            }
        }
    }

    public static void checkSettings(CompoundTag compoundTag) {
        for (EntityRemoverSetting setting : SETTINGS) {
            if (compoundTag.m_128441_(setting.getNbt())) continue;
            compoundTag.m_128379_(setting.getNbt(), setting.getDefaultValue());
        }
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return 3;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> componentList, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, componentList, tooltipFlag);
        componentList.add((Component)Component.m_237113_((String)""));
        componentList.add((Component)Component.m_237115_((String)"tooltip.omnimobs.entity_remover.enabled_settings").m_130940_(ChatFormatting.BOLD));
        CompoundTag tag = itemStack.m_41784_();
        boolean containsItem = false;
        for (EntityRemoverSetting setting : SETTINGS) {
            if (!tag.m_128441_(setting.getNbt())) continue;
            boolean enabled = tag.m_128471_(setting.getNbt());
            componentList.add((Component)Component.m_237113_((String)(enabled ? "\u2714 " : "\u2718 ")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)setting.getDisplay().getString()).m_130940_(enabled ? ChatFormatting.GREEN : ChatFormatting.RED)));
            containsItem = true;
        }
        if (!containsItem) {
            componentList.add((Component)Component.m_237113_((String)"- Empty").m_130940_(ChatFormatting.GRAY));
        }
        componentList.add((Component)Component.m_237113_((String)""));
        componentList.add((Component)Component.m_237113_((String)("\u00a77" + Component.m_237115_((String)"tooltip.omnimobs.entity_remover.left_click").getString())));
        componentList.add((Component)Component.m_237113_((String)("\u00a77" + Component.m_237115_((String)"tooltip.omnimobs.entity_remover.right_click").getString())));
        componentList.add((Component)Component.m_237113_((String)("\u00a77" + Component.m_237115_((String)"tooltip.omnimobs.entity_remover.shift_click").getString())));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        float time = 20.0f;
        return Component.m_237115_((String)"item.omnimobs.entity_remover").m_130938_(style -> style.m_178520_(Color.HSBtoRGB(0.82f, Math.max(Math.abs(Minecraft.m_91087_().f_91073_ == null ? 0.0f : ((float)Minecraft.m_91087_().f_91073_.m_46467_() + Minecraft.m_91087_().getPartialTick()) % time / time - 0.5f) + 0.5f, 0.0f) * 2.0f - 1.0f, 1.0f))).m_130940_(ChatFormatting.BOLD);
    }

    public int getBorderColour() {
        return Color.HSBtoRGB(0.82f, 1.0f, 0.75f);
    }

    public static CompoundTag getEntityRemoverCompoundTag(Player player) {
        Inventory inventory = player.m_150109_();
        if (inventory != null) {
            for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                ItemStack itemStack = inventory.m_8020_(i);
                if (!(itemStack.m_41720_() instanceof EntityRemover)) continue;
                CompoundTag compoundTag = itemStack.m_41784_();
                EntityRemover.checkSettings(compoundTag);
                return compoundTag;
            }
        }
        return null;
    }

    static {
        SETTINGS.add(new EntityRemoverSetting(Component.m_237115_((String)"gui.omnimobs.entity_remover.run_die"), Component.m_237115_((String)"gui.omnimobs.entity_remover.run_die.description"), "runDie", true));
        SETTINGS.add(new EntityRemoverSetting(Component.m_237115_((String)"gui.omnimobs.entity_remover.run_leave_level_calls"), Component.m_237115_((String)"gui.omnimobs.entity_remover.run_leave_level_calls.description"), "runLeaveLevelCalls", true));
        SETTINGS.add(new EntityRemoverSetting(Component.m_237115_((String)"gui.omnimobs.entity_remover.teleport_entity"), Component.m_237115_((String)"gui.omnimobs.entity_remover.teleport_entity.description"), "teleportEntity", true));
        SETTINGS.add(new EntityRemoverSetting(Component.m_237115_((String)"gui.omnimobs.entity_remover.player_invulnerability"), Component.m_237115_((String)"gui.omnimobs.entity_remover.player_invulnerability.description"), "playerInvulnerability", false));
        SETTINGS.add(new EntityRemoverSetting(Component.m_237115_((String)"gui.omnimobs.entity_remover.player_immovability"), Component.m_237115_((String)"gui.omnimobs.entity_remover.player_immovability.description"), "playerImmovability", false));
        SETTINGS.add(new EntityRemoverSetting(Component.m_237115_((String)"gui.omnimobs.entity_remover.ban_kicking"), Component.m_237115_((String)"gui.omnimobs.entity_remover.ban_kicking.description"), "banKicking", false));
    }
}

