/*
 * Decompiled with CFR 0.152.
 */
package flashfur.omnimobs.util;

import flashfur.omnimobs.entities.anticheat.AccessChecker;
import flashfur.omnimobs.entities.anticheat.ProtectedHashMap;
import flashfur.omnimobs.entities.anticheat.ProtectedWeakHashMap;
import flashfur.omnimobs.entities.base.BossEntity;
import flashfur.omnimobs.entities.base.CameraShakeEntity;
import flashfur.omnimobs.entities.base.ExplosionRender;
import flashfur.omnimobs.entities.base.abilities.AbstractAbility;
import flashfur.omnimobs.entities.base.abilities.AbstractAttackAbility;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfur;
import flashfur.omnimobs.entities.metapotent_flashfur.MetapotentFlashfurEntity;
import flashfur.omnimobs.init.EntityInit;
import flashfur.omnimobs.network.PacketHandler;
import flashfur.omnimobs.network.S2CSyncDamageFlash;
import flashfur.omnimobs.network.S2CSyncDespawn;
import flashfur.omnimobs.network.S2CSyncPlayerSetDeltaMovement;
import flashfur.omnimobs.network.S2CSyncPutFloat;
import flashfur.omnimobs.network.S2CSyncSetFloatField;
import flashfur.omnimobs.util.ClassUtil;
import flashfur.omnimobs.util.EntityRemovalUtil;
import flashfur.omnimobs.util.ForceDamageSource;
import flashfur.omnimobs.util.FormattingUtil;
import flashfur.omnimobs.util.GetHealthModifyUtil;
import flashfur.omnimobs.util.MathsUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EntityUtil {
    public static final ProtectedHashMap<Class<?>, List<Field>> FIELD_CACHE = new ProtectedHashMap();
    public static final ProtectedHashMap<Class<?>, List<Method>> METHOD_CACHE = new ProtectedHashMap();
    public static final ProtectedHashMap<Class<?>, Method> TRUE_GETHEALTH_CACHE = new ProtectedHashMap();
    public static final ProtectedWeakHashMap<Entity, Float> REAL_MAX_HEALTH = new ProtectedWeakHashMap();

    public static void forceHurt(LivingEntity attacker, LivingEntity entity, ForceDamageSource damageSource) {
        boolean canTakeDamage;
        float entityHealth;
        float entityGetHealth;
        float amount;
        block21: {
            Player player;
            block20: {
                ShieldBlockEvent ev;
                Mob mob;
                amount = damageSource.getAmount();
                boolean bypassCreative = damageSource.isBypassCreative();
                if (!entity.m_6084_() || attacker.m_7307_((Entity)entity) && attacker instanceof Mob && (mob = (Mob)attacker).m_5448_() != null && mob.m_5448_() == entity) {
                    return;
                }
                if (entity instanceof BossEntity) {
                    Vec3 oldMovement = entity.m_20184_();
                    if (entity.m_6469_(entity.m_269291_().m_269333_(attacker), amount)) {
                        EntityUtil.forceSetDeltaMovement((Entity)entity, oldMovement);
                        EntityUtil.forceAttackKnockback(attacker, entity, damageSource.getKnockback(), damageSource.isForceKnockback());
                    }
                    return;
                }
                entityGetHealth = EntityUtil.getTrueHealth(entity);
                if (amount > 0.0f && entity.m_21275_(entity.m_269291_().m_269333_(attacker)) && !(attacker instanceof MetapotentFlashfurEntity) && !(ev = ForgeHooks.onShieldBlock((LivingEntity)entity, (DamageSource)entity.m_269291_().m_269333_(attacker), (float)amount)).isCanceled()) {
                    if (ev.shieldTakesDamage()) {
                        entity.m_7909_(amount);
                    }
                    float f1 = ev.getBlockedDamage();
                    amount -= ev.getBlockedDamage();
                    entity.m_6728_(attacker);
                    entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12346_, entity.m_5720_(), 1.0f, 0.8f + entity.m_9236_().f_46441_.m_188501_() * 0.4f);
                }
                entityHealth = entityGetHealth + entity.m_6103_();
                canTakeDamage = true;
                if (!bypassCreative || !(attacker instanceof MetapotentFlashfurEntity)) break block20;
                MetapotentFlashfurEntity metapotentFlashfur = (MetapotentFlashfurEntity)attacker;
                if (metapotentFlashfur.metapotentFlashfur.getTarget() == entity) break block21;
            }
            if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
                canTakeDamage = false;
            }
        }
        if (canTakeDamage) {
            if (amount > 0.0f) {
                EntityUtil.damageHealth(entity, attacker, entity.m_21223_(), damageSource);
            }
            if (damageSource.getAntiHealPercentage() != 0.0f) {
                GetHealthModifyUtil.addHealthDelta(entity, -amount * (damageSource.getAntiHealPercentage() / 100.0f));
            }
        }
        if (attacker instanceof BossEntity) {
            BossEntity bossEntity = (BossEntity)attacker;
            for (AbstractAbility ability : bossEntity.getAbilities()) {
                if (!(ability instanceof AbstractAttackAbility)) continue;
                AbstractAttackAbility attackAbility = (AbstractAttackAbility)ability;
                attackAbility.onAttackEntity(entity, canTakeDamage, entityHealth);
            }
        }
        if (entityHealth > (entityGetHealth = entity.m_21223_() + entity.m_6103_())) {
            if (!attacker.m_9236_().m_5776_()) {
                PacketHandler.sendToClient(new S2CSyncDamageFlash(10, entity.m_19879_()));
            }
            entity.m_6053_(10.0f);
            entity.m_6703_(attacker);
            if (!attacker.m_7307_((Entity)entity) && entity.m_6084_() && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6710_(attacker);
            }
            EntityUtil.playDamageSounds(entity);
            EntityUtil.forceAttackKnockback(attacker, entity, damageSource.getKnockback(), damageSource.isForceKnockback());
            if (Float.isNaN(entity.m_21223_()) || entity.m_21223_() <= 0.0f) {
                entity.m_6469_(entity.m_269291_().m_269264_(), 100.0f);
            }
        } else {
            entity.f_19802_ = 0;
            entity.m_6469_(entity.m_269291_().m_269333_(attacker), amount);
        }
    }

    public static void putFloatSynced(Entity entity, String dataValue, float value) {
        entity.getPersistentData().m_128350_(dataValue, value);
        PacketHandler.sendToClient(new S2CSyncPutFloat(entity.m_19879_(), dataValue, value));
    }

    public static List<Entity> entityList(float radius, Level level, double x, double y, double z) {
        AABB aabb = new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius);
        List entities = EntityUtil.getAllEntities(level).stream().filter(entity -> aabb.m_82390_(entity.m_20182_())).toList();
        if (entities.isEmpty()) {
            entities = level.m_45933_(null, new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius));
        }
        return entities;
    }

    public static List<Entity> getAllEntities(Level level) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entityList.addAll((Collection<Entity>)((LevelEntityGetterAdapter)serverLevel.f_143244_.f_157496_).f_156940_.f_156807_.values());
            if (entityList.isEmpty()) {
                serverLevel.m_8583_().forEach(entityList::add);
            }
        } else if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            entityList.addAll((Collection<Entity>)((LevelEntityGetterAdapter)clientLevel.f_171631_.f_157640_).f_156940_.f_156807_.values());
        }
        return entityList;
    }

    public static void forceAttackKnockback(LivingEntity attacker, LivingEntity entity, double amount, boolean force) {
        double d0 = attacker.m_20185_() - entity.m_20185_();
        double d1 = attacker.m_20189_() - entity.m_20189_();
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        if (force) {
            EntityUtil.forceKnockback(entity, (double)0.4f * amount, d0, d1, true);
        } else {
            EntityUtil.forceKnockback(entity, (double)0.4f * amount, d0, d1, false);
        }
    }

    public static void forceKnockback(LivingEntity entity, double x, double y, double z, boolean ignoreKnockbackResistance) {
        x = ignoreKnockbackResistance ? (x *= 1.0) : (x *= 1.0 - Mth.m_14008_((double)entity.m_21133_(Attributes.f_22278_), (double)0.0, (double)0.9));
        if (!(x <= 0.0)) {
            entity.f_19812_ = true;
            Vec3 vec3 = entity.m_20184_();
            Vec3 vec31 = new Vec3(y, 0.0, z).m_82541_().m_82490_(x);
            EntityUtil.forceSetDeltaMovement((Entity)entity, vec3.f_82479_ / 2.0 - vec31.f_82479_, entity.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + x) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
        }
    }

    private static void playDamageSounds(LivingEntity entity) {
        if (entity.m_6084_()) {
            if (entity instanceof Player) {
                entity.m_9236_().m_5594_(null, entity.m_20183_(), Objects.requireNonNull(entity.m_7975_(entity.m_269291_().m_269264_())), entity.m_5720_(), entity.m_6121_(), entity.m_6100_());
            } else {
                entity.m_6677_(entity.m_269291_().m_269264_());
            }
        } else {
            try {
                entity.m_6667_(entity.m_269291_().m_269264_());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entity.m_5592_() != null) {
                entity.m_216990_(entity.m_5592_());
            }
        }
    }

    private static void damageHealth(LivingEntity entity, LivingEntity attacker, float getHealth, ForceDamageSource damageSource) {
        float value = damageSource.getAmount();
        if (damageSource.getBypassArmourPercentage() < 100.0f) {
            float bypassArmourValue = value * (damageSource.getBypassArmourPercentage() / 100.0f);
            value -= bypassArmourValue;
            value = EntityUtil.calculateDefence(entity, attacker, value);
            value = entity.m_6103_() - value;
            entity.m_7911_(Mth.m_14036_((float)value, (float)0.0f, (float)Float.POSITIVE_INFINITY));
            value = entity.m_6103_() - value;
            value = Mth.m_14154_((float)value);
            value += bypassArmourValue;
        }
        if (Float.isNaN(value)) {
            value = damageSource.getAmount();
        }
        EntityUtil.forceSetHealth(entity, getHealth - value);
    }

    private static float calculateDefence(LivingEntity entity, LivingEntity attacker, float value) {
        DamageSource source = entity.m_269291_().m_269333_(attacker);
        float newValue = entity.m_21161_(source, value);
        return EntityUtil.getDamageAfterMagicAbsorb(entity, source, newValue);
    }

    private static float getDamageAfterMagicAbsorb(LivingEntity entity, DamageSource source, float value) {
        int k;
        int j;
        float f;
        float f1;
        float f2;
        if (source.m_269533_(DamageTypeTags.f_268437_)) {
            return value;
        }
        if (entity.m_21023_(MobEffects.f_19606_) && !source.m_269533_(DamageTypeTags.f_268630_) && (f2 = (f1 = value) - (value = Math.max((f = value * (float)(j = 25 - (k = Mth.m_14045_((int)(entity.m_21124_(MobEffects.f_19606_).m_19564_() + 1), (int)0, (int)4) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (entity instanceof ServerPlayer) {
                ((ServerPlayer)entity).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12934_), Math.round(f2 * 10.0f));
            } else if (source.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7639_()).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12930_), Math.round(f2 * 10.0f));
            }
        }
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (source.m_269533_(DamageTypeTags.f_268413_)) {
            return value;
        }
        k = EnchantmentHelper.m_44856_((Iterable)entity.m_6168_(), (DamageSource)source);
        if (k > 0) {
            value = CombatRules.m_19269_((float)value, (float)k);
        }
        return value;
    }

    public static float getTrueHealth(LivingEntity entity) {
        if (!TRUE_GETHEALTH_CACHE.containsKey(entity.getClass())) {
            for (Method method : ClassUtil.getAllDeclaredMethods(LivingEntity.class)) {
                try {
                    method.setAccessible(true);
                    if (!method.getName().toLowerCase().contains("get") || !FormattingUtil.isHealth(method.getName()) || method.getName().equalsIgnoreCase("gethealth") || method.getParameterCount() != 0 || method.getReturnType() != Float.TYPE) continue;
                    AccessChecker.performPrivilegedAction(() -> TRUE_GETHEALTH_CACHE.putIfAbsent(entity.getClass(), method));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (TRUE_GETHEALTH_CACHE.containsKey(entity.getClass())) {
            Method method = (Method)TRUE_GETHEALTH_CACHE.get(entity.getClass());
            try {
                method.setAccessible(true);
                return ((Float)method.invoke((Object)entity, new Object[0])).floatValue();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return entity.m_21223_();
    }

    public static void forceSetHealth(LivingEntity entity, float value) {
        entity.m_21153_(value);
        if (!MathsUtil.approxEquals(EntityUtil.getTrueHealth(entity), value)) {
            EntityUtil.forceSetEntityData(entity.m_20088_(), LivingEntity.f_20961_, Float.valueOf(value));
            if (!MathsUtil.approxEquals(EntityUtil.getTrueHealth(entity), value)) {
                EntityUtil.setAllSyncedHealthData(entity, value);
                EntityUtil.setAllHealthFields(entity, value);
                EntityUtil.runSetHealthMethods(entity, value);
            }
        }
    }

    public static void setAllSyncedHealthData(LivingEntity entity, float value) {
        entity.m_20088_().f_135345_.forEach((integer, dataItem) -> {
            EntityDataAccessor entityDataAccessor = dataItem.m_135396_();
            try {
                EntityDataAccessor accessor = entityDataAccessor;
                if (MathsUtil.approxEquals(((Float)entity.m_20088_().m_135370_(accessor)).floatValue(), entity.m_21223_())) {
                    EntityUtil.forceSetEntityData(entity.m_20088_(), accessor, Float.valueOf(value));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
    }

    public static <T> void forceSetEntityData(SynchedEntityData entityData, EntityDataAccessor<T> entityDataAccessor, T t) {
        SynchedEntityData.DataItem dataitem = entityData.m_135379_(entityDataAccessor);
        if (ObjectUtils.notEqual(t, (Object)dataitem.m_135403_())) {
            dataitem.m_135397_(t);
            entityData.f_135344_.m_7350_(entityDataAccessor);
            dataitem.m_135401_(true);
            entityData.f_135348_ = true;
        }
    }

    public static void setAllHealthFields(LivingEntity entity, float value) {
        if (!FIELD_CACHE.containsKey(entity.getClass())) {
            AccessChecker.performPrivilegedAction(() -> FIELD_CACHE.putIfAbsent(entity.getClass(), new ArrayList()));
            for (Field field : ClassUtil.getAllDeclaredFields(entity.getClass())) {
                try {
                    field.setAccessible(true);
                    if (!FormattingUtil.isHealth(field.getName()) && !MathsUtil.approxEquals(field.getFloat(entity), entity.m_21223_()) || FIELD_CACHE.get(entity.getClass()) == null) continue;
                    ((List)FIELD_CACHE.get(entity.getClass())).add(field);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
        for (Field field : (List)FIELD_CACHE.get(entity.getClass())) {
            try {
                field.setAccessible(true);
                if (field.getType() == Float.TYPE) {
                    field.setFloat(entity, value);
                    continue;
                }
                if (field.getType() == Double.TYPE) {
                    field.setDouble(entity, value);
                    continue;
                }
                if (field.getType() == Integer.TYPE) {
                    field.setInt(entity, (int)value);
                    continue;
                }
                if (field.getType() == Long.TYPE) {
                    field.setLong(entity, (long)value);
                    continue;
                }
                if (field.getType() == Byte.TYPE) {
                    field.setByte(entity, (byte)value);
                    continue;
                }
                if (field.getType() != Short.TYPE) continue;
                field.setShort(entity, (short)value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
        if (!Thread.currentThread().getName().contains("Render")) {
            PacketHandler.sendToClient(new S2CSyncSetFloatField(value, entity.m_19879_()));
        }
    }

    public static void runSetHealthMethods(LivingEntity entity, float value) {
        if (!METHOD_CACHE.containsKey(entity.getClass())) {
            AccessChecker.performPrivilegedAction(() -> METHOD_CACHE.putIfAbsent(entity.getClass(), new ArrayList()));
            for (Method method : ClassUtil.getAllDeclaredMethods(entity.getClass())) {
                try {
                    method.setAccessible(true);
                    if (!method.getName().toLowerCase().contains("set") || !FormattingUtil.isHealth(method.getName())) continue;
                    ((List)METHOD_CACHE.get(entity.getClass())).add(method);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        for (Method method : (List)METHOD_CACHE.get(entity.getClass())) {
            try {
                method.setAccessible(true);
                method.invoke((Object)entity, Float.valueOf(value));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
    }

    public static void forceSetRemoved(Entity entity, Entity.RemovalReason reason) {
        if (entity.f_146795_ == null) {
            entity.f_146795_ = reason;
        }
        entity.f_146801_.m_142472_(reason);
        entity.m_20197_().forEach(Entity::m_8127_);
        entity.invalidateCaps();
    }

    public static void forceRemove(Entity entity, Entity.RemovalReason reason) {
        EntityUtil.forceRemoveNoPacket(entity, reason, true);
        PacketHandler.sendToClient(new S2CSyncDespawn(entity.m_19879_(), true));
    }

    public static void forceRemoveNoLeaveLevelCalls(Entity entity, Entity.RemovalReason reason) {
        EntityUtil.forceRemoveNoPacket(entity, reason, false);
        PacketHandler.sendToClient(new S2CSyncDespawn(entity.m_19879_(), false));
    }

    public static void forceRemoveNoPacket(Entity entity, Entity.RemovalReason reason, boolean leaveLevelCalls) {
        if (leaveLevelCalls) {
            EntityUtil.runRemoveMethods(entity);
            EntityUtil.forceSetRemoved(entity, reason);
        }
        EntityRemovalUtil.deleteEntity(entity, entity.m_9236_(), leaveLevelCalls);
    }

    public static void runRemoveMethods(Entity entity) {
        for (Method method : ClassUtil.getAllDeclaredMethods(entity.getClass())) {
            try {
                method.setAccessible(true);
                if (!method.getName().toLowerCase().contains("set") && !method.getName().toLowerCase().contains("start") || !FormattingUtil.isRemove(method.getName())) continue;
                method.invoke((Object)entity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public static void forceSetPos(Entity entity, Vec3 position) {
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        if (entity.f_19825_.f_82479_ != x || entity.f_19825_.f_82480_ != y || entity.f_19825_.f_82481_ != z) {
            entity.f_19825_ = new Vec3(x, y, z);
            int i = Mth.m_14107_((double)x);
            int j = Mth.m_14107_((double)y);
            int k = Mth.m_14107_((double)z);
            if (i != entity.f_19826_.m_123341_() || j != entity.f_19826_.m_123342_() || k != entity.f_19826_.m_123343_()) {
                entity.f_19826_ = new BlockPos(i, j, k);
                entity.f_185934_ = null;
                if (SectionPos.m_123171_((int)i) != entity.f_185933_.f_45578_ || SectionPos.m_123171_((int)k) != entity.f_185933_.f_45579_) {
                    entity.f_185933_ = new ChunkPos(entity.f_19826_);
                }
            }
            entity.f_146801_.m_142044_();
        }
        if (entity.isAddedToWorld() && !entity.m_9236_().f_46443_ && !entity.m_213877_()) {
            entity.m_9236_().m_6325_((int)Math.floor(x) >> 4, (int)Math.floor(z) >> 4);
        }
        entity.m_20011_(entity.m_142242_());
    }

    public static void forceSetDeltaMovement(Entity entity, Vec3 vec3) {
        entity.f_19827_ = vec3;
        if (entity instanceof Player && !entity.m_9236_().m_5776_()) {
            PacketHandler.sendToClient(new S2CSyncPlayerSetDeltaMovement(entity.m_19879_(), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()));
        }
    }

    public static void forceSetDeltaMovement(Entity entity, double x, double y, double z) {
        EntityUtil.forceSetDeltaMovement(entity, new Vec3(x, y, z));
    }

    public static void cameraShake(float intensity, double x, double y, double z, Level level) {
        CameraShakeEntity cameraShake = new CameraShakeEntity((EntityType)EntityInit.CAMERA_SHAKE.get(), level, intensity);
        cameraShake.m_6027_(x, y, z);
        level.m_7967_((Entity)cameraShake);
    }

    public static double distanceToEntityWithHitboxes(Entity entity1, Entity entity2) {
        return MathsUtil.distance(entity1.m_20185_(), entity1.m_20186_(), entity1.m_20189_(), entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_()) - (double)(entity1.m_20205_() / 2.0f) - (double)(entity2.m_20205_() / 2.0f);
    }

    public static void explosionVfx(float size, int time, Vec3 position, @Nullable Vec3 colour, Level level, boolean billboard) {
        ExplosionRender explosionRender = new ExplosionRender((EntityType)EntityInit.EXPLOSION_RENDER.get(), level);
        explosionRender.m_20219_(position);
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_SIZE, (Object)Float.valueOf(size));
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_TIME, (Object)time);
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_TIMER, (Object)time);
        if (colour != null) {
            explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_COLOUR, (Object)new Vector3f((float)colour.f_82479_, (float)colour.f_82480_, (float)colour.f_82481_));
        }
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_IS_BILLBOARD, (Object)billboard);
        level.m_7967_((Entity)explosionRender);
    }

    public static void explosionVfx(float size, int time, Vec3 position, @Nullable Vec3 colour, Level level) {
        EntityUtil.explosionVfx(size, time, position, colour, level, false);
    }

    public static void metaExplosionVfx(float size, int time, Vec3 position, boolean billboard, Level level) {
        ExplosionRender explosionRender = new ExplosionRender((EntityType)EntityInit.EXPLOSION_RENDER.get(), level);
        explosionRender.m_20219_(position);
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_SIZE, (Object)Float.valueOf(size));
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_TIME, (Object)time);
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_TIMER, (Object)time);
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_COLOUR, (Object)new Vector3f(MetapotentFlashfur.lightBlue[0] * 255.0f, MetapotentFlashfur.lightBlue[1] * 255.0f, MetapotentFlashfur.lightBlue[2] * 255.0f));
        explosionRender.m_20088_().m_135381_(ExplosionRender.DATA_IS_BILLBOARD, (Object)billboard);
        explosionRender.isMeta = true;
        level.m_7967_((Entity)explosionRender);
    }

    public static void addDeltaMovementWithKnockbackResistance(LivingEntity entity, Vec3 movement) {
        double x = 1.0 - Mth.m_14008_((double)entity.m_21133_(Attributes.f_22278_), (double)0.0, (double)0.9);
        EntityUtil.forceSetDeltaMovement((Entity)entity, entity.m_20184_().m_82549_(movement.m_82490_(x)));
    }

    public static void addDeltaMovementWithKnockbackResistance(LivingEntity entity, double x, double y, double z) {
        EntityUtil.addDeltaMovementWithKnockbackResistance(entity, new Vec3(x, y, z));
    }

    public static void forceAddEntity(Entity entity, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.f_143244_.addNewEntityWithoutEvent((EntityAccess)entity);
            entity.onAddedToWorld();
        }
    }
}

