/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.api.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.enchantment.effect.ModifySubmergedMovementSpeedEffect;
import moriyashiine.enchancement.common.enchantment.effect.RageEffect;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1753;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public interface MultiplyMovementSpeedEvent {
    public static final int MAXIMUM_MOVEMENT_MULTIPLIER = 2;
    public static final Event<MultiplyMovementSpeedEvent> EVENT = EventFactory.createArrayBacked(MultiplyMovementSpeedEvent.class, listeners -> (currentMultiplier, world, living) -> {
        ArrayList<MultiplyMovementSpeedEvent> events = new ArrayList<MultiplyMovementSpeedEvent>(Arrays.asList(listeners));
        events.sort(Comparator.comparingInt(MultiplyMovementSpeedEvent::getPriority));
        for (MultiplyMovementSpeedEvent event : events) {
            currentMultiplier = event.multiply(currentMultiplier, world, living);
        }
        return currentMultiplier;
    });

    public float multiply(float var1, class_1937 var2, class_1309 var3);

    default public int getPriority() {
        return 1000;
    }

    public static float capMovementMultiplier(float multiplier) {
        return Math.min(2.0f, multiplier);
    }

    public static float getJumpStrength(class_1309 entity, float multiplier) {
        double jumpRatio = (double)entity.method_6106() / entity.method_45326(class_5134.field_23728);
        double speedRatio = entity.method_45325(class_5134.field_23719) / entity.method_45326(class_5134.field_23719);
        if (entity.method_5624()) {
            speedRatio /= 1.3;
        }
        return (float)(class_3532.method_15350((double)(jumpRatio * Math.min(1.0, speedRatio)), (double)0.6666666865348816, (double)1.2f) * entity.method_45325(class_5134.field_23728) * (double)multiplier);
    }

    public static float getMovementMultiplier(class_1309 entity) {
        double multiplier = 1.0f + ModifySubmergedMovementSpeedEffect.getValue(entity);
        multiplier *= (double)RageEffect.getMovementSpeedModifier(entity);
        if (entity.method_6115()) {
            multiplier = ModConfig.rebalanceEquipment && entity.method_6030().method_7909() instanceof class_1753 ? (multiplier *= (double)0.6f) : (multiplier *= 0.2);
        }
        if (entity.method_5624()) {
            multiplier /= 1.3;
        }
        multiplier = Math.min(2.0, multiplier);
        return (float)class_3532.method_15350((double)(entity.method_45325(class_5134.field_23719) * multiplier / entity.method_45326(class_5134.field_23719)), (double)0.6666666865348816, (double)1.2f);
    }
}

