/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.common.component.entity.WallJumpComponent;
import moriyashiine.enchancement.common.enchantment.effect.AirJumpEffect;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.AirJumpPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class AirJumpComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private boolean shouldRefresh = false;
    private int cooldown = 0;
    private int lastCooldown = 0;
    private int jumpCooldown = 10;
    private int jumpsLeft = 0;
    private int ticksInAir = 0;
    private int maxJumps = 0;
    private boolean hasAirJump = false;
    private boolean wasJumping = false;

    public AirJumpComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.shouldRefresh = readView.method_71433("ShouldRefresh", false);
        this.cooldown = readView.method_71424("Cooldown", 0);
        this.lastCooldown = readView.method_71424("LastCooldown", 0);
        this.jumpCooldown = readView.method_71424("JumpCooldown", 0);
        this.jumpsLeft = readView.method_71424("JumpsLeft", 0);
        this.ticksInAir = readView.method_71424("TicksInAir", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("ShouldRefresh", this.shouldRefresh);
        writeView.method_71465("Cooldown", this.cooldown);
        writeView.method_71465("LastCooldown", this.lastCooldown);
        writeView.method_71465("JumpCooldown", this.jumpCooldown);
        writeView.method_71465("JumpsLeft", this.jumpsLeft);
        writeView.method_71465("TicksInAir", this.ticksInAir);
    }

    public void tick() {
        int entityCooldown = AirJumpEffect.getChargeCooldown((class_1309)this.obj);
        this.maxJumps = AirJumpEffect.getAirJumps((class_1309)this.obj);
        boolean bl = this.hasAirJump = this.maxJumps > 0;
        if (this.hasAirJump) {
            if (!this.shouldRefresh) {
                if (this.obj.method_24828()) {
                    this.shouldRefresh = true;
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
                if (this.cooldown == 0 && this.jumpsLeft < this.maxJumps) {
                    ++this.jumpsLeft;
                    this.setCooldown(entityCooldown);
                }
            }
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            }
            this.ticksInAir = this.obj.method_24828() ? 0 : ++this.ticksInAir;
        } else {
            this.shouldRefresh = false;
            this.setCooldown(0);
            this.jumpCooldown = 0;
            this.jumpsLeft = 0;
            this.ticksInAir = 0;
        }
        if (((WallJumpComponent)ModEntityComponents.WALL_JUMP.get((Object)this.obj)).isSliding()) {
            this.jumpCooldown = AirJumpEffect.getJumpCooldown((class_1309)this.obj);
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasAirJump && this.obj.field_6282 && !this.wasJumping && this.canUse()) {
            this.use();
            SLibClientUtils.addParticles((class_1297)this.obj, (class_2396)class_2398.field_11204, (int)8, (ParticleAnchor)ParticleAnchor.BASE);
            AirJumpPayload.send();
        }
        this.wasJumping = this.obj.field_6282;
    }

    public void sync() {
        ModEntityComponents.AIR_JUMP.sync((Object)this.obj);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    private void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.lastCooldown = cooldown;
    }

    public int getLastCooldown() {
        return this.lastCooldown;
    }

    public int getJumpsLeft() {
        return this.jumpsLeft;
    }

    public int getMaxJumps() {
        return this.maxJumps;
    }

    public boolean hasAirJump() {
        return this.hasAirJump;
    }

    public boolean canUse() {
        return this.jumpCooldown == 0 && this.jumpsLeft > 0 && this.ticksInAir >= 5 && !this.obj.method_24828() && SLibUtils.isGroundedOrAirborne((class_1309)this.obj);
    }

    public void use() {
        if (this.cooldown == 0 || this.jumpsLeft == this.maxJumps) {
            this.setCooldown(AirJumpEffect.getChargeCooldown((class_1309)this.obj));
        }
        this.shouldRefresh = false;
        this.jumpCooldown = AirJumpEffect.getJumpCooldown((class_1309)this.obj);
        --this.jumpsLeft;
        this.obj.method_18800(this.obj.method_18798().method_10216(), (double)MultiplyMovementSpeedEvent.getJumpStrength((class_1309)this.obj, AirJumpEffect.getAirJumpStrength((class_1309)this.obj)), this.obj.method_18798().method_10215());
        if (this.obj.method_5624()) {
            float rad = (float)Math.toRadians(this.obj.method_36454());
            this.obj.method_45319(new class_243((double)(-class_3532.method_15374((float)rad)) * 0.2, 0.0, (double)class_3532.method_15362((float)rad) * 0.2));
        }
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_AIR_JUMP, 1.0f, 1.0f);
        this.obj.method_32876((class_6880)class_5712.field_45148);
        EnchancementUtil.resetFallDistance((class_1297)this.obj);
    }

    public void reset() {
        this.setCooldown(AirJumpEffect.getChargeCooldown((class_1309)this.obj));
        this.jumpsLeft = 0;
    }
}

