/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import moriyashiine.enchancement.common.enchantment.effect.LeechingTridentEffect;
import moriyashiine.enchancement.common.init.ModDamageTypes;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class LeechingTridentComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private static final int NO_ENTITY = -1;
    private final class_1685 obj;
    private LeechData leechData = null;
    private class_1309 stuckEntity = null;
    private int stuckEntityId = -1;
    private int leechingTicks = 0;
    private int stabTicks = 0;

    public LeechingTridentComponent(class_1685 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.leechData = readView.method_71426("LeechData", LeechData.CODEC).orElse(null);
        this.stuckEntityId = readView.method_71424("StuckEntityId", -1);
        this.leechingTicks = readView.method_71424("LeechingTicks", 0);
        this.stabTicks = readView.method_71424("StabTicks", 0);
    }

    public void writeData(class_11372 writeView) {
        if (this.leechData != null) {
            writeView.method_71468("LeechData", LeechData.CODEC, (Object)this.leechData);
        }
        writeView.method_71465("StuckEntityId", this.stuckEntityId);
        writeView.method_71465("LeechingTicks", this.leechingTicks);
        writeView.method_71465("StabTicks", this.stabTicks);
    }

    public void tick() {
        class_1297 class_12972;
        if (this.stuckEntityId == -1) {
            if (this.stuckEntity != null) {
                this.setStuckEntity(null);
            }
        } else if (this.stuckEntity == null && (class_12972 = this.obj.method_73183().method_8469(this.stuckEntityId)) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            this.setStuckEntity(living);
        }
        if (this.stuckEntity != null && this.stuckEntity.method_36608()) {
            this.obj.method_24203(this.stuckEntity.method_23317(), this.stuckEntity.method_23320(), this.stuckEntity.method_23321());
            this.obj.method_18799(class_243.field_1353);
            ++this.leechingTicks;
            if (this.stabTicks > 0) {
                --this.stabTicks;
            }
        }
    }

    public void serverTick() {
        this.tick();
        if (this.stuckEntity != null && this.stuckEntity.method_36608()) {
            if (this.leechingTicks % 20 == 0) {
                class_1309 living;
                class_1297 class_12972;
                int timeUntilRegen = this.stuckEntity.field_6008;
                this.stuckEntity.field_6008 = 0;
                if (this.stuckEntity.method_64397((class_3218)this.obj.method_73183(), this.obj.method_73183().method_48963().method_48797(ModDamageTypes.LIFE_DRAIN, (class_1297)this.obj, this.obj.method_24921()), this.leechData.damage()) && (class_12972 = this.obj.method_24921()) instanceof class_1309 && (living = (class_1309)class_12972).method_36608()) {
                    living.method_6025(this.leechData.healAmount());
                }
                this.stuckEntity.field_6008 = timeUntilRegen;
                this.stabTicks = 20;
                this.sync();
            }
            if (this.leechingTicks >= this.leechData.maxTicks()) {
                this.unleech();
            }
        } else if (this.stuckEntityId != -1) {
            this.unleech();
        }
    }

    public void clientTick() {
        this.tick();
        if (this.stuckEntity != null && this.stuckEntity.method_36608() && this.stabTicks == 19) {
            SLibClientUtils.addParticles((class_1297)this.stuckEntity, (class_2396)class_2398.field_11209, (int)5, (ParticleAnchor)ParticleAnchor.BODY);
        }
    }

    public void sync() {
        ModEntityComponents.LEECHING_TRIDENT.sync((Object)this.obj);
    }

    public boolean hasLeech() {
        return this.leechData != null;
    }

    public class_1309 getStuckEntity() {
        return this.stuckEntity;
    }

    public void setStuckEntity(@Nullable class_1309 stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckEntityId = stuckEntity == null ? -1 : stuckEntity.method_5628();
    }

    public int getLeechingTicks() {
        return this.leechingTicks;
    }

    public int getStabTicks() {
        return this.stabTicks;
    }

    public void unleech() {
        this.stuckEntityId = -1;
        this.leechingTicks = 0;
        this.stabTicks = 0;
        this.sync();
    }

    public static void maybeSet(class_1309 user, class_1799 stack, class_1297 entity) {
        if (entity instanceof class_1685) {
            MutableFloat damage = new MutableFloat();
            MutableFloat healAmount = new MutableFloat();
            MutableFloat duration = new MutableFloat();
            if (class_1890.method_60142((class_1799)stack, ModEnchantmentEffectComponentTypes.LEECHING_TRIDENT)) {
                LeechingTridentEffect.setValues(user.method_59922(), damage, healAmount, duration, Collections.singleton(stack));
            } else if (!(user instanceof class_1657) && EnchancementUtil.hasAnyEnchantmentsWith((class_1297)user, ModEnchantmentEffectComponentTypes.LEECHING_TRIDENT)) {
                LeechingTridentEffect.setValues(user.method_59922(), damage, healAmount, duration, EnchancementUtil.getHeldItems(user));
            }
            if (damage.floatValue() != 0.0f) {
                LeechingTridentComponent leechingTridentComponent = (LeechingTridentComponent)ModEntityComponents.LEECHING_TRIDENT.get((Object)entity);
                leechingTridentComponent.leechData = new LeechData(damage.floatValue(), healAmount.floatValue(), class_3532.method_15375((float)(duration.floatValue() * 20.0f)));
                leechingTridentComponent.sync();
            }
        }
    }

    public record LeechData(float damage, float healAmount, int maxTicks) {
        public static final Codec<LeechData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("damage").forGetter(LeechData::damage), (App)Codec.FLOAT.fieldOf("heal_amount").forGetter(LeechData::healAmount), (App)Codec.INT.fieldOf("max_ticks").forGetter(LeechData::maxTicks)).apply((Applicative)instance, LeechData::new));
    }
}

