/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.common.component.entity.SlideComponent;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModParticleTypes;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.StartSlammingC2SPayload;
import moriyashiine.enchancement.common.payload.StopSlammingC2SPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import moriyashiine.strawberrylib.api.objects.records.ParticleVelocity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5691;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class SlamComponent
implements CommonTickingComponent {
    public static final int DEFAULT_SLAM_COOLDOWN = 7;
    private final class_1657 obj;
    private boolean isSlamming = false;
    private int slamCooldown = 7;
    private int ticksLeftToJump = 0;
    private float strength = 0.0f;
    private boolean hasSlam = false;
    private boolean wasPressingKey = false;

    public SlamComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.isSlamming = readView.method_71433("IsSlamming", false);
        this.slamCooldown = readView.method_71424("SlamCooldown", 0);
        this.ticksLeftToJump = readView.method_71424("TicksLeftToJump", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("IsSlamming", this.isSlamming);
        writeView.method_71465("SlamCooldown", this.slamCooldown);
        writeView.method_71465("TicksLeftToJump", this.ticksLeftToJump);
    }

    public void tick() {
        this.strength = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.SLAM, (class_1309)this.obj, 0.0f);
        boolean bl = this.hasSlam = this.strength > 0.0f;
        if (this.hasSlam) {
            if (this.isSlamming) {
                if (!SLibUtils.isGroundedOrAirborne((class_1309)this.obj, (boolean)true)) {
                    this.isSlamming = false;
                    return;
                }
                this.obj.method_18800(this.obj.method_18798().method_10216() * 0.98, Math.min(-3.0, this.obj.method_18798().method_10214()), this.obj.method_18798().method_10215() * 0.98);
                EnchancementUtil.resetFallDistance((class_1297)this.obj);
            }
            if (this.slamCooldown > 0) {
                --this.slamCooldown;
            }
            if (this.ticksLeftToJump > 0) {
                --this.ticksLeftToJump;
            }
        } else {
            this.isSlamming = false;
            this.slamCooldown = 7;
            this.ticksLeftToJump = 0;
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasSlam) {
            if (this.isSlamming) {
                SLibClientUtils.addParticles((class_1297)this.obj, (class_2396)ModParticleTypes.VELOCITY_LINE, (int)4, (ParticleAnchor)ParticleAnchor.BODY, (ParticleVelocity)ParticleVelocity.of((class_243)new class_243(0.0, 1.0, 0.0)));
            }
            if (!this.obj.method_7325() && SLibClientUtils.isHost((class_1297)this.obj)) {
                boolean pressingKey;
                if (this.isSlamming && this.obj.method_24828()) {
                    this.stopSlammingClient(this.obj.method_23318());
                    StopSlammingC2SPayload.send(this.obj.method_23318());
                }
                if ((pressingKey = EnchancementClient.SLAM_KEYBINDING.method_1434()) && !this.wasPressingKey && this.canSlam()) {
                    this.isSlamming = true;
                    this.slamCooldown = 7;
                    StartSlammingC2SPayload.send();
                }
                this.wasPressingKey = pressingKey;
            }
        }
    }

    public void setSlamming(boolean slamming) {
        this.isSlamming = slamming;
    }

    public boolean isSlamming() {
        return this.isSlamming;
    }

    public void setSlamCooldown(int slamCooldown) {
        this.slamCooldown = slamCooldown;
    }

    public float getJumpBoostStrength() {
        if (this.ticksLeftToJump > 0) {
            return MultiplyMovementSpeedEvent.getJumpStrength((class_1309)this.obj, (1.0f + this.strength) / this.obj.method_6106());
        }
        return 1.0f;
    }

    public boolean hasSlam() {
        return this.hasSlam;
    }

    public boolean canSlam() {
        SlideComponent slideComponent = (SlideComponent)ModEntityComponents.SLIDE.getNullable((Object)this.obj);
        if (slideComponent != null && slideComponent.isSliding()) {
            return false;
        }
        return this.slamCooldown == 0 && !this.obj.method_24828() && SLibUtils.isGroundedOrAirborne((class_1309)this.obj);
    }

    private void stopSlamming() {
        this.isSlamming = false;
        this.ticksLeftToJump = 5;
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_IMPACT, 1.0f, 1.0f);
    }

    public void stopSlammingServer() {
        this.stopSlamming();
        this.obj.method_73183().method_8333((class_1297)this.obj, new class_238(this.obj.method_24515()).method_1009(3.0, 1.0, 3.0), foundEntity -> foundEntity.method_5805() && foundEntity.method_5739((class_1297)this.obj) < 5.0f).forEach(foundEntity -> {
            class_1309 living;
            if (foundEntity instanceof class_1309 && SLibUtils.shouldHurt((class_1297)this.obj, (class_1297)(living = (class_1309)foundEntity)) && SLibUtils.canSee((class_1297)this.obj, (class_1297)foundEntity, (int)0)) {
                living.method_6005(1.0, this.obj.method_23317() - living.method_23317(), this.obj.method_23321() - living.method_23321());
            }
        });
        this.obj.method_73183().method_32888((class_6880)class_5712.field_28155, this.obj.method_73189(), class_5712.class_7397.method_43287((class_2680)this.obj.method_25936()));
        class_2680 state = this.obj.method_73183().method_8320(this.obj.method_43260());
        if (state.method_28498((class_2769)class_2741.field_28063) && state.method_28498((class_2769)class_2741.field_28062) && state.method_11654((class_2769)class_2741.field_28063) == class_5691.field_28065 && state.method_11654((class_2769)class_2741.field_28062) == class_2350.field_11036) {
            this.obj.method_64397((class_3218)this.obj.method_73183(), this.obj.method_48923().method_48837(), 2.1474836E9f);
        }
    }

    public void stopSlammingClient(double posY) {
        this.stopSlamming();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        double y = Math.round(posY - 1.0);
        for (int i = 0; i < 360; i += 15) {
            for (int j = 1; j < 5; ++j) {
                double x = this.obj.method_23317() + (double)(class_3532.method_15374((float)i) * (float)j / 2.0f);
                double z = this.obj.method_23321() + (double)(class_3532.method_15362((float)i) * (float)j / 2.0f);
                class_2680 state = this.obj.method_73183().method_8320((class_2338)mutable.method_10102(x, y, z));
                if (state.method_45474() || !this.obj.method_73183().method_8320((class_2338)mutable.method_10098(class_2350.field_11036)).method_45474()) continue;
                this.obj.method_73183().method_8406((class_2394)new class_2388(class_2398.field_11217, state), x, (double)mutable.method_10264(), z, 0.0, 0.0, 0.0);
            }
        }
    }
}

