/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.common.Enchancement;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModParticleTypes;
import moriyashiine.enchancement.common.payload.StartSlidingC2SPayload;
import moriyashiine.enchancement.common.payload.StopSlidingC2SPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.joml.Vector2d;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class SlideComponent
implements CommonTickingComponent {
    private static final class_1322 SAFE_FALL_DISTANCE_MODIFIER = new class_1322(Enchancement.id("slide_safe_fall_distance"), 6.0, class_1322.class_1323.field_6328);
    private static final class_1322 STEP_HEIGHT_MODIFIER = new class_1322(Enchancement.id("slide_step_height"), 1.0, class_1322.class_1323.field_6328);
    private static final int MAX_SLIDING_TICKS = 40;
    private static final int MAX_WATER_SKIP_TICKS = 30;
    private final class_1657 obj;
    private SlideVelocity velocity = SlideVelocity.ZERO;
    private SlideVelocity adjustedVelocity = SlideVelocity.ZERO;
    private float cachedYaw = 0.0f;
    private int slidingTicks = 0;
    private float strength = 0.0f;
    private boolean hasSlide = false;
    private int crawlTimer = 0;
    private int waterSkipTicks = 0;

    public SlideComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.velocity = readView.method_71426("Velocity", SlideVelocity.CODEC).orElse(SlideVelocity.ZERO);
        this.adjustedVelocity = readView.method_71426("AdjustedVelocity", SlideVelocity.CODEC).orElse(SlideVelocity.ZERO);
        this.cachedYaw = readView.method_71423("CachedYaw", 0.0f);
        this.slidingTicks = readView.method_71424("SlidingTicks", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71468("Velocity", SlideVelocity.CODEC, (Object)this.velocity);
        writeView.method_71468("AdjustedVelocity", SlideVelocity.CODEC, (Object)this.adjustedVelocity);
        writeView.method_71464("CachedYaw", this.cachedYaw);
        writeView.method_71465("SlidingTicks", this.slidingTicks);
    }

    public void tick() {
        boolean hasFluidWalking = EnchancementUtil.hasAnyEnchantmentsWith((class_1297)this.obj, ModEnchantmentEffectComponentTypes.FLUID_WALKING);
        this.strength = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.SLIDE, (class_1309)this.obj, 0.0f);
        boolean bl = this.hasSlide = this.strength > 0.0f;
        if (this.crawlTimer > 0) {
            --this.crawlTimer;
        }
        if (this.hasSlide) {
            if (this.waterSkipTicks >= 30 || this.obj.method_5715() || !this.obj.method_36608() || this.obj.method_5799() && !hasFluidWalking) {
                this.stopSliding();
            }
            if (this.isSliding()) {
                if (this.updateCrawl()) {
                    this.crawlTimer = 3;
                }
                this.obj.method_5839();
                double dX = this.adjustedVelocity.x();
                double dZ = this.adjustedVelocity.z();
                if (!this.obj.method_24828()) {
                    dX *= 0.2;
                    dZ *= 0.2;
                }
                float multiplier = MultiplyMovementSpeedEvent.getMovementMultiplier((class_1309)this.obj);
                this.obj.method_5762(dX * (double)(multiplier *= 1.0f - (float)this.waterSkipTicks / 60.0f), 0.0, dZ * (double)multiplier);
                if (this.obj.method_5799() && hasFluidWalking) {
                    this.obj.method_18800(this.obj.method_18798().method_10216(), (double)this.strength, this.obj.method_18798().method_10215());
                    ++this.waterSkipTicks;
                }
                if (this.slidingTicks < 40) {
                    ++this.slidingTicks;
                }
            } else {
                if (this.slidingTicks > 0) {
                    this.slidingTicks = Math.max(0, this.slidingTicks - 4);
                }
                this.waterSkipTicks = 0;
            }
        } else {
            this.stopSliding();
            this.slidingTicks = 0;
            this.waterSkipTicks = 0;
        }
    }

    public void serverTick() {
        this.tick();
        class_1324 safeFallDistanceAttribute = this.obj.method_5996(class_5134.field_49079);
        class_1324 stepHeightAttribute = this.obj.method_5996(class_5134.field_47761);
        if (this.hasSlide && this.isSliding()) {
            if (!safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER.comp_2447())) {
                safeFallDistanceAttribute.method_26837(SAFE_FALL_DISTANCE_MODIFIER);
            }
            if (!stepHeightAttribute.method_6196(STEP_HEIGHT_MODIFIER.comp_2447())) {
                stepHeightAttribute.method_26837(STEP_HEIGHT_MODIFIER);
            }
        } else {
            if (safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER.comp_2447())) {
                safeFallDistanceAttribute.method_6202(SAFE_FALL_DISTANCE_MODIFIER);
            }
            if (stepHeightAttribute.method_6196(STEP_HEIGHT_MODIFIER.comp_2447())) {
                stepHeightAttribute.method_6202(STEP_HEIGHT_MODIFIER);
            }
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasSlide) {
            if (!this.obj.method_7325() && SLibClientUtils.isHost((class_1297)this.obj)) {
                class_315 options = class_310.method_1551().field_1690;
                if (EnchancementClient.SLIDE_KEYBINDING.method_1434() && !this.obj.method_5715() && !this.obj.field_6282) {
                    if (this.canSlide()) {
                        this.velocity = this.getVelocityFromInput(options);
                        this.adjustedVelocity = this.velocity.rotateY((float)Math.toRadians(-(this.obj.method_36454() + 90.0f)));
                        this.cachedYaw = this.obj.method_36454();
                        StartSlidingC2SPayload.send(this.velocity, this.adjustedVelocity, this.cachedYaw);
                    }
                } else if (this.velocity != SlideVelocity.ZERO) {
                    this.stopSliding();
                    StopSlidingC2SPayload.send();
                }
            }
            if (this.isSliding() && SLibClientUtils.shouldAddParticles((class_1297)this.obj)) {
                Vector2d vec = new Vector2d((double)this.adjustedVelocity.x(), (double)this.adjustedVelocity.z());
                vec.normalize();
                vec.mul((double)(this.obj.method_17681() / 2.0f));
                this.obj.method_73183().method_8406((class_2394)ModParticleTypes.VELOCITY_LINE, this.obj.method_23317() - vec.y(), this.obj.method_23318() + (double)(this.obj.method_17682() / 2.0f) + (double)class_3532.method_15344((class_5819)this.obj.method_59922(), (float)(-this.obj.method_17682() / 3.0f), (float)(this.obj.method_17682() / 3.0f)), this.obj.method_23321() + vec.x(), (double)this.adjustedVelocity.x(), 0.0, (double)this.adjustedVelocity.z());
                this.obj.method_73183().method_8406((class_2394)ModParticleTypes.VELOCITY_LINE, this.obj.method_23317() + vec.y(), this.obj.method_23318() + (double)(this.obj.method_17682() / 2.0f) + (double)class_3532.method_15344((class_5819)this.obj.method_59922(), (float)(-this.obj.method_17682() / 3.0f), (float)(this.obj.method_17682() / 3.0f)), this.obj.method_23321() - vec.x(), (double)this.adjustedVelocity.x(), 0.0, (double)this.adjustedVelocity.z());
            }
        }
    }

    public SlideVelocity getVelocity() {
        return this.velocity;
    }

    public float getCachedYaw() {
        return this.cachedYaw;
    }

    public void startSliding(SlideVelocity velocity, SlideVelocity adjustedVelocity, float cachedYaw) {
        this.velocity = velocity;
        this.adjustedVelocity = adjustedVelocity;
        this.cachedYaw = cachedYaw;
    }

    public void stopSliding() {
        this.startSliding(SlideVelocity.ZERO, SlideVelocity.ZERO, 0.0f);
    }

    public boolean isSliding() {
        return !this.velocity.equals(SlideVelocity.ZERO);
    }

    public float getJumpBonus() {
        return class_3532.method_16439((float)((float)this.slidingTicks / 40.0f), (float)1.0f, (float)3.0f);
    }

    public boolean hasSlide() {
        return this.hasSlide;
    }

    public boolean shouldCrawl() {
        return this.crawlTimer > 0;
    }

    public boolean canSlide() {
        return !this.isSliding() && this.obj.method_24828() && SLibUtils.isGroundedOrAirborne((class_1309)this.obj);
    }

    private boolean hitsBlock(class_2338 pos) {
        return !this.obj.method_73183().method_8320(pos).method_26220((class_1922)this.obj.method_73183(), pos).method_1110();
    }

    private boolean updateCrawl() {
        int height = class_3532.method_15375((float)this.obj.method_17682());
        if (height > 0) {
            class_243 frontPos = this.obj.method_73189().method_1031(0.0, (double)height, 0.0).method_1019(this.obj.method_5631(0.0f, this.cachedYaw));
            class_2338.class_2339 pos = new class_2338.class_2339(frontPos.method_10216(), frontPos.method_10214(), frontPos.method_10215());
            int y = pos.method_10264();
            boolean hitsBelow = this.hitsBlock((class_2338)pos.method_33098(y - 1));
            if (this.hitsBlock((class_2338)pos.method_33098(y))) {
                return !hitsBelow;
            }
            if (hitsBelow) {
                return this.hitsBlock((class_2338)pos.method_33098(y + 1)) || this.hitsBlock(this.obj.method_24515().method_10086(height + 1));
            }
        }
        return false;
    }

    private SlideVelocity getVelocityFromInput(class_315 options) {
        boolean any = false;
        boolean forward = false;
        boolean sideways = false;
        int x = 0;
        int z = 0;
        if (options.field_1894.method_1434()) {
            any = true;
            forward = true;
            x = 1;
        }
        if (options.field_1881.method_1434()) {
            any = true;
            forward = true;
            x = -1;
        }
        if (options.field_1913.method_1434()) {
            any = true;
            sideways = true;
            z = -1;
        }
        if (options.field_1849.method_1434()) {
            any = true;
            sideways = true;
            z = 1;
        }
        return new SlideVelocity(any ? (float)x : 1.0f, z).multiply(forward && sideways ? 0.6666667f : 1.0f).multiply(this.strength);
    }

    public record SlideVelocity(float x, float z) {
        public static final Codec<SlideVelocity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(SlideVelocity::x), (App)Codec.FLOAT.fieldOf("z").forGetter(SlideVelocity::z)).apply((Applicative)instance, SlideVelocity::new));
        public static final class_9139<class_2540, SlideVelocity> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_48552, SlideVelocity::x, (class_9139)class_9135.field_48552, SlideVelocity::z, SlideVelocity::new);
        public static final SlideVelocity ZERO = new SlideVelocity(0.0f, 0.0f);

        SlideVelocity multiply(float value) {
            return new SlideVelocity(this.x() * value, this.z() * value);
        }

        SlideVelocity rotateY(float angle) {
            float cos = class_3532.method_15362((float)angle);
            float sin = class_3532.method_15374((float)angle);
            float nX = this.x() * cos + this.z() * sin;
            float nZ = this.z() * cos - this.x() * sin;
            return new SlideVelocity(nX, nZ);
        }
    }
}

