/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.common.Enchancement;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.payload.WallJumpPayload;
import moriyashiine.enchancement.common.payload.WallJumpSlidingPayload;
import moriyashiine.enchancement.common.tag.ModBlockTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4622;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class WallJumpComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private static final class_2960 SAFE_FALL_DISTANCE_ID = Enchancement.id("wall_jump_safe_fall_distance");
    private final class_1309 obj;
    private class_2338 slidingPos = null;
    private final class_2338.class_2339 mutable = new class_2338.class_2339();
    private float jumpStrength = 0.0f;
    private boolean hasJumped = false;

    public WallJumpComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.slidingPos = readView.method_71426("SlidingPos", class_2338.field_25064).orElse(null);
    }

    public void writeData(class_11372 writeView) {
        if (this.slidingPos != null) {
            writeView.method_71468("SlidingPos", class_2338.field_25064, (Object)this.slidingPos);
        }
    }

    public void tick() {
        this.jumpStrength = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.WALL_JUMP, this.obj, 0.0f);
        if (this.jumpStrength == 0.0f || this.obj.method_24828()) {
            this.slidingPos = null;
            this.hasJumped = false;
        } else if (this.slidingPos != null) {
            ((class_4622)class_2246.field_21211).method_24177(this.obj.method_73183(), (class_1297)this.obj);
            ((class_4622)class_2246.field_21211).method_24180((class_1297)this.obj);
        }
    }

    public void serverTick() {
        this.tick();
        class_1324 safeFallDistanceAttribute = this.obj.method_5996(class_5134.field_49079);
        if (this.hasJumped()) {
            if (!safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_ID)) {
                int reduction = class_3532.method_15375((float)(MultiplyMovementSpeedEvent.getJumpStrength(this.obj, this.jumpStrength * 3.0f) * 10.0f));
                safeFallDistanceAttribute.method_26837(new class_1322(SAFE_FALL_DISTANCE_ID, (double)reduction, class_1322.class_1323.field_6328));
            }
        } else if (safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_ID)) {
            safeFallDistanceAttribute.method_6200(SAFE_FALL_DISTANCE_ID);
        }
    }

    public void clientTick() {
        this.tick();
        class_2338 targetPos = null;
        if (this.jumpStrength != 0.0f) {
            if (this.obj.field_5976) {
                this.mutable.method_10102(this.obj.method_23317(), this.obj.method_23318(), this.obj.method_23321());
                for (class_2350 direction : class_2350.values()) {
                    if (!direction.method_10166().method_10179()) continue;
                    this.mutable.method_10098(direction);
                    class_2680 state = this.obj.method_73183().method_8320((class_2338)this.mutable);
                    if (!state.method_26164(ModBlockTags.UNSTICKABLE) && !state.method_26194((class_1922)this.obj.method_73183(), (class_2338)this.mutable, class_3726.method_16195((class_1297)this.obj)).method_1110() && !this.obj.method_24828() && this.obj.method_18798().method_10214() < -0.1) {
                        double mutableDistance = this.mutable.method_19770((class_2374)this.obj.method_73189());
                        if (targetPos != null && mutableDistance == targetPos.method_19770((class_2374)this.obj.method_73189())) {
                            class_2338 p1 = this.mutable.method_10093(direction.method_10170());
                            class_2338 p2 = this.mutable.method_10093(direction.method_10160());
                            targetPos = p1.method_19770((class_2374)this.obj.method_73189()) < p2.method_19770((class_2374)this.obj.method_73189()) ? p1 : p2;
                        } else if (targetPos == null || mutableDistance < targetPos.method_19770((class_2374)this.obj.method_73189())) {
                            targetPos = this.mutable.method_10062();
                        }
                    }
                    this.mutable.method_10098(direction.method_10153());
                }
            }
            if (this.slidingPos != null) {
                class_1309 class_13092;
                class_1309 class_13093 = this.obj.method_5642();
                if (class_13093 instanceof class_1657) {
                    class_1657 player = (class_1657)class_13093;
                    class_13092 = player;
                } else {
                    class_13092 = this.obj;
                }
                if (class_13092.field_6282) {
                    class_243 diff = this.obj.method_24515().method_46558().method_1020(this.slidingPos.method_46558()).method_1029().method_1021((double)this.jumpStrength);
                    class_243 velocity = new class_243(diff.method_10216(), (double)MultiplyMovementSpeedEvent.getJumpStrength(this.obj, this.jumpStrength * (float)(this.obj instanceof class_1657 ? 3 : 2)), diff.method_10215());
                    this.use(velocity);
                    WallJumpPayload.send((class_1297)this.obj, velocity);
                    targetPos = null;
                }
            }
        }
        if (this.slidingPos != targetPos) {
            this.slidingPos = targetPos;
            WallJumpSlidingPayload.send((class_1297)this.obj, this.slidingPos);
        }
    }

    public boolean hasJumped() {
        return this.hasJumped;
    }

    public void setSlidingPos(class_2338 slidingPos) {
        this.slidingPos = slidingPos;
    }

    public boolean isSliding() {
        return this.slidingPos != null;
    }

    public void use(class_243 velocity) {
        this.obj.method_18799(velocity);
        this.obj.method_56078(class_3417.field_14560);
        this.obj.method_32876((class_6880)class_5712.field_45148);
        this.slidingPos = null;
        this.hasJumped = true;
    }
}

