/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3532;
import net.minecraft.class_9723;
import org.apache.commons.lang3.mutable.MutableFloat;

public record RageEffect(class_9723 damageDealtModifier, class_9723 damageTakenModifier, class_9723 movementSpeedModifier) {
    public static final Codec<RageEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_9723.field_51709.fieldOf("damage_dealt_modifier").forGetter(RageEffect::damageDealtModifier), (App)class_9723.field_51709.fieldOf("damage_taken_modifier").forGetter(RageEffect::damageTakenModifier), (App)class_9723.field_51709.fieldOf("movement_speed_modifier").forGetter(RageEffect::movementSpeedModifier)).apply((Applicative)instance, RageEffect::new));
    public static int color = -1;

    public static float getDamageDealtModifier(class_1309 entity, class_1799 stack) {
        MutableFloat value = new MutableFloat();
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            RageEffect effect = (RageEffect)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.RAGE);
            if (effect != null) {
                value.setValue(effect.damageDealtModifier().method_60213(level, entity.method_59922(), value.floatValue()));
            }
        });
        return (float)(10 - Math.max(3, EnchancementUtil.getFlooredHealth(entity))) * value.floatValue();
    }

    public static float getDamageDealtModifierMax(class_1309 entity, class_1799 stack) {
        MutableFloat value = new MutableFloat();
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            RageEffect effect = (RageEffect)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.RAGE);
            if (effect != null) {
                value.setValue(effect.damageDealtModifier().method_60213(level, entity.method_59922(), value.floatValue()));
            }
        });
        return 7.0f * value.floatValue();
    }

    public static int getColor(class_1297 entity, class_1799 stack) {
        float damageBonus;
        class_1309 living;
        if (entity instanceof class_1309 && !(living = (class_1309)entity).method_7325() && (damageBonus = RageEffect.getDamageDealtModifier(living, stack)) > 0.0f) {
            float other = 1.0f - damageBonus / RageEffect.getDamageDealtModifierMax(living, stack);
            return 0xFFFF0000 | ((int)((double)(other * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(other * 255.0f) + 0.5) & 0xFF;
        }
        return -1;
    }

    public static float getDamageTakenModifier(class_1309 entity, class_1799 stack) {
        if (entity == null || entity.method_7325()) {
            return 1.0f;
        }
        MutableFloat value = new MutableFloat();
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            RageEffect effect = (RageEffect)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.RAGE);
            if (effect != null) {
                value.setValue(effect.damageTakenModifier().method_60213(level, entity.method_59922(), value.floatValue()));
            }
        });
        return Math.max(0.0f, 1.0f - (float)class_3532.method_15386((float)((float)(10 - Math.max(3, EnchancementUtil.getFlooredHealth(entity))) * value.floatValue() * 100.0f)) / 100.0f);
    }

    public static float getDamageTakenModifier(class_1309 entity) {
        float value = 1.0f;
        for (class_1799 stack : EnchancementUtil.getArmorItems(entity)) {
            value *= RageEffect.getDamageTakenModifier(entity, stack);
        }
        return Math.max(0.0f, value);
    }

    public static float getMovementSpeedModifier(class_1309 entity, class_1799 stack) {
        if (entity == null || entity.method_7325()) {
            return 0.0f;
        }
        MutableFloat value = new MutableFloat();
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            RageEffect effect = (RageEffect)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.RAGE);
            if (effect != null) {
                value.setValue(effect.movementSpeedModifier().method_60213(level, entity.method_59922(), value.floatValue()));
            }
        });
        return (float)(10 - Math.max(3, EnchancementUtil.getFlooredHealth(entity))) * value.floatValue();
    }

    public static float getMovementSpeedModifier(class_1309 entity) {
        float value = 1.0f;
        for (class_1799 stack : EnchancementUtil.getArmorItems(entity)) {
            value += RageEffect.getMovementSpeedModifier(entity, stack);
        }
        return value;
    }
}

