/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_9723;
import org.apache.commons.lang3.mutable.MutableFloat;

public record ScatterShotEffect(class_9723 minimum, class_9723 maximum, class_1792 allowedProjectile) {
    public static final Codec<ScatterShotEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_9723.field_51709.fieldOf("minimum").forGetter(ScatterShotEffect::minimum), (App)class_9723.field_51709.fieldOf("maximum").forGetter(ScatterShotEffect::maximum), (App)class_7923.field_41178.method_39673().fieldOf("allowed_projectile").forGetter(ScatterShotEffect::allowedProjectile)).apply((Applicative)instance, ScatterShotEffect::new));
    public static boolean hasScatterShot = false;

    public static int getMinimum(class_5819 random, class_1799 stack) {
        MutableFloat minimum = new MutableFloat(0.0f);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            List effects = (List)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.SCATTER_SHOT);
            if (effects != null) {
                effects.forEach(effect -> minimum.setValue(((ScatterShotEffect)effect.comp_2680()).minimum().method_60213(level, random, minimum.floatValue())));
            }
        });
        return class_3532.method_15375((float)minimum.floatValue());
    }

    public static int getMinimum(class_1309 entity) {
        int count = 0;
        for (class_1799 stack : EnchancementUtil.getHeldItems(entity)) {
            count += ScatterShotEffect.getMinimum(entity.method_59922(), stack);
        }
        return count;
    }

    public static int getMinimum(class_1309 entity, class_1799 weaponStack) {
        if (entity instanceof class_1657) {
            return ScatterShotEffect.getMinimum(entity.method_59922(), weaponStack);
        }
        return ScatterShotEffect.getMinimum(entity);
    }

    public static int getMaximum(class_5819 random, class_1799 stack) {
        MutableFloat maximum = new MutableFloat(0.0f);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            List effects = (List)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.SCATTER_SHOT);
            if (effects != null) {
                effects.forEach(effect -> maximum.setValue(((ScatterShotEffect)effect.comp_2680()).maximum().method_60213(level, random, maximum.floatValue())));
            }
        });
        return class_3532.method_15375((float)maximum.floatValue());
    }

    public static int getMaximum(class_1309 entity) {
        int count = 0;
        for (class_1799 stack : EnchancementUtil.getHeldItems(entity)) {
            count += ScatterShotEffect.getMaximum(entity.method_59922(), stack);
        }
        return count;
    }

    public static int getMaximum(class_1309 shooter, class_1799 weaponStack) {
        if (shooter instanceof class_1657) {
            return ScatterShotEffect.getMaximum(shooter.method_59922(), weaponStack);
        }
        return ScatterShotEffect.getMaximum(shooter);
    }

    public static Set<class_1792> getAllowedProjectiles(class_1799 stack) {
        HashSet<class_1792> allowedProjectiles = new HashSet<class_1792>();
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> {
            List effects = (List)((class_1887)enchantment.comp_349()).comp_2689().method_58694(ModEnchantmentEffectComponentTypes.SCATTER_SHOT);
            if (effects != null) {
                effects.forEach(effect -> allowedProjectiles.add(((ScatterShotEffect)effect.comp_2680()).allowedProjectile()));
            }
        });
        return allowedProjectiles;
    }

    public static Set<class_1792> getAllowedProjectiles(class_1309 entity) {
        HashSet<class_1792> allowedProjectiles = new HashSet<class_1792>();
        for (class_1799 stack : EnchancementUtil.getHeldItems(entity)) {
            allowedProjectiles.addAll(ScatterShotEffect.getAllowedProjectiles(stack));
        }
        return allowedProjectiles;
    }

    public static Set<class_1792> getAllowedProjectiles(class_1309 entity, class_1799 weaponStack) {
        if (entity instanceof class_1657) {
            return ScatterShotEffect.getAllowedProjectiles(weaponStack);
        }
        return ScatterShotEffect.getAllowedProjectiles(entity);
    }
}

